@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudtrail.kotlin.inputs

import com.pulumi.aws.cloudtrail.inputs.TrailAdvancedEventSelectorArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property fieldSelectors Specifies the selector statements in an advanced event selector. Fields documented below.
 * @property name Name of the trail.
 */
public data class TrailAdvancedEventSelectorArgs(
    public val fieldSelectors: Output<List<TrailAdvancedEventSelectorFieldSelectorArgs>>,
    public val name: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.cloudtrail.inputs.TrailAdvancedEventSelectorArgs> {
    override fun toJava(): com.pulumi.aws.cloudtrail.inputs.TrailAdvancedEventSelectorArgs =
        com.pulumi.aws.cloudtrail.inputs.TrailAdvancedEventSelectorArgs.builder()
            .fieldSelectors(
                fieldSelectors.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TrailAdvancedEventSelectorArgs].
 */
@PulumiTagMarker
public class TrailAdvancedEventSelectorArgsBuilder internal constructor() {
    private var fieldSelectors: Output<List<TrailAdvancedEventSelectorFieldSelectorArgs>>? = null

    private var name: Output<String>? = null

    /**
     * @param value Specifies the selector statements in an advanced event selector. Fields documented below.
     */
    @JvmName("cmdkongcvfhldumm")
    public suspend fun fieldSelectors(`value`: Output<List<TrailAdvancedEventSelectorFieldSelectorArgs>>) {
        this.fieldSelectors = value
    }

    @JvmName("sabrrnukytuedack")
    public suspend fun fieldSelectors(vararg values: Output<TrailAdvancedEventSelectorFieldSelectorArgs>) {
        this.fieldSelectors = Output.all(values.asList())
    }

    /**
     * @param values Specifies the selector statements in an advanced event selector. Fields documented below.
     */
    @JvmName("lngnburwoqxxvstl")
    public suspend fun fieldSelectors(values: List<Output<TrailAdvancedEventSelectorFieldSelectorArgs>>) {
        this.fieldSelectors = Output.all(values)
    }

    /**
     * @param value Name of the trail.
     */
    @JvmName("vfqgwovclimstetm")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Specifies the selector statements in an advanced event selector. Fields documented below.
     */
    @JvmName("iygtqwgfgupgabwt")
    public suspend fun fieldSelectors(`value`: List<TrailAdvancedEventSelectorFieldSelectorArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.fieldSelectors = mapped
    }

    /**
     * @param argument Specifies the selector statements in an advanced event selector. Fields documented below.
     */
    @JvmName("rabolgsmqeutukuc")
    public suspend fun fieldSelectors(argument: List<suspend TrailAdvancedEventSelectorFieldSelectorArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            TrailAdvancedEventSelectorFieldSelectorArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.fieldSelectors = mapped
    }

    /**
     * @param argument Specifies the selector statements in an advanced event selector. Fields documented below.
     */
    @JvmName("qauiryouylpoifyh")
    public suspend fun fieldSelectors(vararg argument: suspend TrailAdvancedEventSelectorFieldSelectorArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            TrailAdvancedEventSelectorFieldSelectorArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.fieldSelectors = mapped
    }

    /**
     * @param argument Specifies the selector statements in an advanced event selector. Fields documented below.
     */
    @JvmName("tuaqvtjoavgdumay")
    public suspend fun fieldSelectors(argument: suspend TrailAdvancedEventSelectorFieldSelectorArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            TrailAdvancedEventSelectorFieldSelectorArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.fieldSelectors = mapped
    }

    /**
     * @param values Specifies the selector statements in an advanced event selector. Fields documented below.
     */
    @JvmName("gvgxndsbdegtnnnm")
    public suspend fun fieldSelectors(vararg values: TrailAdvancedEventSelectorFieldSelectorArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.fieldSelectors = mapped
    }

    /**
     * @param value Name of the trail.
     */
    @JvmName("qmrrbmdgbibbusfj")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): TrailAdvancedEventSelectorArgs = TrailAdvancedEventSelectorArgs(
        fieldSelectors = fieldSelectors ?: throw PulumiNullFieldException("fieldSelectors"),
        name = name,
    )
}
