@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudtrail.kotlin.inputs

import com.pulumi.aws.cloudtrail.inputs.TrailInsightSelectorArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property insightType Type of insights to log on a trail. Valid values are: `ApiCallRateInsight` and `ApiErrorRateInsight`.
 */
public data class TrailInsightSelectorArgs(
    public val insightType: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.cloudtrail.inputs.TrailInsightSelectorArgs> {
    override fun toJava(): com.pulumi.aws.cloudtrail.inputs.TrailInsightSelectorArgs =
        com.pulumi.aws.cloudtrail.inputs.TrailInsightSelectorArgs.builder()
            .insightType(insightType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TrailInsightSelectorArgs].
 */
@PulumiTagMarker
public class TrailInsightSelectorArgsBuilder internal constructor() {
    private var insightType: Output<String>? = null

    /**
     * @param value Type of insights to log on a trail. Valid values are: `ApiCallRateInsight` and `ApiErrorRateInsight`.
     */
    @JvmName("omjownsbhifyguox")
    public suspend fun insightType(`value`: Output<String>) {
        this.insightType = value
    }

    /**
     * @param value Type of insights to log on a trail. Valid values are: `ApiCallRateInsight` and `ApiErrorRateInsight`.
     */
    @JvmName("ouyxgvocmlcgfmle")
    public suspend fun insightType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.insightType = mapped
    }

    internal fun build(): TrailInsightSelectorArgs = TrailInsightSelectorArgs(
        insightType = insightType ?: throw PulumiNullFieldException("insightType"),
    )
}
