@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudtrail.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property fieldSelectors Specifies the selector statements in an advanced event selector. Fields documented below.
 * @property name Specifies the name of the advanced event selector.
 */
public data class EventDataStoreAdvancedEventSelector(
    public val fieldSelectors: List<EventDataStoreAdvancedEventSelectorFieldSelector>? = null,
    public val name: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.cloudtrail.outputs.EventDataStoreAdvancedEventSelector): EventDataStoreAdvancedEventSelector = EventDataStoreAdvancedEventSelector(
            fieldSelectors = javaType.fieldSelectors().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.cloudtrail.kotlin.outputs.EventDataStoreAdvancedEventSelectorFieldSelector.Companion.toKotlin(args0)
                })
            }),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
        )
    }
}
