@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudtrail.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property endsWiths A list of values that includes events that match the last few characters of the event record field specified as the value of `field`.
 * @property equals A list of values that includes events that match the exact value of the event record field specified as the value of `field`. This is the only valid operator that you can use with the `readOnly`, `eventCategory`, and `resources.type` fields.
 * @property field Specifies a field in an event record on which to filter events to be logged. You can specify only the following values: `readOnly`, `eventSource`, `eventName`, `eventCategory`, `resources.type`, `resources.ARN`.
 * @property notEndsWiths A list of values that excludes events that match the last few characters of the event record field specified as the value of `field`.
 * @property notEquals A list of values that excludes events that match the exact value of the event record field specified as the value of `field`.
 * @property notStartsWiths A list of values that excludes events that match the first few characters of the event record field specified as the value of `field`.
 * @property startsWiths A list of values that includes events that match the first few characters of the event record field specified as the value of `field`.
 */
public data class EventDataStoreAdvancedEventSelectorFieldSelector(
    public val endsWiths: List<String>? = null,
    public val equals: List<String>? = null,
    public val `field`: String? = null,
    public val notEndsWiths: List<String>? = null,
    public val notEquals: List<String>? = null,
    public val notStartsWiths: List<String>? = null,
    public val startsWiths: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.cloudtrail.outputs.EventDataStoreAdvancedEventSelectorFieldSelector): EventDataStoreAdvancedEventSelectorFieldSelector =
            EventDataStoreAdvancedEventSelectorFieldSelector(
                endsWiths = javaType.endsWiths().map({ args0 -> args0 }),
                equals = javaType.equals_().map({ args0 -> args0 }),
                `field` = javaType.`field`().map({ args0 -> args0 }).orElse(null),
                notEndsWiths = javaType.notEndsWiths().map({ args0 -> args0 }),
                notEquals = javaType.notEquals().map({ args0 -> args0 }),
                notStartsWiths = javaType.notStartsWiths().map({ args0 -> args0 }),
                startsWiths = javaType.startsWiths().map({ args0 -> args0 }),
            )
    }
}
