@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudwatch.kotlin

import com.pulumi.aws.cloudwatch.kotlin.outputs.CompositeAlarmActionsSuppressor
import com.pulumi.aws.cloudwatch.kotlin.outputs.CompositeAlarmActionsSuppressor.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [CompositeAlarm].
 */
@PulumiTagMarker
public class CompositeAlarmResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: CompositeAlarmArgs = CompositeAlarmArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend CompositeAlarmArgsBuilder.() -> Unit) {
        val builder = CompositeAlarmArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): CompositeAlarm {
        val builtJavaResource = com.pulumi.aws.cloudwatch.CompositeAlarm(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return CompositeAlarm(builtJavaResource)
    }
}

/**
 * Provides a CloudWatch Composite Alarm resource.
 * > **NOTE:** An alarm (composite or metric) cannot be destroyed when there are other composite alarms depending on it. This can lead to a cyclical dependency on update, as the provider will unsuccessfully attempt to destroy alarms before updating the rule. Consider using `depends_on`, references to alarm names, and two-stage updates.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.cloudwatch.CompositeAlarm("example", {
 *     alarmDescription: "This is a composite alarm!",
 *     alarmName: "example-composite-alarm",
 *     alarmActions: exampleAwsSnsTopic.arn,
 *     okActions: exampleAwsSnsTopic.arn,
 *     alarmRule: `ALARM(${alpha.alarmName}) OR
 * ALARM(${bravo.alarmName})
 * `,
 *     actionsSuppressor: {
 *         alarm: "suppressor-alarm",
 *         extensionPeriod: 10,
 *         waitPeriod: 20,
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.cloudwatch.CompositeAlarm("example",
 *     alarm_description="This is a composite alarm!",
 *     alarm_name="example-composite-alarm",
 *     alarm_actions=example_aws_sns_topic["arn"],
 *     ok_actions=example_aws_sns_topic["arn"],
 *     alarm_rule=f"""ALARM({alpha["alarmName"]}) OR
 * ALARM({bravo["alarmName"]})
 * """,
 *     actions_suppressor={
 *         "alarm": "suppressor-alarm",
 *         "extension_period": 10,
 *         "wait_period": 20,
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.CloudWatch.CompositeAlarm("example", new()
 *     {
 *         AlarmDescription = "This is a composite alarm!",
 *         AlarmName = "example-composite-alarm",
 *         AlarmActions = exampleAwsSnsTopic.Arn,
 *         OkActions = exampleAwsSnsTopic.Arn,
 *         AlarmRule = @$"ALARM({alpha.AlarmName}) OR
 * ALARM({bravo.AlarmName})
 * ",
 *         ActionsSuppressor = new Aws.CloudWatch.Inputs.CompositeAlarmActionsSuppressorArgs
 *         {
 *             Alarm = "suppressor-alarm",
 *             ExtensionPeriod = 10,
 *             WaitPeriod = 20,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cloudwatch"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cloudwatch.NewCompositeAlarm(ctx, "example", &cloudwatch.CompositeAlarmArgs{
 * 			AlarmDescription: pulumi.String("This is a composite alarm!"),
 * 			AlarmName:        pulumi.String("example-composite-alarm"),
 * 			AlarmActions:     pulumi.Any(exampleAwsSnsTopic.Arn),
 * 			OkActions:        pulumi.Any(exampleAwsSnsTopic.Arn),
 * 			AlarmRule:        pulumi.Sprintf("ALARM(%v) OR\nALARM(%v)\n", alpha.AlarmName, bravo.AlarmName),
 * 			ActionsSuppressor: &cloudwatch.CompositeAlarmActionsSuppressorArgs{
 * 				Alarm:           pulumi.String("suppressor-alarm"),
 * 				ExtensionPeriod: pulumi.Int(10),
 * 				WaitPeriod:      pulumi.Int(20),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudwatch.CompositeAlarm;
 * import com.pulumi.aws.cloudwatch.CompositeAlarmArgs;
 * import com.pulumi.aws.cloudwatch.inputs.CompositeAlarmActionsSuppressorArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new CompositeAlarm("example", CompositeAlarmArgs.builder()
 *             .alarmDescription("This is a composite alarm!")
 *             .alarmName("example-composite-alarm")
 *             .alarmActions(exampleAwsSnsTopic.arn())
 *             .okActions(exampleAwsSnsTopic.arn())
 *             .alarmRule("""
 * ALARM(%s) OR
 * ALARM(%s)
 * ", alpha.alarmName(),bravo.alarmName()))
 *             .actionsSuppressor(CompositeAlarmActionsSuppressorArgs.builder()
 *                 .alarm("suppressor-alarm")
 *                 .extensionPeriod(10)
 *                 .waitPeriod(20)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:cloudwatch:CompositeAlarm
 *     properties:
 *       alarmDescription: This is a composite alarm!
 *       alarmName: example-composite-alarm
 *       alarmActions: ${exampleAwsSnsTopic.arn}
 *       okActions: ${exampleAwsSnsTopic.arn}
 *       alarmRule: |
 *         ALARM(${alpha.alarmName}) OR
 *         ALARM(${bravo.alarmName})
 *       actionsSuppressor:
 *         alarm: suppressor-alarm
 *         extensionPeriod: 10
 *         waitPeriod: 20
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import a CloudWatch Composite Alarm using the `alarm_name`. For example:
 * ```sh
 * $ pulumi import aws:cloudwatch/compositeAlarm:CompositeAlarm test my-alarm
 * ```
 */
public class CompositeAlarm internal constructor(
    override val javaResource: com.pulumi.aws.cloudwatch.CompositeAlarm,
) : KotlinCustomResource(javaResource, CompositeAlarmMapper) {
    /**
     * Indicates whether actions should be executed during any changes to the alarm state of the composite alarm. Defaults to `true`.
     */
    public val actionsEnabled: Output<Boolean>?
        get() = javaResource.actionsEnabled().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Actions will be suppressed if the suppressor alarm is in the ALARM state.
     */
    public val actionsSuppressor: Output<CompositeAlarmActionsSuppressor>?
        get() = javaResource.actionsSuppressor().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> toKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The set of actions to execute when this alarm transitions to the `ALARM` state from any other state. Each action is specified as an ARN. Up to 5 actions are allowed.
     */
    public val alarmActions: Output<List<String>>?
        get() = javaResource.alarmActions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * The description for the composite alarm.
     */
    public val alarmDescription: Output<String>?
        get() = javaResource.alarmDescription().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name for the composite alarm. This name must be unique within the region.
     */
    public val alarmName: Output<String>
        get() = javaResource.alarmName().applyValue({ args0 -> args0 })

    /**
     * An expression that specifies which other alarms are to be evaluated to determine this composite alarm's state. For syntax, see [Creating a Composite Alarm](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/Create_Composite_Alarm.html). The maximum length is 10240 characters.
     */
    public val alarmRule: Output<String>
        get() = javaResource.alarmRule().applyValue({ args0 -> args0 })

    /**
     * The ARN of the composite alarm.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The set of actions to execute when this alarm transitions to the `INSUFFICIENT_DATA` state from any other state. Each action is specified as an ARN. Up to 5 actions are allowed.
     */
    public val insufficientDataActions: Output<List<String>>?
        get() = javaResource.insufficientDataActions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * The set of actions to execute when this alarm transitions to an `OK` state from any other state. Each action is specified as an ARN. Up to 5 actions are allowed.
     */
    public val okActions: Output<List<String>>?
        get() = javaResource.okActions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * A map of tags to associate with the alarm. Up to 50 tags are allowed. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object CompositeAlarmMapper : ResourceMapper<CompositeAlarm> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.cloudwatch.CompositeAlarm::class == javaResource::class

    override fun map(javaResource: Resource): CompositeAlarm = CompositeAlarm(
        javaResource as
            com.pulumi.aws.cloudwatch.CompositeAlarm,
    )
}

/**
 * @see [CompositeAlarm].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [CompositeAlarm].
 */
public suspend fun compositeAlarm(
    name: String,
    block: suspend CompositeAlarmResourceBuilder.() -> Unit,
): CompositeAlarm {
    val builder = CompositeAlarmResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [CompositeAlarm].
 * @param name The _unique_ name of the resulting resource.
 */
public fun compositeAlarm(name: String): CompositeAlarm {
    val builder = CompositeAlarmResourceBuilder()
    builder.name(name)
    return builder.build()
}
