@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudwatch.kotlin

import com.pulumi.aws.cloudwatch.CompositeAlarmArgs.builder
import com.pulumi.aws.cloudwatch.kotlin.inputs.CompositeAlarmActionsSuppressorArgs
import com.pulumi.aws.cloudwatch.kotlin.inputs.CompositeAlarmActionsSuppressorArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a CloudWatch Composite Alarm resource.
 * > **NOTE:** An alarm (composite or metric) cannot be destroyed when there are other composite alarms depending on it. This can lead to a cyclical dependency on update, as the provider will unsuccessfully attempt to destroy alarms before updating the rule. Consider using `depends_on`, references to alarm names, and two-stage updates.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.cloudwatch.CompositeAlarm("example", {
 *     alarmDescription: "This is a composite alarm!",
 *     alarmName: "example-composite-alarm",
 *     alarmActions: exampleAwsSnsTopic.arn,
 *     okActions: exampleAwsSnsTopic.arn,
 *     alarmRule: `ALARM(${alpha.alarmName}) OR
 * ALARM(${bravo.alarmName})
 * `,
 *     actionsSuppressor: {
 *         alarm: "suppressor-alarm",
 *         extensionPeriod: 10,
 *         waitPeriod: 20,
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.cloudwatch.CompositeAlarm("example",
 *     alarm_description="This is a composite alarm!",
 *     alarm_name="example-composite-alarm",
 *     alarm_actions=example_aws_sns_topic["arn"],
 *     ok_actions=example_aws_sns_topic["arn"],
 *     alarm_rule=f"""ALARM({alpha["alarmName"]}) OR
 * ALARM({bravo["alarmName"]})
 * """,
 *     actions_suppressor={
 *         "alarm": "suppressor-alarm",
 *         "extension_period": 10,
 *         "wait_period": 20,
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.CloudWatch.CompositeAlarm("example", new()
 *     {
 *         AlarmDescription = "This is a composite alarm!",
 *         AlarmName = "example-composite-alarm",
 *         AlarmActions = exampleAwsSnsTopic.Arn,
 *         OkActions = exampleAwsSnsTopic.Arn,
 *         AlarmRule = @$"ALARM({alpha.AlarmName}) OR
 * ALARM({bravo.AlarmName})
 * ",
 *         ActionsSuppressor = new Aws.CloudWatch.Inputs.CompositeAlarmActionsSuppressorArgs
 *         {
 *             Alarm = "suppressor-alarm",
 *             ExtensionPeriod = 10,
 *             WaitPeriod = 20,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cloudwatch"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cloudwatch.NewCompositeAlarm(ctx, "example", &cloudwatch.CompositeAlarmArgs{
 * 			AlarmDescription: pulumi.String("This is a composite alarm!"),
 * 			AlarmName:        pulumi.String("example-composite-alarm"),
 * 			AlarmActions:     pulumi.Any(exampleAwsSnsTopic.Arn),
 * 			OkActions:        pulumi.Any(exampleAwsSnsTopic.Arn),
 * 			AlarmRule:        pulumi.Sprintf("ALARM(%v) OR\nALARM(%v)\n", alpha.AlarmName, bravo.AlarmName),
 * 			ActionsSuppressor: &cloudwatch.CompositeAlarmActionsSuppressorArgs{
 * 				Alarm:           pulumi.String("suppressor-alarm"),
 * 				ExtensionPeriod: pulumi.Int(10),
 * 				WaitPeriod:      pulumi.Int(20),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudwatch.CompositeAlarm;
 * import com.pulumi.aws.cloudwatch.CompositeAlarmArgs;
 * import com.pulumi.aws.cloudwatch.inputs.CompositeAlarmActionsSuppressorArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new CompositeAlarm("example", CompositeAlarmArgs.builder()
 *             .alarmDescription("This is a composite alarm!")
 *             .alarmName("example-composite-alarm")
 *             .alarmActions(exampleAwsSnsTopic.arn())
 *             .okActions(exampleAwsSnsTopic.arn())
 *             .alarmRule("""
 * ALARM(%s) OR
 * ALARM(%s)
 * ", alpha.alarmName(),bravo.alarmName()))
 *             .actionsSuppressor(CompositeAlarmActionsSuppressorArgs.builder()
 *                 .alarm("suppressor-alarm")
 *                 .extensionPeriod(10)
 *                 .waitPeriod(20)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:cloudwatch:CompositeAlarm
 *     properties:
 *       alarmDescription: This is a composite alarm!
 *       alarmName: example-composite-alarm
 *       alarmActions: ${exampleAwsSnsTopic.arn}
 *       okActions: ${exampleAwsSnsTopic.arn}
 *       alarmRule: |
 *         ALARM(${alpha.alarmName}) OR
 *         ALARM(${bravo.alarmName})
 *       actionsSuppressor:
 *         alarm: suppressor-alarm
 *         extensionPeriod: 10
 *         waitPeriod: 20
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import a CloudWatch Composite Alarm using the `alarm_name`. For example:
 * ```sh
 * $ pulumi import aws:cloudwatch/compositeAlarm:CompositeAlarm test my-alarm
 * ```
 * @property actionsEnabled Indicates whether actions should be executed during any changes to the alarm state of the composite alarm. Defaults to `true`.
 * @property actionsSuppressor Actions will be suppressed if the suppressor alarm is in the ALARM state.
 * @property alarmActions The set of actions to execute when this alarm transitions to the `ALARM` state from any other state. Each action is specified as an ARN. Up to 5 actions are allowed.
 * @property alarmDescription The description for the composite alarm.
 * @property alarmName The name for the composite alarm. This name must be unique within the region.
 * @property alarmRule An expression that specifies which other alarms are to be evaluated to determine this composite alarm's state. For syntax, see [Creating a Composite Alarm](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/Create_Composite_Alarm.html). The maximum length is 10240 characters.
 * @property insufficientDataActions The set of actions to execute when this alarm transitions to the `INSUFFICIENT_DATA` state from any other state. Each action is specified as an ARN. Up to 5 actions are allowed.
 * @property okActions The set of actions to execute when this alarm transitions to an `OK` state from any other state. Each action is specified as an ARN. Up to 5 actions are allowed.
 * @property tags A map of tags to associate with the alarm. Up to 50 tags are allowed. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class CompositeAlarmArgs(
    public val actionsEnabled: Output<Boolean>? = null,
    public val actionsSuppressor: Output<CompositeAlarmActionsSuppressorArgs>? = null,
    public val alarmActions: Output<List<String>>? = null,
    public val alarmDescription: Output<String>? = null,
    public val alarmName: Output<String>? = null,
    public val alarmRule: Output<String>? = null,
    public val insufficientDataActions: Output<List<String>>? = null,
    public val okActions: Output<List<String>>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.cloudwatch.CompositeAlarmArgs> {
    override fun toJava(): com.pulumi.aws.cloudwatch.CompositeAlarmArgs =
        com.pulumi.aws.cloudwatch.CompositeAlarmArgs.builder()
            .actionsEnabled(actionsEnabled?.applyValue({ args0 -> args0 }))
            .actionsSuppressor(actionsSuppressor?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .alarmActions(alarmActions?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .alarmDescription(alarmDescription?.applyValue({ args0 -> args0 }))
            .alarmName(alarmName?.applyValue({ args0 -> args0 }))
            .alarmRule(alarmRule?.applyValue({ args0 -> args0 }))
            .insufficientDataActions(
                insufficientDataActions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .okActions(okActions?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [CompositeAlarmArgs].
 */
@PulumiTagMarker
public class CompositeAlarmArgsBuilder internal constructor() {
    private var actionsEnabled: Output<Boolean>? = null

    private var actionsSuppressor: Output<CompositeAlarmActionsSuppressorArgs>? = null

    private var alarmActions: Output<List<String>>? = null

    private var alarmDescription: Output<String>? = null

    private var alarmName: Output<String>? = null

    private var alarmRule: Output<String>? = null

    private var insufficientDataActions: Output<List<String>>? = null

    private var okActions: Output<List<String>>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Indicates whether actions should be executed during any changes to the alarm state of the composite alarm. Defaults to `true`.
     */
    @JvmName("tkbgtblqsetdpiwl")
    public suspend fun actionsEnabled(`value`: Output<Boolean>) {
        this.actionsEnabled = value
    }

    /**
     * @param value Actions will be suppressed if the suppressor alarm is in the ALARM state.
     */
    @JvmName("vrgibhewwhffqafg")
    public suspend fun actionsSuppressor(`value`: Output<CompositeAlarmActionsSuppressorArgs>) {
        this.actionsSuppressor = value
    }

    /**
     * @param value The set of actions to execute when this alarm transitions to the `ALARM` state from any other state. Each action is specified as an ARN. Up to 5 actions are allowed.
     */
    @JvmName("esbmqvktmspydjfp")
    public suspend fun alarmActions(`value`: Output<List<String>>) {
        this.alarmActions = value
    }

    @JvmName("yvtyhpxxplaojhqf")
    public suspend fun alarmActions(vararg values: Output<String>) {
        this.alarmActions = Output.all(values.asList())
    }

    /**
     * @param values The set of actions to execute when this alarm transitions to the `ALARM` state from any other state. Each action is specified as an ARN. Up to 5 actions are allowed.
     */
    @JvmName("xsvkfreoismtxraj")
    public suspend fun alarmActions(values: List<Output<String>>) {
        this.alarmActions = Output.all(values)
    }

    /**
     * @param value The description for the composite alarm.
     */
    @JvmName("hfmhgoqcfftgrldl")
    public suspend fun alarmDescription(`value`: Output<String>) {
        this.alarmDescription = value
    }

    /**
     * @param value The name for the composite alarm. This name must be unique within the region.
     */
    @JvmName("kitplclobpqowlwq")
    public suspend fun alarmName(`value`: Output<String>) {
        this.alarmName = value
    }

    /**
     * @param value An expression that specifies which other alarms are to be evaluated to determine this composite alarm's state. For syntax, see [Creating a Composite Alarm](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/Create_Composite_Alarm.html). The maximum length is 10240 characters.
     */
    @JvmName("uifbynqapvdksudi")
    public suspend fun alarmRule(`value`: Output<String>) {
        this.alarmRule = value
    }

    /**
     * @param value The set of actions to execute when this alarm transitions to the `INSUFFICIENT_DATA` state from any other state. Each action is specified as an ARN. Up to 5 actions are allowed.
     */
    @JvmName("arrljssdglnrlghg")
    public suspend fun insufficientDataActions(`value`: Output<List<String>>) {
        this.insufficientDataActions = value
    }

    @JvmName("sgbixdnpkquiiumi")
    public suspend fun insufficientDataActions(vararg values: Output<String>) {
        this.insufficientDataActions = Output.all(values.asList())
    }

    /**
     * @param values The set of actions to execute when this alarm transitions to the `INSUFFICIENT_DATA` state from any other state. Each action is specified as an ARN. Up to 5 actions are allowed.
     */
    @JvmName("dilfcqogdqedfgve")
    public suspend fun insufficientDataActions(values: List<Output<String>>) {
        this.insufficientDataActions = Output.all(values)
    }

    /**
     * @param value The set of actions to execute when this alarm transitions to an `OK` state from any other state. Each action is specified as an ARN. Up to 5 actions are allowed.
     */
    @JvmName("tglpreklhlyritkp")
    public suspend fun okActions(`value`: Output<List<String>>) {
        this.okActions = value
    }

    @JvmName("whoxbomttkkdqdsv")
    public suspend fun okActions(vararg values: Output<String>) {
        this.okActions = Output.all(values.asList())
    }

    /**
     * @param values The set of actions to execute when this alarm transitions to an `OK` state from any other state. Each action is specified as an ARN. Up to 5 actions are allowed.
     */
    @JvmName("yueupydccgdoevle")
    public suspend fun okActions(values: List<Output<String>>) {
        this.okActions = Output.all(values)
    }

    /**
     * @param value A map of tags to associate with the alarm. Up to 50 tags are allowed. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("awssgjbctheypsft")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Indicates whether actions should be executed during any changes to the alarm state of the composite alarm. Defaults to `true`.
     */
    @JvmName("ftqtbeuwgrlahxpo")
    public suspend fun actionsEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.actionsEnabled = mapped
    }

    /**
     * @param value Actions will be suppressed if the suppressor alarm is in the ALARM state.
     */
    @JvmName("cyncnfjxfqqtrvil")
    public suspend fun actionsSuppressor(`value`: CompositeAlarmActionsSuppressorArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.actionsSuppressor = mapped
    }

    /**
     * @param argument Actions will be suppressed if the suppressor alarm is in the ALARM state.
     */
    @JvmName("xwcfccmvjglbdbhx")
    public suspend fun actionsSuppressor(argument: suspend CompositeAlarmActionsSuppressorArgsBuilder.() -> Unit) {
        val toBeMapped = CompositeAlarmActionsSuppressorArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.actionsSuppressor = mapped
    }

    /**
     * @param value The set of actions to execute when this alarm transitions to the `ALARM` state from any other state. Each action is specified as an ARN. Up to 5 actions are allowed.
     */
    @JvmName("lsomnocdbobmajhr")
    public suspend fun alarmActions(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.alarmActions = mapped
    }

    /**
     * @param values The set of actions to execute when this alarm transitions to the `ALARM` state from any other state. Each action is specified as an ARN. Up to 5 actions are allowed.
     */
    @JvmName("gkajcyvfeduyunmm")
    public suspend fun alarmActions(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.alarmActions = mapped
    }

    /**
     * @param value The description for the composite alarm.
     */
    @JvmName("wxuomenfwahvfdjr")
    public suspend fun alarmDescription(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.alarmDescription = mapped
    }

    /**
     * @param value The name for the composite alarm. This name must be unique within the region.
     */
    @JvmName("mqdbhsrxbbhdmxuo")
    public suspend fun alarmName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.alarmName = mapped
    }

    /**
     * @param value An expression that specifies which other alarms are to be evaluated to determine this composite alarm's state. For syntax, see [Creating a Composite Alarm](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/Create_Composite_Alarm.html). The maximum length is 10240 characters.
     */
    @JvmName("dhodkxacduiomigr")
    public suspend fun alarmRule(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.alarmRule = mapped
    }

    /**
     * @param value The set of actions to execute when this alarm transitions to the `INSUFFICIENT_DATA` state from any other state. Each action is specified as an ARN. Up to 5 actions are allowed.
     */
    @JvmName("quwigyiijggafltr")
    public suspend fun insufficientDataActions(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.insufficientDataActions = mapped
    }

    /**
     * @param values The set of actions to execute when this alarm transitions to the `INSUFFICIENT_DATA` state from any other state. Each action is specified as an ARN. Up to 5 actions are allowed.
     */
    @JvmName("qyidopikxdnvkhtx")
    public suspend fun insufficientDataActions(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.insufficientDataActions = mapped
    }

    /**
     * @param value The set of actions to execute when this alarm transitions to an `OK` state from any other state. Each action is specified as an ARN. Up to 5 actions are allowed.
     */
    @JvmName("csqlqbrxwtypiffc")
    public suspend fun okActions(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.okActions = mapped
    }

    /**
     * @param values The set of actions to execute when this alarm transitions to an `OK` state from any other state. Each action is specified as an ARN. Up to 5 actions are allowed.
     */
    @JvmName("ujkgcrqjnseljcet")
    public suspend fun okActions(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.okActions = mapped
    }

    /**
     * @param value A map of tags to associate with the alarm. Up to 50 tags are allowed. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("jujpbekseojvgtqk")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to associate with the alarm. Up to 50 tags are allowed. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("efelrwltdgnuffme")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): CompositeAlarmArgs = CompositeAlarmArgs(
        actionsEnabled = actionsEnabled,
        actionsSuppressor = actionsSuppressor,
        alarmActions = alarmActions,
        alarmDescription = alarmDescription,
        alarmName = alarmName,
        alarmRule = alarmRule,
        insufficientDataActions = insufficientDataActions,
        okActions = okActions,
        tags = tags,
    )
}
