@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudwatch.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [EventApiDestination].
 */
@PulumiTagMarker
public class EventApiDestinationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: EventApiDestinationArgs = EventApiDestinationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend EventApiDestinationArgsBuilder.() -> Unit) {
        val builder = EventApiDestinationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): EventApiDestination {
        val builtJavaResource = com.pulumi.aws.cloudwatch.EventApiDestination(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return EventApiDestination(builtJavaResource)
    }
}

/**
 * Provides an EventBridge event API Destination resource.
 * > **Note:** EventBridge was formerly known as CloudWatch Events. The functionality is identical.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = new aws.cloudwatch.EventApiDestination("test", {
 *     name: "api-destination",
 *     description: "An API Destination",
 *     invocationEndpoint: "https://api.destination.com/endpoint",
 *     httpMethod: "POST",
 *     invocationRateLimitPerSecond: 20,
 *     connectionArn: testAwsCloudwatchEventConnection.arn,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test = aws.cloudwatch.EventApiDestination("test",
 *     name="api-destination",
 *     description="An API Destination",
 *     invocation_endpoint="https://api.destination.com/endpoint",
 *     http_method="POST",
 *     invocation_rate_limit_per_second=20,
 *     connection_arn=test_aws_cloudwatch_event_connection["arn"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new Aws.CloudWatch.EventApiDestination("test", new()
 *     {
 *         Name = "api-destination",
 *         Description = "An API Destination",
 *         InvocationEndpoint = "https://api.destination.com/endpoint",
 *         HttpMethod = "POST",
 *         InvocationRateLimitPerSecond = 20,
 *         ConnectionArn = testAwsCloudwatchEventConnection.Arn,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cloudwatch"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cloudwatch.NewEventApiDestination(ctx, "test", &cloudwatch.EventApiDestinationArgs{
 * 			Name:                         pulumi.String("api-destination"),
 * 			Description:                  pulumi.String("An API Destination"),
 * 			InvocationEndpoint:           pulumi.String("https://api.destination.com/endpoint"),
 * 			HttpMethod:                   pulumi.String("POST"),
 * 			InvocationRateLimitPerSecond: pulumi.Int(20),
 * 			ConnectionArn:                pulumi.Any(testAwsCloudwatchEventConnection.Arn),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudwatch.EventApiDestination;
 * import com.pulumi.aws.cloudwatch.EventApiDestinationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new EventApiDestination("test", EventApiDestinationArgs.builder()
 *             .name("api-destination")
 *             .description("An API Destination")
 *             .invocationEndpoint("https://api.destination.com/endpoint")
 *             .httpMethod("POST")
 *             .invocationRateLimitPerSecond(20)
 *             .connectionArn(testAwsCloudwatchEventConnection.arn())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:cloudwatch:EventApiDestination
 *     properties:
 *       name: api-destination
 *       description: An API Destination
 *       invocationEndpoint: https://api.destination.com/endpoint
 *       httpMethod: POST
 *       invocationRateLimitPerSecond: 20
 *       connectionArn: ${testAwsCloudwatchEventConnection.arn}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import EventBridge API Destinations using the `name`. For example:
 * ```sh
 * $ pulumi import aws:cloudwatch/eventApiDestination:EventApiDestination test api-destination
 * ```
 */
public class EventApiDestination internal constructor(
    override val javaResource: com.pulumi.aws.cloudwatch.EventApiDestination,
) : KotlinCustomResource(javaResource, EventApiDestinationMapper) {
    /**
     * The Amazon Resource Name (ARN) of the event API Destination.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * ARN of the EventBridge Connection to use for the API Destination.
     */
    public val connectionArn: Output<String>
        get() = javaResource.connectionArn().applyValue({ args0 -> args0 })

    /**
     * The description of the new API Destination. Maximum of 512 characters.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Select the HTTP method used for the invocation endpoint, such as GET, POST, PUT, etc.
     */
    public val httpMethod: Output<String>
        get() = javaResource.httpMethod().applyValue({ args0 -> args0 })

    /**
     * URL endpoint to invoke as a target. This could be a valid endpoint generated by a partner service. You can include "*" as path parameters wildcards to be set from the Target HttpParameters.
     */
    public val invocationEndpoint: Output<String>
        get() = javaResource.invocationEndpoint().applyValue({ args0 -> args0 })

    /**
     * Enter the maximum number of invocations per second to allow for this destination. Enter a value greater than 0 (default 300).
     */
    public val invocationRateLimitPerSecond: Output<Int>?
        get() = javaResource.invocationRateLimitPerSecond().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the new API Destination. The name must be unique for your account. Maximum of 64 characters consisting of numbers, lower/upper case letters, .,-,_.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })
}

public object EventApiDestinationMapper : ResourceMapper<EventApiDestination> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.cloudwatch.EventApiDestination::class == javaResource::class

    override fun map(javaResource: Resource): EventApiDestination = EventApiDestination(
        javaResource
            as com.pulumi.aws.cloudwatch.EventApiDestination,
    )
}

/**
 * @see [EventApiDestination].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [EventApiDestination].
 */
public suspend fun eventApiDestination(
    name: String,
    block: suspend EventApiDestinationResourceBuilder.() -> Unit,
): EventApiDestination {
    val builder = EventApiDestinationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [EventApiDestination].
 * @param name The _unique_ name of the resulting resource.
 */
public fun eventApiDestination(name: String): EventApiDestination {
    val builder = EventApiDestinationResourceBuilder()
    builder.name(name)
    return builder.build()
}
