@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudwatch.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [EventBus].
 */
@PulumiTagMarker
public class EventBusResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: EventBusArgs = EventBusArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend EventBusArgsBuilder.() -> Unit) {
        val builder = EventBusArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): EventBus {
        val builtJavaResource = com.pulumi.aws.cloudwatch.EventBus(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return EventBus(builtJavaResource)
    }
}

/**
 * Provides an EventBridge event bus resource.
 * > **Note:** EventBridge was formerly known as CloudWatch Events. The functionality is identical.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const messenger = new aws.cloudwatch.EventBus("messenger", {name: "chat-messages"});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * messenger = aws.cloudwatch.EventBus("messenger", name="chat-messages")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var messenger = new Aws.CloudWatch.EventBus("messenger", new()
 *     {
 *         Name = "chat-messages",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cloudwatch"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cloudwatch.NewEventBus(ctx, "messenger", &cloudwatch.EventBusArgs{
 * 			Name: pulumi.String("chat-messages"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudwatch.EventBus;
 * import com.pulumi.aws.cloudwatch.EventBusArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var messenger = new EventBus("messenger", EventBusArgs.builder()
 *             .name("chat-messages")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   messenger:
 *     type: aws:cloudwatch:EventBus
 *     properties:
 *       name: chat-messages
 * ```
 * <!--End PulumiCodeChooser -->
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const examplepartner = aws.cloudwatch.getEventSource({
 *     namePrefix: "aws.partner/examplepartner.com",
 * });
 * const examplepartnerEventBus = new aws.cloudwatch.EventBus("examplepartner", {
 *     name: examplepartner.then(examplepartner => examplepartner.name),
 *     eventSourceName: examplepartner.then(examplepartner => examplepartner.name),
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * examplepartner = aws.cloudwatch.get_event_source(name_prefix="aws.partner/examplepartner.com")
 * examplepartner_event_bus = aws.cloudwatch.EventBus("examplepartner",
 *     name=examplepartner.name,
 *     event_source_name=examplepartner.name)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var examplepartner = Aws.CloudWatch.GetEventSource.Invoke(new()
 *     {
 *         NamePrefix = "aws.partner/examplepartner.com",
 *     });
 *     var examplepartnerEventBus = new Aws.CloudWatch.EventBus("examplepartner", new()
 *     {
 *         Name = examplepartner.Apply(getEventSourceResult => getEventSourceResult.Name),
 *         EventSourceName = examplepartner.Apply(getEventSourceResult => getEventSourceResult.Name),
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cloudwatch"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		examplepartner, err := cloudwatch.GetEventSource(ctx, &cloudwatch.GetEventSourceArgs{
 * 			NamePrefix: pulumi.StringRef("aws.partner/examplepartner.com"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = cloudwatch.NewEventBus(ctx, "examplepartner", &cloudwatch.EventBusArgs{
 * 			Name:            pulumi.String(examplepartner.Name),
 * 			EventSourceName: pulumi.String(examplepartner.Name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudwatch.CloudwatchFunctions;
 * import com.pulumi.aws.cloudwatch.inputs.GetEventSourceArgs;
 * import com.pulumi.aws.cloudwatch.EventBus;
 * import com.pulumi.aws.cloudwatch.EventBusArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var examplepartner = CloudwatchFunctions.getEventSource(GetEventSourceArgs.builder()
 *             .namePrefix("aws.partner/examplepartner.com")
 *             .build());
 *         var examplepartnerEventBus = new EventBus("examplepartnerEventBus", EventBusArgs.builder()
 *             .name(examplepartner.applyValue(getEventSourceResult -> getEventSourceResult.name()))
 *             .eventSourceName(examplepartner.applyValue(getEventSourceResult -> getEventSourceResult.name()))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   examplepartnerEventBus:
 *     type: aws:cloudwatch:EventBus
 *     name: examplepartner
 *     properties:
 *       name: ${examplepartner.name}
 *       eventSourceName: ${examplepartner.name}
 * variables:
 *   examplepartner:
 *     fn::invoke:
 *       Function: aws:cloudwatch:getEventSource
 *       Arguments:
 *         namePrefix: aws.partner/examplepartner.com
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import EventBridge event buses using the `name` (which can also be a partner event source name). For example:
 * ```sh
 * $ pulumi import aws:cloudwatch/eventBus:EventBus messenger chat-messages
 * ```
 */
public class EventBus internal constructor(
    override val javaResource: com.pulumi.aws.cloudwatch.EventBus,
) : KotlinCustomResource(javaResource, EventBusMapper) {
    /**
     * The Amazon Resource Name (ARN) of the event bus.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The partner event source that the new event bus will be matched with. Must match `name`.
     */
    public val eventSourceName: Output<String>?
        get() = javaResource.eventSourceName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The identifier of the AWS KMS customer managed key for EventBridge to use, if you choose to use a customer managed key to encrypt events on this event bus. The identifier can be the key Amazon Resource Name (ARN), KeyId, key alias, or key alias ARN.
     */
    public val kmsKeyIdentifier: Output<String>?
        get() = javaResource.kmsKeyIdentifier().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the new event bus. The names of custom event buses can't contain the / character. To create a partner event bus, ensure the `name` matches the `event_source_name`.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object EventBusMapper : ResourceMapper<EventBus> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.cloudwatch.EventBus::class == javaResource::class

    override fun map(javaResource: Resource): EventBus = EventBus(
        javaResource as
            com.pulumi.aws.cloudwatch.EventBus,
    )
}

/**
 * @see [EventBus].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [EventBus].
 */
public suspend fun eventBus(name: String, block: suspend EventBusResourceBuilder.() -> Unit): EventBus {
    val builder = EventBusResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [EventBus].
 * @param name The _unique_ name of the resulting resource.
 */
public fun eventBus(name: String): EventBus {
    val builder = EventBusResourceBuilder()
    builder.name(name)
    return builder.build()
}
