@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudwatch.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [EventBusPolicy].
 */
@PulumiTagMarker
public class EventBusPolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: EventBusPolicyArgs = EventBusPolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend EventBusPolicyArgsBuilder.() -> Unit) {
        val builder = EventBusPolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): EventBusPolicy {
        val builtJavaResource = com.pulumi.aws.cloudwatch.EventBusPolicy(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return EventBusPolicy(builtJavaResource)
    }
}

/**
 * Provides a resource to create an EventBridge resource policy to support cross-account events.
 * > **Note:** EventBridge was formerly known as CloudWatch Events. The functionality is identical.
 * > **Note:** The EventBridge bus policy resource  (`aws.cloudwatch.EventBusPolicy`) is incompatible with the EventBridge permission resource (`aws.cloudwatch.EventPermission`) and will overwrite permissions.
 * ## Example Usage
 * ### Account Access
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = aws.iam.getPolicyDocument({
 *     statements: [{
 *         sid: "DevAccountAccess",
 *         effect: "Allow",
 *         actions: ["events:PutEvents"],
 *         resources: ["arn:aws:events:eu-west-1:123456789012:event-bus/default"],
 *         principals: [{
 *             type: "AWS",
 *             identifiers: ["123456789012"],
 *         }],
 *     }],
 * });
 * const testEventBusPolicy = new aws.cloudwatch.EventBusPolicy("test", {
 *     policy: test.then(test => test.json),
 *     eventBusName: testAwsCloudwatchEventBus.name,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test = aws.iam.get_policy_document(statements=[{
 *     "sid": "DevAccountAccess",
 *     "effect": "Allow",
 *     "actions": ["events:PutEvents"],
 *     "resources": ["arn:aws:events:eu-west-1:123456789012:event-bus/default"],
 *     "principals": [{
 *         "type": "AWS",
 *         "identifiers": ["123456789012"],
 *     }],
 * }])
 * test_event_bus_policy = aws.cloudwatch.EventBusPolicy("test",
 *     policy=test.json,
 *     event_bus_name=test_aws_cloudwatch_event_bus["name"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = Aws.Iam.GetPolicyDocument.Invoke(new()
 *     {
 *         Statements = new[]
 *         {
 *             new Aws.Iam.Inputs.GetPolicyDocumentStatementInputArgs
 *             {
 *                 Sid = "DevAccountAccess",
 *                 Effect = "Allow",
 *                 Actions = new[]
 *                 {
 *                     "events:PutEvents",
 *                 },
 *                 Resources = new[]
 *                 {
 *                     "arn:aws:events:eu-west-1:123456789012:event-bus/default",
 *                 },
 *                 Principals = new[]
 *                 {
 *                     new Aws.Iam.Inputs.GetPolicyDocumentStatementPrincipalInputArgs
 *                     {
 *                         Type = "AWS",
 *                         Identifiers = new[]
 *                         {
 *                             "123456789012",
 *                         },
 *                     },
 *                 },
 *             },
 *         },
 *     });
 *     var testEventBusPolicy = new Aws.CloudWatch.EventBusPolicy("test", new()
 *     {
 *         Policy = test.Apply(getPolicyDocumentResult => getPolicyDocumentResult.Json),
 *         EventBusName = testAwsCloudwatchEventBus.Name,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cloudwatch"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		test, err := iam.GetPolicyDocument(ctx, &iam.GetPolicyDocumentArgs{
 * 			Statements: []iam.GetPolicyDocumentStatement{
 * 				{
 * 					Sid:    pulumi.StringRef("DevAccountAccess"),
 * 					Effect: pulumi.StringRef("Allow"),
 * 					Actions: []string{
 * 						"events:PutEvents",
 * 					},
 * 					Resources: []string{
 * 						"arn:aws:events:eu-west-1:123456789012:event-bus/default",
 * 					},
 * 					Principals: []iam.GetPolicyDocumentStatementPrincipal{
 * 						{
 * 							Type: "AWS",
 * 							Identifiers: []string{
 * 								"123456789012",
 * 							},
 * 						},
 * 					},
 * 				},
 * 			},
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = cloudwatch.NewEventBusPolicy(ctx, "test", &cloudwatch.EventBusPolicyArgs{
 * 			Policy:       pulumi.String(test.Json),
 * 			EventBusName: pulumi.Any(testAwsCloudwatchEventBus.Name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.cloudwatch.EventBusPolicy;
 * import com.pulumi.aws.cloudwatch.EventBusPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var test = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .sid("DevAccountAccess")
 *                 .effect("Allow")
 *                 .actions("events:PutEvents")
 *                 .resources("arn:aws:events:eu-west-1:123456789012:event-bus/default")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("AWS")
 *                     .identifiers("123456789012")
 *                     .build())
 *                 .build())
 *             .build());
 *         var testEventBusPolicy = new EventBusPolicy("testEventBusPolicy", EventBusPolicyArgs.builder()
 *             .policy(test.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .eventBusName(testAwsCloudwatchEventBus.name())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   testEventBusPolicy:
 *     type: aws:cloudwatch:EventBusPolicy
 *     name: test
 *     properties:
 *       policy: ${test.json}
 *       eventBusName: ${testAwsCloudwatchEventBus.name}
 * variables:
 *   test:
 *     fn::invoke:
 *       Function: aws:iam:getPolicyDocument
 *       Arguments:
 *         statements:
 *           - sid: DevAccountAccess
 *             effect: Allow
 *             actions:
 *               - events:PutEvents
 *             resources:
 *               - arn:aws:events:eu-west-1:123456789012:event-bus/default
 *             principals:
 *               - type: AWS
 *                 identifiers:
 *                   - '123456789012'
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Organization Access
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = aws.iam.getPolicyDocument({
 *     statements: [{
 *         sid: "OrganizationAccess",
 *         effect: "Allow",
 *         actions: [
 *             "events:DescribeRule",
 *             "events:ListRules",
 *             "events:ListTargetsByRule",
 *             "events:ListTagsForResource",
 *         ],
 *         resources: [
 *             "arn:aws:events:eu-west-1:123456789012:rule/*",
 *             "arn:aws:events:eu-west-1:123456789012:event-bus/default",
 *         ],
 *         principals: [{
 *             type: "AWS",
 *             identifiers: ["*"],
 *         }],
 *         conditions: [{
 *             test: "StringEquals",
 *             variable: "aws:PrincipalOrgID",
 *             values: [example&#46;id],
 *         }],
 *     }],
 * });
 * const testEventBusPolicy = new aws.cloudwatch.EventBusPolicy("test", {
 *     policy: test.then(test => test.json),
 *     eventBusName: testAwsCloudwatchEventBus.name,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test = aws.iam.get_policy_document(statements=[{
 *     "sid": "OrganizationAccess",
 *     "effect": "Allow",
 *     "actions": [
 *         "events:DescribeRule",
 *         "events:ListRules",
 *         "events:ListTargetsByRule",
 *         "events:ListTagsForResource",
 *     ],
 *     "resources": [
 *         "arn:aws:events:eu-west-1:123456789012:rule/*",
 *         "arn:aws:events:eu-west-1:123456789012:event-bus/default",
 *     ],
 *     "principals": [{
 *         "type": "AWS",
 *         "identifiers": ["*"],
 *     }],
 *     "conditions": [{
 *         "test": "StringEquals",
 *         "variable": "aws:PrincipalOrgID",
 *         "values": [example["id"]],
 *     }],
 * }])
 * test_event_bus_policy = aws.cloudwatch.EventBusPolicy("test",
 *     policy=test.json,
 *     event_bus_name=test_aws_cloudwatch_event_bus["name"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = Aws.Iam.GetPolicyDocument.Invoke(new()
 *     {
 *         Statements = new[]
 *         {
 *             new Aws.Iam.Inputs.GetPolicyDocumentStatementInputArgs
 *             {
 *                 Sid = "OrganizationAccess",
 *                 Effect = "Allow",
 *                 Actions = new[]
 *                 {
 *                     "events:DescribeRule",
 *                     "events:ListRules",
 *                     "events:ListTargetsByRule",
 *                     "events:ListTagsForResource",
 *                 },
 *                 Resources = new[]
 *                 {
 *                     "arn:aws:events:eu-west-1:123456789012:rule/*",
 *                     "arn:aws:events:eu-west-1:123456789012:event-bus/default",
 *                 },
 *                 Principals = new[]
 *                 {
 *                     new Aws.Iam.Inputs.GetPolicyDocumentStatementPrincipalInputArgs
 *                     {
 *                         Type = "AWS",
 *                         Identifiers = new[]
 *                         {
 *                             "*",
 *                         },
 *                     },
 *                 },
 *                 Conditions = new[]
 *                 {
 *                     new Aws.Iam.Inputs.GetPolicyDocumentStatementConditionInputArgs
 *                     {
 *                         Test = "StringEquals",
 *                         Variable = "aws:PrincipalOrgID",
 *                         Values = new[]
 *                         {
 *                             example.Id,
 *                         },
 *                     },
 *                 },
 *             },
 *         },
 *     });
 *     var testEventBusPolicy = new Aws.CloudWatch.EventBusPolicy("test", new()
 *     {
 *         Policy = test.Apply(getPolicyDocumentResult => getPolicyDocumentResult.Json),
 *         EventBusName = testAwsCloudwatchEventBus.Name,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cloudwatch"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * test, err := iam.GetPolicyDocument(ctx, &iam.GetPolicyDocumentArgs{
 * Statements: []iam.GetPolicyDocumentStatement{
 * {
 * Sid: pulumi.StringRef("OrganizationAccess"),
 * Effect: pulumi.StringRef("Allow"),
 * Actions: []string{
 * "events:DescribeRule",
 * "events:ListRules",
 * "events:ListTargetsByRule",
 * "events:ListTagsForResource",
 * },
 * Resources: []string{
 * "arn:aws:events:eu-west-1:123456789012:rule/*",
 * "arn:aws:events:eu-west-1:123456789012:event-bus/default",
 * },
 * Principals: []iam.GetPolicyDocumentStatementPrincipal{
 * {
 * Type: "AWS",
 * Identifiers: []string{
 * "*",
 * },
 * },
 * },
 * Conditions: []iam.GetPolicyDocumentStatementCondition{
 * {
 * Test: "StringEquals",
 * Variable: "aws:PrincipalOrgID",
 * Values: interface{}{
 * example.Id,
 * },
 * },
 * },
 * },
 * },
 * }, nil);
 * if err != nil {
 * return err
 * }
 * _, err = cloudwatch.NewEventBusPolicy(ctx, "test", &cloudwatch.EventBusPolicyArgs{
 * Policy: pulumi.String(test.Json),
 * EventBusName: pulumi.Any(testAwsCloudwatchEventBus.Name),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.cloudwatch.EventBusPolicy;
 * import com.pulumi.aws.cloudwatch.EventBusPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var test = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .sid("OrganizationAccess")
 *                 .effect("Allow")
 *                 .actions(
 *                     "events:DescribeRule",
 *                     "events:ListRules",
 *                     "events:ListTargetsByRule",
 *                     "events:ListTagsForResource")
 *                 .resources(
 *                     "arn:aws:events:eu-west-1:123456789012:rule/*",
 *                     "arn:aws:events:eu-west-1:123456789012:event-bus/default")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("AWS")
 *                     .identifiers("*")
 *                     .build())
 *                 .conditions(GetPolicyDocumentStatementConditionArgs.builder()
 *                     .test("StringEquals")
 *                     .variable("aws:PrincipalOrgID")
 *                     .values(example.id())
 *                     .build())
 *                 .build())
 *             .build());
 *         var testEventBusPolicy = new EventBusPolicy("testEventBusPolicy", EventBusPolicyArgs.builder()
 *             .policy(test.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .eventBusName(testAwsCloudwatchEventBus.name())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   testEventBusPolicy:
 *     type: aws:cloudwatch:EventBusPolicy
 *     name: test
 *     properties:
 *       policy: ${test.json}
 *       eventBusName: ${testAwsCloudwatchEventBus.name}
 * variables:
 *   test:
 *     fn::invoke:
 *       Function: aws:iam:getPolicyDocument
 *       Arguments:
 *         statements:
 *           - sid: OrganizationAccess
 *             effect: Allow
 *             actions:
 *               - events:DescribeRule
 *               - events:ListRules
 *               - events:ListTargetsByRule
 *               - events:ListTagsForResource
 *             resources:
 *               - arn:aws:events:eu-west-1:123456789012:rule/*
 *               - arn:aws:events:eu-west-1:123456789012:event-bus/default
 *             principals:
 *               - type: AWS
 *                 identifiers:
 *                   - '*'
 *             conditions:
 *               - test: StringEquals
 *                 variable: aws:PrincipalOrgID
 *                 values:
 *                   - ${example.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Multiple Statements
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = aws.iam.getPolicyDocument({
 *     statements: [
 *         {
 *             sid: "DevAccountAccess",
 *             effect: "Allow",
 *             actions: ["events:PutEvents"],
 *             resources: ["arn:aws:events:eu-west-1:123456789012:event-bus/default"],
 *             principals: [{
 *                 type: "AWS",
 *                 identifiers: ["123456789012"],
 *             }],
 *         },
 *         {
 *             sid: "OrganizationAccess",
 *             effect: "Allow",
 *             actions: [
 *                 "events:DescribeRule",
 *                 "events:ListRules",
 *                 "events:ListTargetsByRule",
 *                 "events:ListTagsForResource",
 *             ],
 *             resources: [
 *                 "arn:aws:events:eu-west-1:123456789012:rule/*",
 *                 "arn:aws:events:eu-west-1:123456789012:event-bus/default",
 *             ],
 *             principals: [{
 *                 type: "AWS",
 *                 identifiers: ["*"],
 *             }],
 *             conditions: [{
 *                 test: "StringEquals",
 *                 variable: "aws:PrincipalOrgID",
 *                 values: [example&#46;id],
 *             }],
 *         },
 *     ],
 * });
 * const testEventBusPolicy = new aws.cloudwatch.EventBusPolicy("test", {
 *     policy: test.then(test => test.json),
 *     eventBusName: testAwsCloudwatchEventBus.name,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test = aws.iam.get_policy_document(statements=[
 *     {
 *         "sid": "DevAccountAccess",
 *         "effect": "Allow",
 *         "actions": ["events:PutEvents"],
 *         "resources": ["arn:aws:events:eu-west-1:123456789012:event-bus/default"],
 *         "principals": [{
 *             "type": "AWS",
 *             "identifiers": ["123456789012"],
 *         }],
 *     },
 *     {
 *         "sid": "OrganizationAccess",
 *         "effect": "Allow",
 *         "actions": [
 *             "events:DescribeRule",
 *             "events:ListRules",
 *             "events:ListTargetsByRule",
 *             "events:ListTagsForResource",
 *         ],
 *         "resources": [
 *             "arn:aws:events:eu-west-1:123456789012:rule/*",
 *             "arn:aws:events:eu-west-1:123456789012:event-bus/default",
 *         ],
 *         "principals": [{
 *             "type": "AWS",
 *             "identifiers": ["*"],
 *         }],
 *         "conditions": [{
 *             "test": "StringEquals",
 *             "variable": "aws:PrincipalOrgID",
 *             "values": [example["id"]],
 *         }],
 *     },
 * ])
 * test_event_bus_policy = aws.cloudwatch.EventBusPolicy("test",
 *     policy=test.json,
 *     event_bus_name=test_aws_cloudwatch_event_bus["name"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = Aws.Iam.GetPolicyDocument.Invoke(new()
 *     {
 *         Statements = new[]
 *         {
 *             new Aws.Iam.Inputs.GetPolicyDocumentStatementInputArgs
 *             {
 *                 Sid = "DevAccountAccess",
 *                 Effect = "Allow",
 *                 Actions = new[]
 *                 {
 *                     "events:PutEvents",
 *                 },
 *                 Resources = new[]
 *                 {
 *                     "arn:aws:events:eu-west-1:123456789012:event-bus/default",
 *                 },
 *                 Principals = new[]
 *                 {
 *                     new Aws.Iam.Inputs.GetPolicyDocumentStatementPrincipalInputArgs
 *                     {
 *                         Type = "AWS",
 *                         Identifiers = new[]
 *                         {
 *                             "123456789012",
 *                         },
 *                     },
 *                 },
 *             },
 *             new Aws.Iam.Inputs.GetPolicyDocumentStatementInputArgs
 *             {
 *                 Sid = "OrganizationAccess",
 *                 Effect = "Allow",
 *                 Actions = new[]
 *                 {
 *                     "events:DescribeRule",
 *                     "events:ListRules",
 *                     "events:ListTargetsByRule",
 *                     "events:ListTagsForResource",
 *                 },
 *                 Resources = new[]
 *                 {
 *                     "arn:aws:events:eu-west-1:123456789012:rule/*",
 *                     "arn:aws:events:eu-west-1:123456789012:event-bus/default",
 *                 },
 *                 Principals = new[]
 *                 {
 *                     new Aws.Iam.Inputs.GetPolicyDocumentStatementPrincipalInputArgs
 *                     {
 *                         Type = "AWS",
 *                         Identifiers = new[]
 *                         {
 *                             "*",
 *                         },
 *                     },
 *                 },
 *                 Conditions = new[]
 *                 {
 *                     new Aws.Iam.Inputs.GetPolicyDocumentStatementConditionInputArgs
 *                     {
 *                         Test = "StringEquals",
 *                         Variable = "aws:PrincipalOrgID",
 *                         Values = new[]
 *                         {
 *                             example.Id,
 *                         },
 *                     },
 *                 },
 *             },
 *         },
 *     });
 *     var testEventBusPolicy = new Aws.CloudWatch.EventBusPolicy("test", new()
 *     {
 *         Policy = test.Apply(getPolicyDocumentResult => getPolicyDocumentResult.Json),
 *         EventBusName = testAwsCloudwatchEventBus.Name,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cloudwatch"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * test, err := iam.GetPolicyDocument(ctx, &iam.GetPolicyDocumentArgs{
 * Statements: []iam.GetPolicyDocumentStatement{
 * {
 * Sid: pulumi.StringRef("DevAccountAccess"),
 * Effect: pulumi.StringRef("Allow"),
 * Actions: []string{
 * "events:PutEvents",
 * },
 * Resources: []string{
 * "arn:aws:events:eu-west-1:123456789012:event-bus/default",
 * },
 * Principals: []iam.GetPolicyDocumentStatementPrincipal{
 * {
 * Type: "AWS",
 * Identifiers: []string{
 * "123456789012",
 * },
 * },
 * },
 * },
 * {
 * Sid: pulumi.StringRef("OrganizationAccess"),
 * Effect: pulumi.StringRef("Allow"),
 * Actions: []string{
 * "events:DescribeRule",
 * "events:ListRules",
 * "events:ListTargetsByRule",
 * "events:ListTagsForResource",
 * },
 * Resources: []string{
 * "arn:aws:events:eu-west-1:123456789012:rule/*",
 * "arn:aws:events:eu-west-1:123456789012:event-bus/default",
 * },
 * Principals: []iam.GetPolicyDocumentStatementPrincipal{
 * {
 * Type: "AWS",
 * Identifiers: []string{
 * "*",
 * },
 * },
 * },
 * Conditions: []iam.GetPolicyDocumentStatementCondition{
 * {
 * Test: "StringEquals",
 * Variable: "aws:PrincipalOrgID",
 * Values: interface{}{
 * example.Id,
 * },
 * },
 * },
 * },
 * },
 * }, nil);
 * if err != nil {
 * return err
 * }
 * _, err = cloudwatch.NewEventBusPolicy(ctx, "test", &cloudwatch.EventBusPolicyArgs{
 * Policy: pulumi.String(test.Json),
 * EventBusName: pulumi.Any(testAwsCloudwatchEventBus.Name),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.cloudwatch.EventBusPolicy;
 * import com.pulumi.aws.cloudwatch.EventBusPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var test = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(
 *                 GetPolicyDocumentStatementArgs.builder()
 *                     .sid("DevAccountAccess")
 *                     .effect("Allow")
 *                     .actions("events:PutEvents")
 *                     .resources("arn:aws:events:eu-west-1:123456789012:event-bus/default")
 *                     .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                         .type("AWS")
 *                         .identifiers("123456789012")
 *                         .build())
 *                     .build(),
 *                 GetPolicyDocumentStatementArgs.builder()
 *                     .sid("OrganizationAccess")
 *                     .effect("Allow")
 *                     .actions(
 *                         "events:DescribeRule",
 *                         "events:ListRules",
 *                         "events:ListTargetsByRule",
 *                         "events:ListTagsForResource")
 *                     .resources(
 *                         "arn:aws:events:eu-west-1:123456789012:rule/*",
 *                         "arn:aws:events:eu-west-1:123456789012:event-bus/default")
 *                     .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                         .type("AWS")
 *                         .identifiers("*")
 *                         .build())
 *                     .conditions(GetPolicyDocumentStatementConditionArgs.builder()
 *                         .test("StringEquals")
 *                         .variable("aws:PrincipalOrgID")
 *                         .values(example.id())
 *                         .build())
 *                     .build())
 *             .build());
 *         var testEventBusPolicy = new EventBusPolicy("testEventBusPolicy", EventBusPolicyArgs.builder()
 *             .policy(test.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .eventBusName(testAwsCloudwatchEventBus.name())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   testEventBusPolicy:
 *     type: aws:cloudwatch:EventBusPolicy
 *     name: test
 *     properties:
 *       policy: ${test.json}
 *       eventBusName: ${testAwsCloudwatchEventBus.name}
 * variables:
 *   test:
 *     fn::invoke:
 *       Function: aws:iam:getPolicyDocument
 *       Arguments:
 *         statements:
 *           - sid: DevAccountAccess
 *             effect: Allow
 *             actions:
 *               - events:PutEvents
 *             resources:
 *               - arn:aws:events:eu-west-1:123456789012:event-bus/default
 *             principals:
 *               - type: AWS
 *                 identifiers:
 *                   - '123456789012'
 *           - sid: OrganizationAccess
 *             effect: Allow
 *             actions:
 *               - events:DescribeRule
 *               - events:ListRules
 *               - events:ListTargetsByRule
 *               - events:ListTagsForResource
 *             resources:
 *               - arn:aws:events:eu-west-1:123456789012:rule/*
 *               - arn:aws:events:eu-west-1:123456789012:event-bus/default
 *             principals:
 *               - type: AWS
 *                 identifiers:
 *                   - '*'
 *             conditions:
 *               - test: StringEquals
 *                 variable: aws:PrincipalOrgID
 *                 values:
 *                   - ${example.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import an EventBridge policy using the `event_bus_name`. For example:
 * ```sh
 * $ pulumi import aws:cloudwatch/eventBusPolicy:EventBusPolicy DevAccountAccess example-event-bus
 * ```
 * */*/*/*/*/*/*/*/*/*/*/*/
 */
public class EventBusPolicy internal constructor(
    override val javaResource: com.pulumi.aws.cloudwatch.EventBusPolicy,
) : KotlinCustomResource(javaResource, EventBusPolicyMapper) {
    /**
     * The name of the event bus to set the permissions on.
     * If you omit this, the permissions are set on the `default` event bus.
     */
    public val eventBusName: Output<String>?
        get() = javaResource.eventBusName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The text of the policy.
     */
    public val policy: Output<String>
        get() = javaResource.policy().applyValue({ args0 -> args0 })
}

public object EventBusPolicyMapper : ResourceMapper<EventBusPolicy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.cloudwatch.EventBusPolicy::class == javaResource::class

    override fun map(javaResource: Resource): EventBusPolicy = EventBusPolicy(
        javaResource as
            com.pulumi.aws.cloudwatch.EventBusPolicy,
    )
}

/**
 * @see [EventBusPolicy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [EventBusPolicy].
 */
public suspend fun eventBusPolicy(
    name: String,
    block: suspend EventBusPolicyResourceBuilder.() -> Unit,
): EventBusPolicy {
    val builder = EventBusPolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [EventBusPolicy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun eventBusPolicy(name: String): EventBusPolicy {
    val builder = EventBusPolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
