@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudwatch.kotlin

import com.pulumi.aws.cloudwatch.EventBusPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a resource to create an EventBridge resource policy to support cross-account events.
 * > **Note:** EventBridge was formerly known as CloudWatch Events. The functionality is identical.
 * > **Note:** The EventBridge bus policy resource  (`aws.cloudwatch.EventBusPolicy`) is incompatible with the EventBridge permission resource (`aws.cloudwatch.EventPermission`) and will overwrite permissions.
 * ## Example Usage
 * ### Account Access
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = aws.iam.getPolicyDocument({
 *     statements: [{
 *         sid: "DevAccountAccess",
 *         effect: "Allow",
 *         actions: ["events:PutEvents"],
 *         resources: ["arn:aws:events:eu-west-1:123456789012:event-bus/default"],
 *         principals: [{
 *             type: "AWS",
 *             identifiers: ["123456789012"],
 *         }],
 *     }],
 * });
 * const testEventBusPolicy = new aws.cloudwatch.EventBusPolicy("test", {
 *     policy: test.then(test => test.json),
 *     eventBusName: testAwsCloudwatchEventBus.name,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test = aws.iam.get_policy_document(statements=[{
 *     "sid": "DevAccountAccess",
 *     "effect": "Allow",
 *     "actions": ["events:PutEvents"],
 *     "resources": ["arn:aws:events:eu-west-1:123456789012:event-bus/default"],
 *     "principals": [{
 *         "type": "AWS",
 *         "identifiers": ["123456789012"],
 *     }],
 * }])
 * test_event_bus_policy = aws.cloudwatch.EventBusPolicy("test",
 *     policy=test.json,
 *     event_bus_name=test_aws_cloudwatch_event_bus["name"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = Aws.Iam.GetPolicyDocument.Invoke(new()
 *     {
 *         Statements = new[]
 *         {
 *             new Aws.Iam.Inputs.GetPolicyDocumentStatementInputArgs
 *             {
 *                 Sid = "DevAccountAccess",
 *                 Effect = "Allow",
 *                 Actions = new[]
 *                 {
 *                     "events:PutEvents",
 *                 },
 *                 Resources = new[]
 *                 {
 *                     "arn:aws:events:eu-west-1:123456789012:event-bus/default",
 *                 },
 *                 Principals = new[]
 *                 {
 *                     new Aws.Iam.Inputs.GetPolicyDocumentStatementPrincipalInputArgs
 *                     {
 *                         Type = "AWS",
 *                         Identifiers = new[]
 *                         {
 *                             "123456789012",
 *                         },
 *                     },
 *                 },
 *             },
 *         },
 *     });
 *     var testEventBusPolicy = new Aws.CloudWatch.EventBusPolicy("test", new()
 *     {
 *         Policy = test.Apply(getPolicyDocumentResult => getPolicyDocumentResult.Json),
 *         EventBusName = testAwsCloudwatchEventBus.Name,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cloudwatch"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		test, err := iam.GetPolicyDocument(ctx, &iam.GetPolicyDocumentArgs{
 * 			Statements: []iam.GetPolicyDocumentStatement{
 * 				{
 * 					Sid:    pulumi.StringRef("DevAccountAccess"),
 * 					Effect: pulumi.StringRef("Allow"),
 * 					Actions: []string{
 * 						"events:PutEvents",
 * 					},
 * 					Resources: []string{
 * 						"arn:aws:events:eu-west-1:123456789012:event-bus/default",
 * 					},
 * 					Principals: []iam.GetPolicyDocumentStatementPrincipal{
 * 						{
 * 							Type: "AWS",
 * 							Identifiers: []string{
 * 								"123456789012",
 * 							},
 * 						},
 * 					},
 * 				},
 * 			},
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = cloudwatch.NewEventBusPolicy(ctx, "test", &cloudwatch.EventBusPolicyArgs{
 * 			Policy:       pulumi.String(test.Json),
 * 			EventBusName: pulumi.Any(testAwsCloudwatchEventBus.Name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.cloudwatch.EventBusPolicy;
 * import com.pulumi.aws.cloudwatch.EventBusPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var test = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .sid("DevAccountAccess")
 *                 .effect("Allow")
 *                 .actions("events:PutEvents")
 *                 .resources("arn:aws:events:eu-west-1:123456789012:event-bus/default")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("AWS")
 *                     .identifiers("123456789012")
 *                     .build())
 *                 .build())
 *             .build());
 *         var testEventBusPolicy = new EventBusPolicy("testEventBusPolicy", EventBusPolicyArgs.builder()
 *             .policy(test.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .eventBusName(testAwsCloudwatchEventBus.name())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   testEventBusPolicy:
 *     type: aws:cloudwatch:EventBusPolicy
 *     name: test
 *     properties:
 *       policy: ${test.json}
 *       eventBusName: ${testAwsCloudwatchEventBus.name}
 * variables:
 *   test:
 *     fn::invoke:
 *       Function: aws:iam:getPolicyDocument
 *       Arguments:
 *         statements:
 *           - sid: DevAccountAccess
 *             effect: Allow
 *             actions:
 *               - events:PutEvents
 *             resources:
 *               - arn:aws:events:eu-west-1:123456789012:event-bus/default
 *             principals:
 *               - type: AWS
 *                 identifiers:
 *                   - '123456789012'
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Organization Access
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = aws.iam.getPolicyDocument({
 *     statements: [{
 *         sid: "OrganizationAccess",
 *         effect: "Allow",
 *         actions: [
 *             "events:DescribeRule",
 *             "events:ListRules",
 *             "events:ListTargetsByRule",
 *             "events:ListTagsForResource",
 *         ],
 *         resources: [
 *             "arn:aws:events:eu-west-1:123456789012:rule/*",
 *             "arn:aws:events:eu-west-1:123456789012:event-bus/default",
 *         ],
 *         principals: [{
 *             type: "AWS",
 *             identifiers: ["*"],
 *         }],
 *         conditions: [{
 *             test: "StringEquals",
 *             variable: "aws:PrincipalOrgID",
 *             values: [example&#46;id],
 *         }],
 *     }],
 * });
 * const testEventBusPolicy = new aws.cloudwatch.EventBusPolicy("test", {
 *     policy: test.then(test => test.json),
 *     eventBusName: testAwsCloudwatchEventBus.name,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test = aws.iam.get_policy_document(statements=[{
 *     "sid": "OrganizationAccess",
 *     "effect": "Allow",
 *     "actions": [
 *         "events:DescribeRule",
 *         "events:ListRules",
 *         "events:ListTargetsByRule",
 *         "events:ListTagsForResource",
 *     ],
 *     "resources": [
 *         "arn:aws:events:eu-west-1:123456789012:rule/*",
 *         "arn:aws:events:eu-west-1:123456789012:event-bus/default",
 *     ],
 *     "principals": [{
 *         "type": "AWS",
 *         "identifiers": ["*"],
 *     }],
 *     "conditions": [{
 *         "test": "StringEquals",
 *         "variable": "aws:PrincipalOrgID",
 *         "values": [example["id"]],
 *     }],
 * }])
 * test_event_bus_policy = aws.cloudwatch.EventBusPolicy("test",
 *     policy=test.json,
 *     event_bus_name=test_aws_cloudwatch_event_bus["name"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = Aws.Iam.GetPolicyDocument.Invoke(new()
 *     {
 *         Statements = new[]
 *         {
 *             new Aws.Iam.Inputs.GetPolicyDocumentStatementInputArgs
 *             {
 *                 Sid = "OrganizationAccess",
 *                 Effect = "Allow",
 *                 Actions = new[]
 *                 {
 *                     "events:DescribeRule",
 *                     "events:ListRules",
 *                     "events:ListTargetsByRule",
 *                     "events:ListTagsForResource",
 *                 },
 *                 Resources = new[]
 *                 {
 *                     "arn:aws:events:eu-west-1:123456789012:rule/*",
 *                     "arn:aws:events:eu-west-1:123456789012:event-bus/default",
 *                 },
 *                 Principals = new[]
 *                 {
 *                     new Aws.Iam.Inputs.GetPolicyDocumentStatementPrincipalInputArgs
 *                     {
 *                         Type = "AWS",
 *                         Identifiers = new[]
 *                         {
 *                             "*",
 *                         },
 *                     },
 *                 },
 *                 Conditions = new[]
 *                 {
 *                     new Aws.Iam.Inputs.GetPolicyDocumentStatementConditionInputArgs
 *                     {
 *                         Test = "StringEquals",
 *                         Variable = "aws:PrincipalOrgID",
 *                         Values = new[]
 *                         {
 *                             example.Id,
 *                         },
 *                     },
 *                 },
 *             },
 *         },
 *     });
 *     var testEventBusPolicy = new Aws.CloudWatch.EventBusPolicy("test", new()
 *     {
 *         Policy = test.Apply(getPolicyDocumentResult => getPolicyDocumentResult.Json),
 *         EventBusName = testAwsCloudwatchEventBus.Name,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cloudwatch"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * test, err := iam.GetPolicyDocument(ctx, &iam.GetPolicyDocumentArgs{
 * Statements: []iam.GetPolicyDocumentStatement{
 * {
 * Sid: pulumi.StringRef("OrganizationAccess"),
 * Effect: pulumi.StringRef("Allow"),
 * Actions: []string{
 * "events:DescribeRule",
 * "events:ListRules",
 * "events:ListTargetsByRule",
 * "events:ListTagsForResource",
 * },
 * Resources: []string{
 * "arn:aws:events:eu-west-1:123456789012:rule/*",
 * "arn:aws:events:eu-west-1:123456789012:event-bus/default",
 * },
 * Principals: []iam.GetPolicyDocumentStatementPrincipal{
 * {
 * Type: "AWS",
 * Identifiers: []string{
 * "*",
 * },
 * },
 * },
 * Conditions: []iam.GetPolicyDocumentStatementCondition{
 * {
 * Test: "StringEquals",
 * Variable: "aws:PrincipalOrgID",
 * Values: interface{}{
 * example.Id,
 * },
 * },
 * },
 * },
 * },
 * }, nil);
 * if err != nil {
 * return err
 * }
 * _, err = cloudwatch.NewEventBusPolicy(ctx, "test", &cloudwatch.EventBusPolicyArgs{
 * Policy: pulumi.String(test.Json),
 * EventBusName: pulumi.Any(testAwsCloudwatchEventBus.Name),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.cloudwatch.EventBusPolicy;
 * import com.pulumi.aws.cloudwatch.EventBusPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var test = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .sid("OrganizationAccess")
 *                 .effect("Allow")
 *                 .actions(
 *                     "events:DescribeRule",
 *                     "events:ListRules",
 *                     "events:ListTargetsByRule",
 *                     "events:ListTagsForResource")
 *                 .resources(
 *                     "arn:aws:events:eu-west-1:123456789012:rule/*",
 *                     "arn:aws:events:eu-west-1:123456789012:event-bus/default")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("AWS")
 *                     .identifiers("*")
 *                     .build())
 *                 .conditions(GetPolicyDocumentStatementConditionArgs.builder()
 *                     .test("StringEquals")
 *                     .variable("aws:PrincipalOrgID")
 *                     .values(example.id())
 *                     .build())
 *                 .build())
 *             .build());
 *         var testEventBusPolicy = new EventBusPolicy("testEventBusPolicy", EventBusPolicyArgs.builder()
 *             .policy(test.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .eventBusName(testAwsCloudwatchEventBus.name())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   testEventBusPolicy:
 *     type: aws:cloudwatch:EventBusPolicy
 *     name: test
 *     properties:
 *       policy: ${test.json}
 *       eventBusName: ${testAwsCloudwatchEventBus.name}
 * variables:
 *   test:
 *     fn::invoke:
 *       Function: aws:iam:getPolicyDocument
 *       Arguments:
 *         statements:
 *           - sid: OrganizationAccess
 *             effect: Allow
 *             actions:
 *               - events:DescribeRule
 *               - events:ListRules
 *               - events:ListTargetsByRule
 *               - events:ListTagsForResource
 *             resources:
 *               - arn:aws:events:eu-west-1:123456789012:rule/*
 *               - arn:aws:events:eu-west-1:123456789012:event-bus/default
 *             principals:
 *               - type: AWS
 *                 identifiers:
 *                   - '*'
 *             conditions:
 *               - test: StringEquals
 *                 variable: aws:PrincipalOrgID
 *                 values:
 *                   - ${example.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Multiple Statements
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = aws.iam.getPolicyDocument({
 *     statements: [
 *         {
 *             sid: "DevAccountAccess",
 *             effect: "Allow",
 *             actions: ["events:PutEvents"],
 *             resources: ["arn:aws:events:eu-west-1:123456789012:event-bus/default"],
 *             principals: [{
 *                 type: "AWS",
 *                 identifiers: ["123456789012"],
 *             }],
 *         },
 *         {
 *             sid: "OrganizationAccess",
 *             effect: "Allow",
 *             actions: [
 *                 "events:DescribeRule",
 *                 "events:ListRules",
 *                 "events:ListTargetsByRule",
 *                 "events:ListTagsForResource",
 *             ],
 *             resources: [
 *                 "arn:aws:events:eu-west-1:123456789012:rule/*",
 *                 "arn:aws:events:eu-west-1:123456789012:event-bus/default",
 *             ],
 *             principals: [{
 *                 type: "AWS",
 *                 identifiers: ["*"],
 *             }],
 *             conditions: [{
 *                 test: "StringEquals",
 *                 variable: "aws:PrincipalOrgID",
 *                 values: [example&#46;id],
 *             }],
 *         },
 *     ],
 * });
 * const testEventBusPolicy = new aws.cloudwatch.EventBusPolicy("test", {
 *     policy: test.then(test => test.json),
 *     eventBusName: testAwsCloudwatchEventBus.name,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test = aws.iam.get_policy_document(statements=[
 *     {
 *         "sid": "DevAccountAccess",
 *         "effect": "Allow",
 *         "actions": ["events:PutEvents"],
 *         "resources": ["arn:aws:events:eu-west-1:123456789012:event-bus/default"],
 *         "principals": [{
 *             "type": "AWS",
 *             "identifiers": ["123456789012"],
 *         }],
 *     },
 *     {
 *         "sid": "OrganizationAccess",
 *         "effect": "Allow",
 *         "actions": [
 *             "events:DescribeRule",
 *             "events:ListRules",
 *             "events:ListTargetsByRule",
 *             "events:ListTagsForResource",
 *         ],
 *         "resources": [
 *             "arn:aws:events:eu-west-1:123456789012:rule/*",
 *             "arn:aws:events:eu-west-1:123456789012:event-bus/default",
 *         ],
 *         "principals": [{
 *             "type": "AWS",
 *             "identifiers": ["*"],
 *         }],
 *         "conditions": [{
 *             "test": "StringEquals",
 *             "variable": "aws:PrincipalOrgID",
 *             "values": [example["id"]],
 *         }],
 *     },
 * ])
 * test_event_bus_policy = aws.cloudwatch.EventBusPolicy("test",
 *     policy=test.json,
 *     event_bus_name=test_aws_cloudwatch_event_bus["name"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = Aws.Iam.GetPolicyDocument.Invoke(new()
 *     {
 *         Statements = new[]
 *         {
 *             new Aws.Iam.Inputs.GetPolicyDocumentStatementInputArgs
 *             {
 *                 Sid = "DevAccountAccess",
 *                 Effect = "Allow",
 *                 Actions = new[]
 *                 {
 *                     "events:PutEvents",
 *                 },
 *                 Resources = new[]
 *                 {
 *                     "arn:aws:events:eu-west-1:123456789012:event-bus/default",
 *                 },
 *                 Principals = new[]
 *                 {
 *                     new Aws.Iam.Inputs.GetPolicyDocumentStatementPrincipalInputArgs
 *                     {
 *                         Type = "AWS",
 *                         Identifiers = new[]
 *                         {
 *                             "123456789012",
 *                         },
 *                     },
 *                 },
 *             },
 *             new Aws.Iam.Inputs.GetPolicyDocumentStatementInputArgs
 *             {
 *                 Sid = "OrganizationAccess",
 *                 Effect = "Allow",
 *                 Actions = new[]
 *                 {
 *                     "events:DescribeRule",
 *                     "events:ListRules",
 *                     "events:ListTargetsByRule",
 *                     "events:ListTagsForResource",
 *                 },
 *                 Resources = new[]
 *                 {
 *                     "arn:aws:events:eu-west-1:123456789012:rule/*",
 *                     "arn:aws:events:eu-west-1:123456789012:event-bus/default",
 *                 },
 *                 Principals = new[]
 *                 {
 *                     new Aws.Iam.Inputs.GetPolicyDocumentStatementPrincipalInputArgs
 *                     {
 *                         Type = "AWS",
 *                         Identifiers = new[]
 *                         {
 *                             "*",
 *                         },
 *                     },
 *                 },
 *                 Conditions = new[]
 *                 {
 *                     new Aws.Iam.Inputs.GetPolicyDocumentStatementConditionInputArgs
 *                     {
 *                         Test = "StringEquals",
 *                         Variable = "aws:PrincipalOrgID",
 *                         Values = new[]
 *                         {
 *                             example.Id,
 *                         },
 *                     },
 *                 },
 *             },
 *         },
 *     });
 *     var testEventBusPolicy = new Aws.CloudWatch.EventBusPolicy("test", new()
 *     {
 *         Policy = test.Apply(getPolicyDocumentResult => getPolicyDocumentResult.Json),
 *         EventBusName = testAwsCloudwatchEventBus.Name,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cloudwatch"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * test, err := iam.GetPolicyDocument(ctx, &iam.GetPolicyDocumentArgs{
 * Statements: []iam.GetPolicyDocumentStatement{
 * {
 * Sid: pulumi.StringRef("DevAccountAccess"),
 * Effect: pulumi.StringRef("Allow"),
 * Actions: []string{
 * "events:PutEvents",
 * },
 * Resources: []string{
 * "arn:aws:events:eu-west-1:123456789012:event-bus/default",
 * },
 * Principals: []iam.GetPolicyDocumentStatementPrincipal{
 * {
 * Type: "AWS",
 * Identifiers: []string{
 * "123456789012",
 * },
 * },
 * },
 * },
 * {
 * Sid: pulumi.StringRef("OrganizationAccess"),
 * Effect: pulumi.StringRef("Allow"),
 * Actions: []string{
 * "events:DescribeRule",
 * "events:ListRules",
 * "events:ListTargetsByRule",
 * "events:ListTagsForResource",
 * },
 * Resources: []string{
 * "arn:aws:events:eu-west-1:123456789012:rule/*",
 * "arn:aws:events:eu-west-1:123456789012:event-bus/default",
 * },
 * Principals: []iam.GetPolicyDocumentStatementPrincipal{
 * {
 * Type: "AWS",
 * Identifiers: []string{
 * "*",
 * },
 * },
 * },
 * Conditions: []iam.GetPolicyDocumentStatementCondition{
 * {
 * Test: "StringEquals",
 * Variable: "aws:PrincipalOrgID",
 * Values: interface{}{
 * example.Id,
 * },
 * },
 * },
 * },
 * },
 * }, nil);
 * if err != nil {
 * return err
 * }
 * _, err = cloudwatch.NewEventBusPolicy(ctx, "test", &cloudwatch.EventBusPolicyArgs{
 * Policy: pulumi.String(test.Json),
 * EventBusName: pulumi.Any(testAwsCloudwatchEventBus.Name),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.cloudwatch.EventBusPolicy;
 * import com.pulumi.aws.cloudwatch.EventBusPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var test = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(
 *                 GetPolicyDocumentStatementArgs.builder()
 *                     .sid("DevAccountAccess")
 *                     .effect("Allow")
 *                     .actions("events:PutEvents")
 *                     .resources("arn:aws:events:eu-west-1:123456789012:event-bus/default")
 *                     .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                         .type("AWS")
 *                         .identifiers("123456789012")
 *                         .build())
 *                     .build(),
 *                 GetPolicyDocumentStatementArgs.builder()
 *                     .sid("OrganizationAccess")
 *                     .effect("Allow")
 *                     .actions(
 *                         "events:DescribeRule",
 *                         "events:ListRules",
 *                         "events:ListTargetsByRule",
 *                         "events:ListTagsForResource")
 *                     .resources(
 *                         "arn:aws:events:eu-west-1:123456789012:rule/*",
 *                         "arn:aws:events:eu-west-1:123456789012:event-bus/default")
 *                     .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                         .type("AWS")
 *                         .identifiers("*")
 *                         .build())
 *                     .conditions(GetPolicyDocumentStatementConditionArgs.builder()
 *                         .test("StringEquals")
 *                         .variable("aws:PrincipalOrgID")
 *                         .values(example.id())
 *                         .build())
 *                     .build())
 *             .build());
 *         var testEventBusPolicy = new EventBusPolicy("testEventBusPolicy", EventBusPolicyArgs.builder()
 *             .policy(test.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .eventBusName(testAwsCloudwatchEventBus.name())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   testEventBusPolicy:
 *     type: aws:cloudwatch:EventBusPolicy
 *     name: test
 *     properties:
 *       policy: ${test.json}
 *       eventBusName: ${testAwsCloudwatchEventBus.name}
 * variables:
 *   test:
 *     fn::invoke:
 *       Function: aws:iam:getPolicyDocument
 *       Arguments:
 *         statements:
 *           - sid: DevAccountAccess
 *             effect: Allow
 *             actions:
 *               - events:PutEvents
 *             resources:
 *               - arn:aws:events:eu-west-1:123456789012:event-bus/default
 *             principals:
 *               - type: AWS
 *                 identifiers:
 *                   - '123456789012'
 *           - sid: OrganizationAccess
 *             effect: Allow
 *             actions:
 *               - events:DescribeRule
 *               - events:ListRules
 *               - events:ListTargetsByRule
 *               - events:ListTagsForResource
 *             resources:
 *               - arn:aws:events:eu-west-1:123456789012:rule/*
 *               - arn:aws:events:eu-west-1:123456789012:event-bus/default
 *             principals:
 *               - type: AWS
 *                 identifiers:
 *                   - '*'
 *             conditions:
 *               - test: StringEquals
 *                 variable: aws:PrincipalOrgID
 *                 values:
 *                   - ${example.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import an EventBridge policy using the `event_bus_name`. For example:
 * ```sh
 * $ pulumi import aws:cloudwatch/eventBusPolicy:EventBusPolicy DevAccountAccess example-event-bus
 * ```
 * @property eventBusName The name of the event bus to set the permissions on.
 * If you omit this, the permissions are set on the `default` event bus.
 * @property policy The text of the policy.
 * */*/*/*/*/*/*/*/*/*/*/*/
 */
public data class EventBusPolicyArgs(
    public val eventBusName: Output<String>? = null,
    public val policy: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.cloudwatch.EventBusPolicyArgs> {
    override fun toJava(): com.pulumi.aws.cloudwatch.EventBusPolicyArgs =
        com.pulumi.aws.cloudwatch.EventBusPolicyArgs.builder()
            .eventBusName(eventBusName?.applyValue({ args0 -> args0 }))
            .policy(policy?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EventBusPolicyArgs].
 */
@PulumiTagMarker
public class EventBusPolicyArgsBuilder internal constructor() {
    private var eventBusName: Output<String>? = null

    private var policy: Output<String>? = null

    /**
     * @param value The name of the event bus to set the permissions on.
     * If you omit this, the permissions are set on the `default` event bus.
     */
    @JvmName("scopolgbmjawdnjk")
    public suspend fun eventBusName(`value`: Output<String>) {
        this.eventBusName = value
    }

    /**
     * @param value The text of the policy.
     */
    @JvmName("pekxeejhywdpiaut")
    public suspend fun policy(`value`: Output<String>) {
        this.policy = value
    }

    /**
     * @param value The name of the event bus to set the permissions on.
     * If you omit this, the permissions are set on the `default` event bus.
     */
    @JvmName("rwflkbyirbqlrmcw")
    public suspend fun eventBusName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eventBusName = mapped
    }

    /**
     * @param value The text of the policy.
     */
    @JvmName("ikypsurbwccabjun")
    public suspend fun policy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policy = mapped
    }

    internal fun build(): EventBusPolicyArgs = EventBusPolicyArgs(
        eventBusName = eventBusName,
        policy = policy,
    )
}
