@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudwatch.kotlin

import com.pulumi.aws.cloudwatch.kotlin.outputs.EventConnectionAuthParameters
import com.pulumi.aws.cloudwatch.kotlin.outputs.EventConnectionAuthParameters.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [EventConnection].
 */
@PulumiTagMarker
public class EventConnectionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: EventConnectionArgs = EventConnectionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend EventConnectionArgsBuilder.() -> Unit) {
        val builder = EventConnectionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): EventConnection {
        val builtJavaResource = com.pulumi.aws.cloudwatch.EventConnection(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return EventConnection(builtJavaResource)
    }
}

/**
 * Provides an EventBridge connection resource.
 * > **Note:** EventBridge was formerly known as CloudWatch Events. The functionality is identical.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = new aws.cloudwatch.EventConnection("test", {
 *     name: "ngrok-connection",
 *     description: "A connection description",
 *     authorizationType: "API_KEY",
 *     authParameters: {
 *         apiKey: {
 *             key: "x-signature",
 *             value: "1234",
 *         },
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test = aws.cloudwatch.EventConnection("test",
 *     name="ngrok-connection",
 *     description="A connection description",
 *     authorization_type="API_KEY",
 *     auth_parameters={
 *         "api_key": {
 *             "key": "x-signature",
 *             "value": "1234",
 *         },
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new Aws.CloudWatch.EventConnection("test", new()
 *     {
 *         Name = "ngrok-connection",
 *         Description = "A connection description",
 *         AuthorizationType = "API_KEY",
 *         AuthParameters = new Aws.CloudWatch.Inputs.EventConnectionAuthParametersArgs
 *         {
 *             ApiKey = new Aws.CloudWatch.Inputs.EventConnectionAuthParametersApiKeyArgs
 *             {
 *                 Key = "x-signature",
 *                 Value = "1234",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cloudwatch"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cloudwatch.NewEventConnection(ctx, "test", &cloudwatch.EventConnectionArgs{
 * 			Name:              pulumi.String("ngrok-connection"),
 * 			Description:       pulumi.String("A connection description"),
 * 			AuthorizationType: pulumi.String("API_KEY"),
 * 			AuthParameters: &cloudwatch.EventConnectionAuthParametersArgs{
 * 				ApiKey: &cloudwatch.EventConnectionAuthParametersApiKeyArgs{
 * 					Key:   pulumi.String("x-signature"),
 * 					Value: pulumi.String("1234"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudwatch.EventConnection;
 * import com.pulumi.aws.cloudwatch.EventConnectionArgs;
 * import com.pulumi.aws.cloudwatch.inputs.EventConnectionAuthParametersArgs;
 * import com.pulumi.aws.cloudwatch.inputs.EventConnectionAuthParametersApiKeyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new EventConnection("test", EventConnectionArgs.builder()
 *             .name("ngrok-connection")
 *             .description("A connection description")
 *             .authorizationType("API_KEY")
 *             .authParameters(EventConnectionAuthParametersArgs.builder()
 *                 .apiKey(EventConnectionAuthParametersApiKeyArgs.builder()
 *                     .key("x-signature")
 *                     .value("1234")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:cloudwatch:EventConnection
 *     properties:
 *       name: ngrok-connection
 *       description: A connection description
 *       authorizationType: API_KEY
 *       authParameters:
 *         apiKey:
 *           key: x-signature
 *           value: '1234'
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Basic Authorization
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = new aws.cloudwatch.EventConnection("test", {
 *     name: "ngrok-connection",
 *     description: "A connection description",
 *     authorizationType: "BASIC",
 *     authParameters: {
 *         basic: {
 *             username: "user",
 *             password: "Pass1234!",
 *         },
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test = aws.cloudwatch.EventConnection("test",
 *     name="ngrok-connection",
 *     description="A connection description",
 *     authorization_type="BASIC",
 *     auth_parameters={
 *         "basic": {
 *             "username": "user",
 *             "password": "Pass1234!",
 *         },
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new Aws.CloudWatch.EventConnection("test", new()
 *     {
 *         Name = "ngrok-connection",
 *         Description = "A connection description",
 *         AuthorizationType = "BASIC",
 *         AuthParameters = new Aws.CloudWatch.Inputs.EventConnectionAuthParametersArgs
 *         {
 *             Basic = new Aws.CloudWatch.Inputs.EventConnectionAuthParametersBasicArgs
 *             {
 *                 Username = "user",
 *                 Password = "Pass1234!",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cloudwatch"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cloudwatch.NewEventConnection(ctx, "test", &cloudwatch.EventConnectionArgs{
 * 			Name:              pulumi.String("ngrok-connection"),
 * 			Description:       pulumi.String("A connection description"),
 * 			AuthorizationType: pulumi.String("BASIC"),
 * 			AuthParameters: &cloudwatch.EventConnectionAuthParametersArgs{
 * 				Basic: &cloudwatch.EventConnectionAuthParametersBasicArgs{
 * 					Username: pulumi.String("user"),
 * 					Password: pulumi.String("Pass1234!"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudwatch.EventConnection;
 * import com.pulumi.aws.cloudwatch.EventConnectionArgs;
 * import com.pulumi.aws.cloudwatch.inputs.EventConnectionAuthParametersArgs;
 * import com.pulumi.aws.cloudwatch.inputs.EventConnectionAuthParametersBasicArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new EventConnection("test", EventConnectionArgs.builder()
 *             .name("ngrok-connection")
 *             .description("A connection description")
 *             .authorizationType("BASIC")
 *             .authParameters(EventConnectionAuthParametersArgs.builder()
 *                 .basic(EventConnectionAuthParametersBasicArgs.builder()
 *                     .username("user")
 *                     .password("Pass1234!")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:cloudwatch:EventConnection
 *     properties:
 *       name: ngrok-connection
 *       description: A connection description
 *       authorizationType: BASIC
 *       authParameters:
 *         basic:
 *           username: user
 *           password: Pass1234!
 * ```
 * <!--End PulumiCodeChooser -->
 * ### OAuth Authorization
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = new aws.cloudwatch.EventConnection("test", {
 *     name: "ngrok-connection",
 *     description: "A connection description",
 *     authorizationType: "OAUTH_CLIENT_CREDENTIALS",
 *     authParameters: {
 *         oauth: {
 *             authorizationEndpoint: "https://auth.url.com/endpoint",
 *             httpMethod: "GET",
 *             clientParameters: {
 *                 clientId: "1234567890",
 *                 clientSecret: "Pass1234!",
 *             },
 *             oauthHttpParameters: {
 *                 bodies: [{
 *                     key: "body-parameter-key",
 *                     value: "body-parameter-value",
 *                     isValueSecret: false,
 *                 }],
 *                 headers: [{
 *                     key: "header-parameter-key",
 *                     value: "header-parameter-value",
 *                     isValueSecret: false,
 *                 }],
 *                 queryStrings: [{
 *                     key: "query-string-parameter-key",
 *                     value: "query-string-parameter-value",
 *                     isValueSecret: false,
 *                 }],
 *             },
 *         },
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test = aws.cloudwatch.EventConnection("test",
 *     name="ngrok-connection",
 *     description="A connection description",
 *     authorization_type="OAUTH_CLIENT_CREDENTIALS",
 *     auth_parameters={
 *         "oauth": {
 *             "authorization_endpoint": "https://auth.url.com/endpoint",
 *             "http_method": "GET",
 *             "client_parameters": {
 *                 "client_id": "1234567890",
 *                 "client_secret": "Pass1234!",
 *             },
 *             "oauth_http_parameters": {
 *                 "bodies": [{
 *                     "key": "body-parameter-key",
 *                     "value": "body-parameter-value",
 *                     "is_value_secret": False,
 *                 }],
 *                 "headers": [{
 *                     "key": "header-parameter-key",
 *                     "value": "header-parameter-value",
 *                     "is_value_secret": False,
 *                 }],
 *                 "query_strings": [{
 *                     "key": "query-string-parameter-key",
 *                     "value": "query-string-parameter-value",
 *                     "is_value_secret": False,
 *                 }],
 *             },
 *         },
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new Aws.CloudWatch.EventConnection("test", new()
 *     {
 *         Name = "ngrok-connection",
 *         Description = "A connection description",
 *         AuthorizationType = "OAUTH_CLIENT_CREDENTIALS",
 *         AuthParameters = new Aws.CloudWatch.Inputs.EventConnectionAuthParametersArgs
 *         {
 *             Oauth = new Aws.CloudWatch.Inputs.EventConnectionAuthParametersOauthArgs
 *             {
 *                 AuthorizationEndpoint = "https://auth.url.com/endpoint",
 *                 HttpMethod = "GET",
 *                 ClientParameters = new Aws.CloudWatch.Inputs.EventConnectionAuthParametersOauthClientParametersArgs
 *                 {
 *                     ClientId = "1234567890",
 *                     ClientSecret = "Pass1234!",
 *                 },
 *                 OauthHttpParameters = new Aws.CloudWatch.Inputs.EventConnectionAuthParametersOauthOauthHttpParametersArgs
 *                 {
 *                     Bodies = new[]
 *                     {
 *                         new Aws.CloudWatch.Inputs.EventConnectionAuthParametersOauthOauthHttpParametersBodyArgs
 *                         {
 *                             Key = "body-parameter-key",
 *                             Value = "body-parameter-value",
 *                             IsValueSecret = false,
 *                         },
 *                     },
 *                     Headers = new[]
 *                     {
 *                         new Aws.CloudWatch.Inputs.EventConnectionAuthParametersOauthOauthHttpParametersHeaderArgs
 *                         {
 *                             Key = "header-parameter-key",
 *                             Value = "header-parameter-value",
 *                             IsValueSecret = false,
 *                         },
 *                     },
 *                     QueryStrings = new[]
 *                     {
 *                         new Aws.CloudWatch.Inputs.EventConnectionAuthParametersOauthOauthHttpParametersQueryStringArgs
 *                         {
 *                             Key = "query-string-parameter-key",
 *                             Value = "query-string-parameter-value",
 *                             IsValueSecret = false,
 *                         },
 *                     },
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cloudwatch"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cloudwatch.NewEventConnection(ctx, "test", &cloudwatch.EventConnectionArgs{
 * 			Name:              pulumi.String("ngrok-connection"),
 * 			Description:       pulumi.String("A connection description"),
 * 			AuthorizationType: pulumi.String("OAUTH_CLIENT_CREDENTIALS"),
 * 			AuthParameters: &cloudwatch.EventConnectionAuthParametersArgs{
 * 				Oauth: &cloudwatch.EventConnectionAuthParametersOauthArgs{
 * 					AuthorizationEndpoint: pulumi.String("https://auth.url.com/endpoint"),
 * 					HttpMethod:            pulumi.String("GET"),
 * 					ClientParameters: &cloudwatch.EventConnectionAuthParametersOauthClientParametersArgs{
 * 						ClientId:     pulumi.String("1234567890"),
 * 						ClientSecret: pulumi.String("Pass1234!"),
 * 					},
 * 					OauthHttpParameters: &cloudwatch.EventConnectionAuthParametersOauthOauthHttpParametersArgs{
 * 						Bodies: cloudwatch.EventConnectionAuthParametersOauthOauthHttpParametersBodyArray{
 * 							&cloudwatch.EventConnectionAuthParametersOauthOauthHttpParametersBodyArgs{
 * 								Key:           pulumi.String("body-parameter-key"),
 * 								Value:         pulumi.String("body-parameter-value"),
 * 								IsValueSecret: pulumi.Bool(false),
 * 							},
 * 						},
 * 						Headers: cloudwatch.EventConnectionAuthParametersOauthOauthHttpParametersHeaderArray{
 * 							&cloudwatch.EventConnectionAuthParametersOauthOauthHttpParametersHeaderArgs{
 * 								Key:           pulumi.String("header-parameter-key"),
 * 								Value:         pulumi.String("header-parameter-value"),
 * 								IsValueSecret: pulumi.Bool(false),
 * 							},
 * 						},
 * 						QueryStrings: cloudwatch.EventConnectionAuthParametersOauthOauthHttpParametersQueryStringArray{
 * 							&cloudwatch.EventConnectionAuthParametersOauthOauthHttpParametersQueryStringArgs{
 * 								Key:           pulumi.String("query-string-parameter-key"),
 * 								Value:         pulumi.String("query-string-parameter-value"),
 * 								IsValueSecret: pulumi.Bool(false),
 * 							},
 * 						},
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudwatch.EventConnection;
 * import com.pulumi.aws.cloudwatch.EventConnectionArgs;
 * import com.pulumi.aws.cloudwatch.inputs.EventConnectionAuthParametersArgs;
 * import com.pulumi.aws.cloudwatch.inputs.EventConnectionAuthParametersOauthArgs;
 * import com.pulumi.aws.cloudwatch.inputs.EventConnectionAuthParametersOauthClientParametersArgs;
 * import com.pulumi.aws.cloudwatch.inputs.EventConnectionAuthParametersOauthOauthHttpParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new EventConnection("test", EventConnectionArgs.builder()
 *             .name("ngrok-connection")
 *             .description("A connection description")
 *             .authorizationType("OAUTH_CLIENT_CREDENTIALS")
 *             .authParameters(EventConnectionAuthParametersArgs.builder()
 *                 .oauth(EventConnectionAuthParametersOauthArgs.builder()
 *                     .authorizationEndpoint("https://auth.url.com/endpoint")
 *                     .httpMethod("GET")
 *                     .clientParameters(EventConnectionAuthParametersOauthClientParametersArgs.builder()
 *                         .clientId("1234567890")
 *                         .clientSecret("Pass1234!")
 *                         .build())
 *                     .oauthHttpParameters(EventConnectionAuthParametersOauthOauthHttpParametersArgs.builder()
 *                         .bodies(EventConnectionAuthParametersOauthOauthHttpParametersBodyArgs.builder()
 *                             .key("body-parameter-key")
 *                             .value("body-parameter-value")
 *                             .isValueSecret(false)
 *                             .build())
 *                         .headers(EventConnectionAuthParametersOauthOauthHttpParametersHeaderArgs.builder()
 *                             .key("header-parameter-key")
 *                             .value("header-parameter-value")
 *                             .isValueSecret(false)
 *                             .build())
 *                         .queryStrings(EventConnectionAuthParametersOauthOauthHttpParametersQueryStringArgs.builder()
 *                             .key("query-string-parameter-key")
 *                             .value("query-string-parameter-value")
 *                             .isValueSecret(false)
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:cloudwatch:EventConnection
 *     properties:
 *       name: ngrok-connection
 *       description: A connection description
 *       authorizationType: OAUTH_CLIENT_CREDENTIALS
 *       authParameters:
 *         oauth:
 *           authorizationEndpoint: https://auth.url.com/endpoint
 *           httpMethod: GET
 *           clientParameters:
 *             clientId: '1234567890'
 *             clientSecret: Pass1234!
 *           oauthHttpParameters:
 *             bodies:
 *               - key: body-parameter-key
 *                 value: body-parameter-value
 *                 isValueSecret: false
 *             headers:
 *               - key: header-parameter-key
 *                 value: header-parameter-value
 *                 isValueSecret: false
 *             queryStrings:
 *               - key: query-string-parameter-key
 *                 value: query-string-parameter-value
 *                 isValueSecret: false
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Invocation Http Parameters
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = new aws.cloudwatch.EventConnection("test", {
 *     name: "ngrok-connection",
 *     description: "A connection description",
 *     authorizationType: "BASIC",
 *     authParameters: {
 *         basic: {
 *             username: "user",
 *             password: "Pass1234!",
 *         },
 *         invocationHttpParameters: {
 *             bodies: [
 *                 {
 *                     key: "body-parameter-key",
 *                     value: "body-parameter-value",
 *                     isValueSecret: false,
 *                 },
 *                 {
 *                     key: "body-parameter-key2",
 *                     value: "body-parameter-value2",
 *                     isValueSecret: true,
 *                 },
 *             ],
 *             headers: [{
 *                 key: "header-parameter-key",
 *                 value: "header-parameter-value",
 *                 isValueSecret: false,
 *             }],
 *             queryStrings: [{
 *                 key: "query-string-parameter-key",
 *                 value: "query-string-parameter-value",
 *                 isValueSecret: false,
 *             }],
 *         },
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test = aws.cloudwatch.EventConnection("test",
 *     name="ngrok-connection",
 *     description="A connection description",
 *     authorization_type="BASIC",
 *     auth_parameters={
 *         "basic": {
 *             "username": "user",
 *             "password": "Pass1234!",
 *         },
 *         "invocation_http_parameters": {
 *             "bodies": [
 *                 {
 *                     "key": "body-parameter-key",
 *                     "value": "body-parameter-value",
 *                     "is_value_secret": False,
 *                 },
 *                 {
 *                     "key": "body-parameter-key2",
 *                     "value": "body-parameter-value2",
 *                     "is_value_secret": True,
 *                 },
 *             ],
 *             "headers": [{
 *                 "key": "header-parameter-key",
 *                 "value": "header-parameter-value",
 *                 "is_value_secret": False,
 *             }],
 *             "query_strings": [{
 *                 "key": "query-string-parameter-key",
 *                 "value": "query-string-parameter-value",
 *                 "is_value_secret": False,
 *             }],
 *         },
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new Aws.CloudWatch.EventConnection("test", new()
 *     {
 *         Name = "ngrok-connection",
 *         Description = "A connection description",
 *         AuthorizationType = "BASIC",
 *         AuthParameters = new Aws.CloudWatch.Inputs.EventConnectionAuthParametersArgs
 *         {
 *             Basic = new Aws.CloudWatch.Inputs.EventConnectionAuthParametersBasicArgs
 *             {
 *                 Username = "user",
 *                 Password = "Pass1234!",
 *             },
 *             InvocationHttpParameters = new Aws.CloudWatch.Inputs.EventConnectionAuthParametersInvocationHttpParametersArgs
 *             {
 *                 Bodies = new[]
 *                 {
 *                     new Aws.CloudWatch.Inputs.EventConnectionAuthParametersInvocationHttpParametersBodyArgs
 *                     {
 *                         Key = "body-parameter-key",
 *                         Value = "body-parameter-value",
 *                         IsValueSecret = false,
 *                     },
 *                     new Aws.CloudWatch.Inputs.EventConnectionAuthParametersInvocationHttpParametersBodyArgs
 *                     {
 *                         Key = "body-parameter-key2",
 *                         Value = "body-parameter-value2",
 *                         IsValueSecret = true,
 *                     },
 *                 },
 *                 Headers = new[]
 *                 {
 *                     new Aws.CloudWatch.Inputs.EventConnectionAuthParametersInvocationHttpParametersHeaderArgs
 *                     {
 *                         Key = "header-parameter-key",
 *                         Value = "header-parameter-value",
 *                         IsValueSecret = false,
 *                     },
 *                 },
 *                 QueryStrings = new[]
 *                 {
 *                     new Aws.CloudWatch.Inputs.EventConnectionAuthParametersInvocationHttpParametersQueryStringArgs
 *                     {
 *                         Key = "query-string-parameter-key",
 *                         Value = "query-string-parameter-value",
 *                         IsValueSecret = false,
 *                     },
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cloudwatch"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cloudwatch.NewEventConnection(ctx, "test", &cloudwatch.EventConnectionArgs{
 * 			Name:              pulumi.String("ngrok-connection"),
 * 			Description:       pulumi.String("A connection description"),
 * 			AuthorizationType: pulumi.String("BASIC"),
 * 			AuthParameters: &cloudwatch.EventConnectionAuthParametersArgs{
 * 				Basic: &cloudwatch.EventConnectionAuthParametersBasicArgs{
 * 					Username: pulumi.String("user"),
 * 					Password: pulumi.String("Pass1234!"),
 * 				},
 * 				InvocationHttpParameters: &cloudwatch.EventConnectionAuthParametersInvocationHttpParametersArgs{
 * 					Bodies: cloudwatch.EventConnectionAuthParametersInvocationHttpParametersBodyArray{
 * 						&cloudwatch.EventConnectionAuthParametersInvocationHttpParametersBodyArgs{
 * 							Key:           pulumi.String("body-parameter-key"),
 * 							Value:         pulumi.String("body-parameter-value"),
 * 							IsValueSecret: pulumi.Bool(false),
 * 						},
 * 						&cloudwatch.EventConnectionAuthParametersInvocationHttpParametersBodyArgs{
 * 							Key:           pulumi.String("body-parameter-key2"),
 * 							Value:         pulumi.String("body-parameter-value2"),
 * 							IsValueSecret: pulumi.Bool(true),
 * 						},
 * 					},
 * 					Headers: cloudwatch.EventConnectionAuthParametersInvocationHttpParametersHeaderArray{
 * 						&cloudwatch.EventConnectionAuthParametersInvocationHttpParametersHeaderArgs{
 * 							Key:           pulumi.String("header-parameter-key"),
 * 							Value:         pulumi.String("header-parameter-value"),
 * 							IsValueSecret: pulumi.Bool(false),
 * 						},
 * 					},
 * 					QueryStrings: cloudwatch.EventConnectionAuthParametersInvocationHttpParametersQueryStringArray{
 * 						&cloudwatch.EventConnectionAuthParametersInvocationHttpParametersQueryStringArgs{
 * 							Key:           pulumi.String("query-string-parameter-key"),
 * 							Value:         pulumi.String("query-string-parameter-value"),
 * 							IsValueSecret: pulumi.Bool(false),
 * 						},
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudwatch.EventConnection;
 * import com.pulumi.aws.cloudwatch.EventConnectionArgs;
 * import com.pulumi.aws.cloudwatch.inputs.EventConnectionAuthParametersArgs;
 * import com.pulumi.aws.cloudwatch.inputs.EventConnectionAuthParametersBasicArgs;
 * import com.pulumi.aws.cloudwatch.inputs.EventConnectionAuthParametersInvocationHttpParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new EventConnection("test", EventConnectionArgs.builder()
 *             .name("ngrok-connection")
 *             .description("A connection description")
 *             .authorizationType("BASIC")
 *             .authParameters(EventConnectionAuthParametersArgs.builder()
 *                 .basic(EventConnectionAuthParametersBasicArgs.builder()
 *                     .username("user")
 *                     .password("Pass1234!")
 *                     .build())
 *                 .invocationHttpParameters(EventConnectionAuthParametersInvocationHttpParametersArgs.builder()
 *                     .bodies(
 *                         EventConnectionAuthParametersInvocationHttpParametersBodyArgs.builder()
 *                             .key("body-parameter-key")
 *                             .value("body-parameter-value")
 *                             .isValueSecret(false)
 *                             .build(),
 *                         EventConnectionAuthParametersInvocationHttpParametersBodyArgs.builder()
 *                             .key("body-parameter-key2")
 *                             .value("body-parameter-value2")
 *                             .isValueSecret(true)
 *                             .build())
 *                     .headers(EventConnectionAuthParametersInvocationHttpParametersHeaderArgs.builder()
 *                         .key("header-parameter-key")
 *                         .value("header-parameter-value")
 *                         .isValueSecret(false)
 *                         .build())
 *                     .queryStrings(EventConnectionAuthParametersInvocationHttpParametersQueryStringArgs.builder()
 *                         .key("query-string-parameter-key")
 *                         .value("query-string-parameter-value")
 *                         .isValueSecret(false)
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:cloudwatch:EventConnection
 *     properties:
 *       name: ngrok-connection
 *       description: A connection description
 *       authorizationType: BASIC
 *       authParameters:
 *         basic:
 *           username: user
 *           password: Pass1234!
 *         invocationHttpParameters:
 *           bodies:
 *             - key: body-parameter-key
 *               value: body-parameter-value
 *               isValueSecret: false
 *             - key: body-parameter-key2
 *               value: body-parameter-value2
 *               isValueSecret: true
 *           headers:
 *             - key: header-parameter-key
 *               value: header-parameter-value
 *               isValueSecret: false
 *           queryStrings:
 *             - key: query-string-parameter-key
 *               value: query-string-parameter-value
 *               isValueSecret: false
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import EventBridge EventBridge connection using the `name`. For example:
 * ```sh
 * $ pulumi import aws:cloudwatch/eventConnection:EventConnection test ngrok-connection
 * ```
 */
public class EventConnection internal constructor(
    override val javaResource: com.pulumi.aws.cloudwatch.EventConnection,
) : KotlinCustomResource(javaResource, EventConnectionMapper) {
    /**
     * The Amazon Resource Name (ARN) of the connection.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Parameters used for authorization. A maximum of 1 are allowed. Documented below.
     */
    public val authParameters: Output<EventConnectionAuthParameters>
        get() = javaResource.authParameters().applyValue({ args0 ->
            args0.let({ args0 ->
                toKotlin(args0)
            })
        })

    /**
     * Choose the type of authorization to use for the connection. One of `API_KEY`,`BASIC`,`OAUTH_CLIENT_CREDENTIALS`.
     */
    public val authorizationType: Output<String>
        get() = javaResource.authorizationType().applyValue({ args0 -> args0 })

    /**
     * Enter a description for the connection. Maximum of 512 characters.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the new connection. Maximum of 64 characters consisting of numbers, lower/upper case letters, .,-,_.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The Amazon Resource Name (ARN) of the secret created from the authorization parameters specified for the connection.
     */
    public val secretArn: Output<String>
        get() = javaResource.secretArn().applyValue({ args0 -> args0 })
}

public object EventConnectionMapper : ResourceMapper<EventConnection> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.cloudwatch.EventConnection::class == javaResource::class

    override fun map(javaResource: Resource): EventConnection = EventConnection(
        javaResource as
            com.pulumi.aws.cloudwatch.EventConnection,
    )
}

/**
 * @see [EventConnection].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [EventConnection].
 */
public suspend fun eventConnection(
    name: String,
    block: suspend EventConnectionResourceBuilder.() -> Unit,
): EventConnection {
    val builder = EventConnectionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [EventConnection].
 * @param name The _unique_ name of the resulting resource.
 */
public fun eventConnection(name: String): EventConnection {
    val builder = EventConnectionResourceBuilder()
    builder.name(name)
    return builder.build()
}
