@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudwatch.kotlin

import com.pulumi.aws.cloudwatch.EventConnectionArgs.builder
import com.pulumi.aws.cloudwatch.kotlin.inputs.EventConnectionAuthParametersArgs
import com.pulumi.aws.cloudwatch.kotlin.inputs.EventConnectionAuthParametersArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Provides an EventBridge connection resource.
 * > **Note:** EventBridge was formerly known as CloudWatch Events. The functionality is identical.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = new aws.cloudwatch.EventConnection("test", {
 *     name: "ngrok-connection",
 *     description: "A connection description",
 *     authorizationType: "API_KEY",
 *     authParameters: {
 *         apiKey: {
 *             key: "x-signature",
 *             value: "1234",
 *         },
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test = aws.cloudwatch.EventConnection("test",
 *     name="ngrok-connection",
 *     description="A connection description",
 *     authorization_type="API_KEY",
 *     auth_parameters={
 *         "api_key": {
 *             "key": "x-signature",
 *             "value": "1234",
 *         },
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new Aws.CloudWatch.EventConnection("test", new()
 *     {
 *         Name = "ngrok-connection",
 *         Description = "A connection description",
 *         AuthorizationType = "API_KEY",
 *         AuthParameters = new Aws.CloudWatch.Inputs.EventConnectionAuthParametersArgs
 *         {
 *             ApiKey = new Aws.CloudWatch.Inputs.EventConnectionAuthParametersApiKeyArgs
 *             {
 *                 Key = "x-signature",
 *                 Value = "1234",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cloudwatch"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cloudwatch.NewEventConnection(ctx, "test", &cloudwatch.EventConnectionArgs{
 * 			Name:              pulumi.String("ngrok-connection"),
 * 			Description:       pulumi.String("A connection description"),
 * 			AuthorizationType: pulumi.String("API_KEY"),
 * 			AuthParameters: &cloudwatch.EventConnectionAuthParametersArgs{
 * 				ApiKey: &cloudwatch.EventConnectionAuthParametersApiKeyArgs{
 * 					Key:   pulumi.String("x-signature"),
 * 					Value: pulumi.String("1234"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudwatch.EventConnection;
 * import com.pulumi.aws.cloudwatch.EventConnectionArgs;
 * import com.pulumi.aws.cloudwatch.inputs.EventConnectionAuthParametersArgs;
 * import com.pulumi.aws.cloudwatch.inputs.EventConnectionAuthParametersApiKeyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new EventConnection("test", EventConnectionArgs.builder()
 *             .name("ngrok-connection")
 *             .description("A connection description")
 *             .authorizationType("API_KEY")
 *             .authParameters(EventConnectionAuthParametersArgs.builder()
 *                 .apiKey(EventConnectionAuthParametersApiKeyArgs.builder()
 *                     .key("x-signature")
 *                     .value("1234")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:cloudwatch:EventConnection
 *     properties:
 *       name: ngrok-connection
 *       description: A connection description
 *       authorizationType: API_KEY
 *       authParameters:
 *         apiKey:
 *           key: x-signature
 *           value: '1234'
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Basic Authorization
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = new aws.cloudwatch.EventConnection("test", {
 *     name: "ngrok-connection",
 *     description: "A connection description",
 *     authorizationType: "BASIC",
 *     authParameters: {
 *         basic: {
 *             username: "user",
 *             password: "Pass1234!",
 *         },
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test = aws.cloudwatch.EventConnection("test",
 *     name="ngrok-connection",
 *     description="A connection description",
 *     authorization_type="BASIC",
 *     auth_parameters={
 *         "basic": {
 *             "username": "user",
 *             "password": "Pass1234!",
 *         },
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new Aws.CloudWatch.EventConnection("test", new()
 *     {
 *         Name = "ngrok-connection",
 *         Description = "A connection description",
 *         AuthorizationType = "BASIC",
 *         AuthParameters = new Aws.CloudWatch.Inputs.EventConnectionAuthParametersArgs
 *         {
 *             Basic = new Aws.CloudWatch.Inputs.EventConnectionAuthParametersBasicArgs
 *             {
 *                 Username = "user",
 *                 Password = "Pass1234!",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cloudwatch"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cloudwatch.NewEventConnection(ctx, "test", &cloudwatch.EventConnectionArgs{
 * 			Name:              pulumi.String("ngrok-connection"),
 * 			Description:       pulumi.String("A connection description"),
 * 			AuthorizationType: pulumi.String("BASIC"),
 * 			AuthParameters: &cloudwatch.EventConnectionAuthParametersArgs{
 * 				Basic: &cloudwatch.EventConnectionAuthParametersBasicArgs{
 * 					Username: pulumi.String("user"),
 * 					Password: pulumi.String("Pass1234!"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudwatch.EventConnection;
 * import com.pulumi.aws.cloudwatch.EventConnectionArgs;
 * import com.pulumi.aws.cloudwatch.inputs.EventConnectionAuthParametersArgs;
 * import com.pulumi.aws.cloudwatch.inputs.EventConnectionAuthParametersBasicArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new EventConnection("test", EventConnectionArgs.builder()
 *             .name("ngrok-connection")
 *             .description("A connection description")
 *             .authorizationType("BASIC")
 *             .authParameters(EventConnectionAuthParametersArgs.builder()
 *                 .basic(EventConnectionAuthParametersBasicArgs.builder()
 *                     .username("user")
 *                     .password("Pass1234!")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:cloudwatch:EventConnection
 *     properties:
 *       name: ngrok-connection
 *       description: A connection description
 *       authorizationType: BASIC
 *       authParameters:
 *         basic:
 *           username: user
 *           password: Pass1234!
 * ```
 * <!--End PulumiCodeChooser -->
 * ### OAuth Authorization
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = new aws.cloudwatch.EventConnection("test", {
 *     name: "ngrok-connection",
 *     description: "A connection description",
 *     authorizationType: "OAUTH_CLIENT_CREDENTIALS",
 *     authParameters: {
 *         oauth: {
 *             authorizationEndpoint: "https://auth.url.com/endpoint",
 *             httpMethod: "GET",
 *             clientParameters: {
 *                 clientId: "1234567890",
 *                 clientSecret: "Pass1234!",
 *             },
 *             oauthHttpParameters: {
 *                 bodies: [{
 *                     key: "body-parameter-key",
 *                     value: "body-parameter-value",
 *                     isValueSecret: false,
 *                 }],
 *                 headers: [{
 *                     key: "header-parameter-key",
 *                     value: "header-parameter-value",
 *                     isValueSecret: false,
 *                 }],
 *                 queryStrings: [{
 *                     key: "query-string-parameter-key",
 *                     value: "query-string-parameter-value",
 *                     isValueSecret: false,
 *                 }],
 *             },
 *         },
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test = aws.cloudwatch.EventConnection("test",
 *     name="ngrok-connection",
 *     description="A connection description",
 *     authorization_type="OAUTH_CLIENT_CREDENTIALS",
 *     auth_parameters={
 *         "oauth": {
 *             "authorization_endpoint": "https://auth.url.com/endpoint",
 *             "http_method": "GET",
 *             "client_parameters": {
 *                 "client_id": "1234567890",
 *                 "client_secret": "Pass1234!",
 *             },
 *             "oauth_http_parameters": {
 *                 "bodies": [{
 *                     "key": "body-parameter-key",
 *                     "value": "body-parameter-value",
 *                     "is_value_secret": False,
 *                 }],
 *                 "headers": [{
 *                     "key": "header-parameter-key",
 *                     "value": "header-parameter-value",
 *                     "is_value_secret": False,
 *                 }],
 *                 "query_strings": [{
 *                     "key": "query-string-parameter-key",
 *                     "value": "query-string-parameter-value",
 *                     "is_value_secret": False,
 *                 }],
 *             },
 *         },
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new Aws.CloudWatch.EventConnection("test", new()
 *     {
 *         Name = "ngrok-connection",
 *         Description = "A connection description",
 *         AuthorizationType = "OAUTH_CLIENT_CREDENTIALS",
 *         AuthParameters = new Aws.CloudWatch.Inputs.EventConnectionAuthParametersArgs
 *         {
 *             Oauth = new Aws.CloudWatch.Inputs.EventConnectionAuthParametersOauthArgs
 *             {
 *                 AuthorizationEndpoint = "https://auth.url.com/endpoint",
 *                 HttpMethod = "GET",
 *                 ClientParameters = new Aws.CloudWatch.Inputs.EventConnectionAuthParametersOauthClientParametersArgs
 *                 {
 *                     ClientId = "1234567890",
 *                     ClientSecret = "Pass1234!",
 *                 },
 *                 OauthHttpParameters = new Aws.CloudWatch.Inputs.EventConnectionAuthParametersOauthOauthHttpParametersArgs
 *                 {
 *                     Bodies = new[]
 *                     {
 *                         new Aws.CloudWatch.Inputs.EventConnectionAuthParametersOauthOauthHttpParametersBodyArgs
 *                         {
 *                             Key = "body-parameter-key",
 *                             Value = "body-parameter-value",
 *                             IsValueSecret = false,
 *                         },
 *                     },
 *                     Headers = new[]
 *                     {
 *                         new Aws.CloudWatch.Inputs.EventConnectionAuthParametersOauthOauthHttpParametersHeaderArgs
 *                         {
 *                             Key = "header-parameter-key",
 *                             Value = "header-parameter-value",
 *                             IsValueSecret = false,
 *                         },
 *                     },
 *                     QueryStrings = new[]
 *                     {
 *                         new Aws.CloudWatch.Inputs.EventConnectionAuthParametersOauthOauthHttpParametersQueryStringArgs
 *                         {
 *                             Key = "query-string-parameter-key",
 *                             Value = "query-string-parameter-value",
 *                             IsValueSecret = false,
 *                         },
 *                     },
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cloudwatch"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cloudwatch.NewEventConnection(ctx, "test", &cloudwatch.EventConnectionArgs{
 * 			Name:              pulumi.String("ngrok-connection"),
 * 			Description:       pulumi.String("A connection description"),
 * 			AuthorizationType: pulumi.String("OAUTH_CLIENT_CREDENTIALS"),
 * 			AuthParameters: &cloudwatch.EventConnectionAuthParametersArgs{
 * 				Oauth: &cloudwatch.EventConnectionAuthParametersOauthArgs{
 * 					AuthorizationEndpoint: pulumi.String("https://auth.url.com/endpoint"),
 * 					HttpMethod:            pulumi.String("GET"),
 * 					ClientParameters: &cloudwatch.EventConnectionAuthParametersOauthClientParametersArgs{
 * 						ClientId:     pulumi.String("1234567890"),
 * 						ClientSecret: pulumi.String("Pass1234!"),
 * 					},
 * 					OauthHttpParameters: &cloudwatch.EventConnectionAuthParametersOauthOauthHttpParametersArgs{
 * 						Bodies: cloudwatch.EventConnectionAuthParametersOauthOauthHttpParametersBodyArray{
 * 							&cloudwatch.EventConnectionAuthParametersOauthOauthHttpParametersBodyArgs{
 * 								Key:           pulumi.String("body-parameter-key"),
 * 								Value:         pulumi.String("body-parameter-value"),
 * 								IsValueSecret: pulumi.Bool(false),
 * 							},
 * 						},
 * 						Headers: cloudwatch.EventConnectionAuthParametersOauthOauthHttpParametersHeaderArray{
 * 							&cloudwatch.EventConnectionAuthParametersOauthOauthHttpParametersHeaderArgs{
 * 								Key:           pulumi.String("header-parameter-key"),
 * 								Value:         pulumi.String("header-parameter-value"),
 * 								IsValueSecret: pulumi.Bool(false),
 * 							},
 * 						},
 * 						QueryStrings: cloudwatch.EventConnectionAuthParametersOauthOauthHttpParametersQueryStringArray{
 * 							&cloudwatch.EventConnectionAuthParametersOauthOauthHttpParametersQueryStringArgs{
 * 								Key:           pulumi.String("query-string-parameter-key"),
 * 								Value:         pulumi.String("query-string-parameter-value"),
 * 								IsValueSecret: pulumi.Bool(false),
 * 							},
 * 						},
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudwatch.EventConnection;
 * import com.pulumi.aws.cloudwatch.EventConnectionArgs;
 * import com.pulumi.aws.cloudwatch.inputs.EventConnectionAuthParametersArgs;
 * import com.pulumi.aws.cloudwatch.inputs.EventConnectionAuthParametersOauthArgs;
 * import com.pulumi.aws.cloudwatch.inputs.EventConnectionAuthParametersOauthClientParametersArgs;
 * import com.pulumi.aws.cloudwatch.inputs.EventConnectionAuthParametersOauthOauthHttpParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new EventConnection("test", EventConnectionArgs.builder()
 *             .name("ngrok-connection")
 *             .description("A connection description")
 *             .authorizationType("OAUTH_CLIENT_CREDENTIALS")
 *             .authParameters(EventConnectionAuthParametersArgs.builder()
 *                 .oauth(EventConnectionAuthParametersOauthArgs.builder()
 *                     .authorizationEndpoint("https://auth.url.com/endpoint")
 *                     .httpMethod("GET")
 *                     .clientParameters(EventConnectionAuthParametersOauthClientParametersArgs.builder()
 *                         .clientId("1234567890")
 *                         .clientSecret("Pass1234!")
 *                         .build())
 *                     .oauthHttpParameters(EventConnectionAuthParametersOauthOauthHttpParametersArgs.builder()
 *                         .bodies(EventConnectionAuthParametersOauthOauthHttpParametersBodyArgs.builder()
 *                             .key("body-parameter-key")
 *                             .value("body-parameter-value")
 *                             .isValueSecret(false)
 *                             .build())
 *                         .headers(EventConnectionAuthParametersOauthOauthHttpParametersHeaderArgs.builder()
 *                             .key("header-parameter-key")
 *                             .value("header-parameter-value")
 *                             .isValueSecret(false)
 *                             .build())
 *                         .queryStrings(EventConnectionAuthParametersOauthOauthHttpParametersQueryStringArgs.builder()
 *                             .key("query-string-parameter-key")
 *                             .value("query-string-parameter-value")
 *                             .isValueSecret(false)
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:cloudwatch:EventConnection
 *     properties:
 *       name: ngrok-connection
 *       description: A connection description
 *       authorizationType: OAUTH_CLIENT_CREDENTIALS
 *       authParameters:
 *         oauth:
 *           authorizationEndpoint: https://auth.url.com/endpoint
 *           httpMethod: GET
 *           clientParameters:
 *             clientId: '1234567890'
 *             clientSecret: Pass1234!
 *           oauthHttpParameters:
 *             bodies:
 *               - key: body-parameter-key
 *                 value: body-parameter-value
 *                 isValueSecret: false
 *             headers:
 *               - key: header-parameter-key
 *                 value: header-parameter-value
 *                 isValueSecret: false
 *             queryStrings:
 *               - key: query-string-parameter-key
 *                 value: query-string-parameter-value
 *                 isValueSecret: false
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Invocation Http Parameters
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = new aws.cloudwatch.EventConnection("test", {
 *     name: "ngrok-connection",
 *     description: "A connection description",
 *     authorizationType: "BASIC",
 *     authParameters: {
 *         basic: {
 *             username: "user",
 *             password: "Pass1234!",
 *         },
 *         invocationHttpParameters: {
 *             bodies: [
 *                 {
 *                     key: "body-parameter-key",
 *                     value: "body-parameter-value",
 *                     isValueSecret: false,
 *                 },
 *                 {
 *                     key: "body-parameter-key2",
 *                     value: "body-parameter-value2",
 *                     isValueSecret: true,
 *                 },
 *             ],
 *             headers: [{
 *                 key: "header-parameter-key",
 *                 value: "header-parameter-value",
 *                 isValueSecret: false,
 *             }],
 *             queryStrings: [{
 *                 key: "query-string-parameter-key",
 *                 value: "query-string-parameter-value",
 *                 isValueSecret: false,
 *             }],
 *         },
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test = aws.cloudwatch.EventConnection("test",
 *     name="ngrok-connection",
 *     description="A connection description",
 *     authorization_type="BASIC",
 *     auth_parameters={
 *         "basic": {
 *             "username": "user",
 *             "password": "Pass1234!",
 *         },
 *         "invocation_http_parameters": {
 *             "bodies": [
 *                 {
 *                     "key": "body-parameter-key",
 *                     "value": "body-parameter-value",
 *                     "is_value_secret": False,
 *                 },
 *                 {
 *                     "key": "body-parameter-key2",
 *                     "value": "body-parameter-value2",
 *                     "is_value_secret": True,
 *                 },
 *             ],
 *             "headers": [{
 *                 "key": "header-parameter-key",
 *                 "value": "header-parameter-value",
 *                 "is_value_secret": False,
 *             }],
 *             "query_strings": [{
 *                 "key": "query-string-parameter-key",
 *                 "value": "query-string-parameter-value",
 *                 "is_value_secret": False,
 *             }],
 *         },
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new Aws.CloudWatch.EventConnection("test", new()
 *     {
 *         Name = "ngrok-connection",
 *         Description = "A connection description",
 *         AuthorizationType = "BASIC",
 *         AuthParameters = new Aws.CloudWatch.Inputs.EventConnectionAuthParametersArgs
 *         {
 *             Basic = new Aws.CloudWatch.Inputs.EventConnectionAuthParametersBasicArgs
 *             {
 *                 Username = "user",
 *                 Password = "Pass1234!",
 *             },
 *             InvocationHttpParameters = new Aws.CloudWatch.Inputs.EventConnectionAuthParametersInvocationHttpParametersArgs
 *             {
 *                 Bodies = new[]
 *                 {
 *                     new Aws.CloudWatch.Inputs.EventConnectionAuthParametersInvocationHttpParametersBodyArgs
 *                     {
 *                         Key = "body-parameter-key",
 *                         Value = "body-parameter-value",
 *                         IsValueSecret = false,
 *                     },
 *                     new Aws.CloudWatch.Inputs.EventConnectionAuthParametersInvocationHttpParametersBodyArgs
 *                     {
 *                         Key = "body-parameter-key2",
 *                         Value = "body-parameter-value2",
 *                         IsValueSecret = true,
 *                     },
 *                 },
 *                 Headers = new[]
 *                 {
 *                     new Aws.CloudWatch.Inputs.EventConnectionAuthParametersInvocationHttpParametersHeaderArgs
 *                     {
 *                         Key = "header-parameter-key",
 *                         Value = "header-parameter-value",
 *                         IsValueSecret = false,
 *                     },
 *                 },
 *                 QueryStrings = new[]
 *                 {
 *                     new Aws.CloudWatch.Inputs.EventConnectionAuthParametersInvocationHttpParametersQueryStringArgs
 *                     {
 *                         Key = "query-string-parameter-key",
 *                         Value = "query-string-parameter-value",
 *                         IsValueSecret = false,
 *                     },
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cloudwatch"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cloudwatch.NewEventConnection(ctx, "test", &cloudwatch.EventConnectionArgs{
 * 			Name:              pulumi.String("ngrok-connection"),
 * 			Description:       pulumi.String("A connection description"),
 * 			AuthorizationType: pulumi.String("BASIC"),
 * 			AuthParameters: &cloudwatch.EventConnectionAuthParametersArgs{
 * 				Basic: &cloudwatch.EventConnectionAuthParametersBasicArgs{
 * 					Username: pulumi.String("user"),
 * 					Password: pulumi.String("Pass1234!"),
 * 				},
 * 				InvocationHttpParameters: &cloudwatch.EventConnectionAuthParametersInvocationHttpParametersArgs{
 * 					Bodies: cloudwatch.EventConnectionAuthParametersInvocationHttpParametersBodyArray{
 * 						&cloudwatch.EventConnectionAuthParametersInvocationHttpParametersBodyArgs{
 * 							Key:           pulumi.String("body-parameter-key"),
 * 							Value:         pulumi.String("body-parameter-value"),
 * 							IsValueSecret: pulumi.Bool(false),
 * 						},
 * 						&cloudwatch.EventConnectionAuthParametersInvocationHttpParametersBodyArgs{
 * 							Key:           pulumi.String("body-parameter-key2"),
 * 							Value:         pulumi.String("body-parameter-value2"),
 * 							IsValueSecret: pulumi.Bool(true),
 * 						},
 * 					},
 * 					Headers: cloudwatch.EventConnectionAuthParametersInvocationHttpParametersHeaderArray{
 * 						&cloudwatch.EventConnectionAuthParametersInvocationHttpParametersHeaderArgs{
 * 							Key:           pulumi.String("header-parameter-key"),
 * 							Value:         pulumi.String("header-parameter-value"),
 * 							IsValueSecret: pulumi.Bool(false),
 * 						},
 * 					},
 * 					QueryStrings: cloudwatch.EventConnectionAuthParametersInvocationHttpParametersQueryStringArray{
 * 						&cloudwatch.EventConnectionAuthParametersInvocationHttpParametersQueryStringArgs{
 * 							Key:           pulumi.String("query-string-parameter-key"),
 * 							Value:         pulumi.String("query-string-parameter-value"),
 * 							IsValueSecret: pulumi.Bool(false),
 * 						},
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudwatch.EventConnection;
 * import com.pulumi.aws.cloudwatch.EventConnectionArgs;
 * import com.pulumi.aws.cloudwatch.inputs.EventConnectionAuthParametersArgs;
 * import com.pulumi.aws.cloudwatch.inputs.EventConnectionAuthParametersBasicArgs;
 * import com.pulumi.aws.cloudwatch.inputs.EventConnectionAuthParametersInvocationHttpParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new EventConnection("test", EventConnectionArgs.builder()
 *             .name("ngrok-connection")
 *             .description("A connection description")
 *             .authorizationType("BASIC")
 *             .authParameters(EventConnectionAuthParametersArgs.builder()
 *                 .basic(EventConnectionAuthParametersBasicArgs.builder()
 *                     .username("user")
 *                     .password("Pass1234!")
 *                     .build())
 *                 .invocationHttpParameters(EventConnectionAuthParametersInvocationHttpParametersArgs.builder()
 *                     .bodies(
 *                         EventConnectionAuthParametersInvocationHttpParametersBodyArgs.builder()
 *                             .key("body-parameter-key")
 *                             .value("body-parameter-value")
 *                             .isValueSecret(false)
 *                             .build(),
 *                         EventConnectionAuthParametersInvocationHttpParametersBodyArgs.builder()
 *                             .key("body-parameter-key2")
 *                             .value("body-parameter-value2")
 *                             .isValueSecret(true)
 *                             .build())
 *                     .headers(EventConnectionAuthParametersInvocationHttpParametersHeaderArgs.builder()
 *                         .key("header-parameter-key")
 *                         .value("header-parameter-value")
 *                         .isValueSecret(false)
 *                         .build())
 *                     .queryStrings(EventConnectionAuthParametersInvocationHttpParametersQueryStringArgs.builder()
 *                         .key("query-string-parameter-key")
 *                         .value("query-string-parameter-value")
 *                         .isValueSecret(false)
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:cloudwatch:EventConnection
 *     properties:
 *       name: ngrok-connection
 *       description: A connection description
 *       authorizationType: BASIC
 *       authParameters:
 *         basic:
 *           username: user
 *           password: Pass1234!
 *         invocationHttpParameters:
 *           bodies:
 *             - key: body-parameter-key
 *               value: body-parameter-value
 *               isValueSecret: false
 *             - key: body-parameter-key2
 *               value: body-parameter-value2
 *               isValueSecret: true
 *           headers:
 *             - key: header-parameter-key
 *               value: header-parameter-value
 *               isValueSecret: false
 *           queryStrings:
 *             - key: query-string-parameter-key
 *               value: query-string-parameter-value
 *               isValueSecret: false
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import EventBridge EventBridge connection using the `name`. For example:
 * ```sh
 * $ pulumi import aws:cloudwatch/eventConnection:EventConnection test ngrok-connection
 * ```
 * @property authParameters Parameters used for authorization. A maximum of 1 are allowed. Documented below.
 * @property authorizationType Choose the type of authorization to use for the connection. One of `API_KEY`,`BASIC`,`OAUTH_CLIENT_CREDENTIALS`.
 * @property description Enter a description for the connection. Maximum of 512 characters.
 * @property name The name of the new connection. Maximum of 64 characters consisting of numbers, lower/upper case letters, .,-,_.
 */
public data class EventConnectionArgs(
    public val authParameters: Output<EventConnectionAuthParametersArgs>? = null,
    public val authorizationType: Output<String>? = null,
    public val description: Output<String>? = null,
    public val name: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.cloudwatch.EventConnectionArgs> {
    override fun toJava(): com.pulumi.aws.cloudwatch.EventConnectionArgs =
        com.pulumi.aws.cloudwatch.EventConnectionArgs.builder()
            .authParameters(authParameters?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .authorizationType(authorizationType?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EventConnectionArgs].
 */
@PulumiTagMarker
public class EventConnectionArgsBuilder internal constructor() {
    private var authParameters: Output<EventConnectionAuthParametersArgs>? = null

    private var authorizationType: Output<String>? = null

    private var description: Output<String>? = null

    private var name: Output<String>? = null

    /**
     * @param value Parameters used for authorization. A maximum of 1 are allowed. Documented below.
     */
    @JvmName("qkflvygpyjwdoshe")
    public suspend fun authParameters(`value`: Output<EventConnectionAuthParametersArgs>) {
        this.authParameters = value
    }

    /**
     * @param value Choose the type of authorization to use for the connection. One of `API_KEY`,`BASIC`,`OAUTH_CLIENT_CREDENTIALS`.
     */
    @JvmName("wdctcjrkkscomarr")
    public suspend fun authorizationType(`value`: Output<String>) {
        this.authorizationType = value
    }

    /**
     * @param value Enter a description for the connection. Maximum of 512 characters.
     */
    @JvmName("ojqtdmplalxhxkpc")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The name of the new connection. Maximum of 64 characters consisting of numbers, lower/upper case letters, .,-,_.
     */
    @JvmName("gxnfxdgeuwfoudeg")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Parameters used for authorization. A maximum of 1 are allowed. Documented below.
     */
    @JvmName("dveulbcmiuaxysnn")
    public suspend fun authParameters(`value`: EventConnectionAuthParametersArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authParameters = mapped
    }

    /**
     * @param argument Parameters used for authorization. A maximum of 1 are allowed. Documented below.
     */
    @JvmName("ismiikxpvrhkuewh")
    public suspend fun authParameters(argument: suspend EventConnectionAuthParametersArgsBuilder.() -> Unit) {
        val toBeMapped = EventConnectionAuthParametersArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.authParameters = mapped
    }

    /**
     * @param value Choose the type of authorization to use for the connection. One of `API_KEY`,`BASIC`,`OAUTH_CLIENT_CREDENTIALS`.
     */
    @JvmName("ngrdsseglekuybka")
    public suspend fun authorizationType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authorizationType = mapped
    }

    /**
     * @param value Enter a description for the connection. Maximum of 512 characters.
     */
    @JvmName("fctfospylbqnefts")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The name of the new connection. Maximum of 64 characters consisting of numbers, lower/upper case letters, .,-,_.
     */
    @JvmName("cailgidxoybklial")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): EventConnectionArgs = EventConnectionArgs(
        authParameters = authParameters,
        authorizationType = authorizationType,
        description = description,
        name = name,
    )
}
