@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudwatch.kotlin

import com.pulumi.aws.cloudwatch.kotlin.outputs.EventPermissionCondition
import com.pulumi.aws.cloudwatch.kotlin.outputs.EventPermissionCondition.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [EventPermission].
 */
@PulumiTagMarker
public class EventPermissionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: EventPermissionArgs = EventPermissionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend EventPermissionArgsBuilder.() -> Unit) {
        val builder = EventPermissionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): EventPermission {
        val builtJavaResource = com.pulumi.aws.cloudwatch.EventPermission(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return EventPermission(builtJavaResource)
    }
}

/**
 * Provides a resource to create an EventBridge permission to support cross-account events in the current account default event bus.
 * > **Note:** EventBridge was formerly known as CloudWatch Events. The functionality is identical.
 * > **Note:** The EventBridge bus policy resource  (`aws.cloudwatch.EventBusPolicy`) is incompatible with the EventBridge permission resource (`aws.cloudwatch.EventPermission`) and will overwrite permissions.
 * ## Example Usage
 * ### Account Access
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const devAccountAccess = new aws.cloudwatch.EventPermission("DevAccountAccess", {
 *     principal: "123456789012",
 *     statementId: "DevAccountAccess",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * dev_account_access = aws.cloudwatch.EventPermission("DevAccountAccess",
 *     principal="123456789012",
 *     statement_id="DevAccountAccess")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var devAccountAccess = new Aws.CloudWatch.EventPermission("DevAccountAccess", new()
 *     {
 *         Principal = "123456789012",
 *         StatementId = "DevAccountAccess",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cloudwatch"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cloudwatch.NewEventPermission(ctx, "DevAccountAccess", &cloudwatch.EventPermissionArgs{
 * 			Principal:   pulumi.String("123456789012"),
 * 			StatementId: pulumi.String("DevAccountAccess"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudwatch.EventPermission;
 * import com.pulumi.aws.cloudwatch.EventPermissionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var devAccountAccess = new EventPermission("devAccountAccess", EventPermissionArgs.builder()
 *             .principal("123456789012")
 *             .statementId("DevAccountAccess")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   devAccountAccess:
 *     type: aws:cloudwatch:EventPermission
 *     name: DevAccountAccess
 *     properties:
 *       principal: '123456789012'
 *       statementId: DevAccountAccess
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Organization Access
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const organizationAccess = new aws.cloudwatch.EventPermission("OrganizationAccess", {
 *     principal: "*",
 *     statementId: "OrganizationAccess",
 *     condition: {
 *         key: "aws:PrincipalOrgID",
 *         type: "StringEquals",
 *         value: example.id,
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * organization_access = aws.cloudwatch.EventPermission("OrganizationAccess",
 *     principal="*",
 *     statement_id="OrganizationAccess",
 *     condition={
 *         "key": "aws:PrincipalOrgID",
 *         "type": "StringEquals",
 *         "value": example["id"],
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var organizationAccess = new Aws.CloudWatch.EventPermission("OrganizationAccess", new()
 *     {
 *         Principal = "*",
 *         StatementId = "OrganizationAccess",
 *         Condition = new Aws.CloudWatch.Inputs.EventPermissionConditionArgs
 *         {
 *             Key = "aws:PrincipalOrgID",
 *             Type = "StringEquals",
 *             Value = example.Id,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cloudwatch"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cloudwatch.NewEventPermission(ctx, "OrganizationAccess", &cloudwatch.EventPermissionArgs{
 * 			Principal:   pulumi.String("*"),
 * 			StatementId: pulumi.String("OrganizationAccess"),
 * 			Condition: &cloudwatch.EventPermissionConditionArgs{
 * 				Key:   pulumi.String("aws:PrincipalOrgID"),
 * 				Type:  pulumi.String("StringEquals"),
 * 				Value: pulumi.Any(example.Id),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudwatch.EventPermission;
 * import com.pulumi.aws.cloudwatch.EventPermissionArgs;
 * import com.pulumi.aws.cloudwatch.inputs.EventPermissionConditionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var organizationAccess = new EventPermission("organizationAccess", EventPermissionArgs.builder()
 *             .principal("*")
 *             .statementId("OrganizationAccess")
 *             .condition(EventPermissionConditionArgs.builder()
 *                 .key("aws:PrincipalOrgID")
 *                 .type("StringEquals")
 *                 .value(example.id())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   organizationAccess:
 *     type: aws:cloudwatch:EventPermission
 *     name: OrganizationAccess
 *     properties:
 *       principal: '*'
 *       statementId: OrganizationAccess
 *       condition:
 *         key: aws:PrincipalOrgID
 *         type: StringEquals
 *         value: ${example.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import EventBridge permissions using the `event_bus_name/statement_id` (if you omit `event_bus_name`, the `default` event bus will be used). For example:
 * ```sh
 * $ pulumi import aws:cloudwatch/eventPermission:EventPermission DevAccountAccess example-event-bus/DevAccountAccess
 * ```
 */
public class EventPermission internal constructor(
    override val javaResource: com.pulumi.aws.cloudwatch.EventPermission,
) : KotlinCustomResource(javaResource, EventPermissionMapper) {
    /**
     * The action that you are enabling the other account to perform. Defaults to `events:PutEvents`.
     */
    public val action: Output<String>?
        get() = javaResource.action().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Configuration block to limit the event bus permissions you are granting to only accounts that fulfill the condition. Specified below.
     */
    public val condition: Output<EventPermissionCondition>?
        get() = javaResource.condition().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The name of the event bus to set the permissions on.
     * If you omit this, the permissions are set on the `default` event bus.
     */
    public val eventBusName: Output<String>?
        get() = javaResource.eventBusName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The 12-digit AWS account ID that you are permitting to put events to your default event bus. Specify `*` to permit any account to put events to your default event bus, optionally limited by `condition`.
     */
    public val principal: Output<String>
        get() = javaResource.principal().applyValue({ args0 -> args0 })

    /**
     * An identifier string for the external account that you are granting permissions to.
     */
    public val statementId: Output<String>
        get() = javaResource.statementId().applyValue({ args0 -> args0 })
}

public object EventPermissionMapper : ResourceMapper<EventPermission> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.cloudwatch.EventPermission::class == javaResource::class

    override fun map(javaResource: Resource): EventPermission = EventPermission(
        javaResource as
            com.pulumi.aws.cloudwatch.EventPermission,
    )
}

/**
 * @see [EventPermission].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [EventPermission].
 */
public suspend fun eventPermission(
    name: String,
    block: suspend EventPermissionResourceBuilder.() -> Unit,
): EventPermission {
    val builder = EventPermissionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [EventPermission].
 * @param name The _unique_ name of the resulting resource.
 */
public fun eventPermission(name: String): EventPermission {
    val builder = EventPermissionResourceBuilder()
    builder.name(name)
    return builder.build()
}
