@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudwatch.kotlin

import com.pulumi.aws.cloudwatch.EventPermissionArgs.builder
import com.pulumi.aws.cloudwatch.kotlin.inputs.EventPermissionConditionArgs
import com.pulumi.aws.cloudwatch.kotlin.inputs.EventPermissionConditionArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Provides a resource to create an EventBridge permission to support cross-account events in the current account default event bus.
 * > **Note:** EventBridge was formerly known as CloudWatch Events. The functionality is identical.
 * > **Note:** The EventBridge bus policy resource  (`aws.cloudwatch.EventBusPolicy`) is incompatible with the EventBridge permission resource (`aws.cloudwatch.EventPermission`) and will overwrite permissions.
 * ## Example Usage
 * ### Account Access
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const devAccountAccess = new aws.cloudwatch.EventPermission("DevAccountAccess", {
 *     principal: "123456789012",
 *     statementId: "DevAccountAccess",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * dev_account_access = aws.cloudwatch.EventPermission("DevAccountAccess",
 *     principal="123456789012",
 *     statement_id="DevAccountAccess")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var devAccountAccess = new Aws.CloudWatch.EventPermission("DevAccountAccess", new()
 *     {
 *         Principal = "123456789012",
 *         StatementId = "DevAccountAccess",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cloudwatch"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cloudwatch.NewEventPermission(ctx, "DevAccountAccess", &cloudwatch.EventPermissionArgs{
 * 			Principal:   pulumi.String("123456789012"),
 * 			StatementId: pulumi.String("DevAccountAccess"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudwatch.EventPermission;
 * import com.pulumi.aws.cloudwatch.EventPermissionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var devAccountAccess = new EventPermission("devAccountAccess", EventPermissionArgs.builder()
 *             .principal("123456789012")
 *             .statementId("DevAccountAccess")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   devAccountAccess:
 *     type: aws:cloudwatch:EventPermission
 *     name: DevAccountAccess
 *     properties:
 *       principal: '123456789012'
 *       statementId: DevAccountAccess
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Organization Access
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const organizationAccess = new aws.cloudwatch.EventPermission("OrganizationAccess", {
 *     principal: "*",
 *     statementId: "OrganizationAccess",
 *     condition: {
 *         key: "aws:PrincipalOrgID",
 *         type: "StringEquals",
 *         value: example.id,
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * organization_access = aws.cloudwatch.EventPermission("OrganizationAccess",
 *     principal="*",
 *     statement_id="OrganizationAccess",
 *     condition={
 *         "key": "aws:PrincipalOrgID",
 *         "type": "StringEquals",
 *         "value": example["id"],
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var organizationAccess = new Aws.CloudWatch.EventPermission("OrganizationAccess", new()
 *     {
 *         Principal = "*",
 *         StatementId = "OrganizationAccess",
 *         Condition = new Aws.CloudWatch.Inputs.EventPermissionConditionArgs
 *         {
 *             Key = "aws:PrincipalOrgID",
 *             Type = "StringEquals",
 *             Value = example.Id,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cloudwatch"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cloudwatch.NewEventPermission(ctx, "OrganizationAccess", &cloudwatch.EventPermissionArgs{
 * 			Principal:   pulumi.String("*"),
 * 			StatementId: pulumi.String("OrganizationAccess"),
 * 			Condition: &cloudwatch.EventPermissionConditionArgs{
 * 				Key:   pulumi.String("aws:PrincipalOrgID"),
 * 				Type:  pulumi.String("StringEquals"),
 * 				Value: pulumi.Any(example.Id),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudwatch.EventPermission;
 * import com.pulumi.aws.cloudwatch.EventPermissionArgs;
 * import com.pulumi.aws.cloudwatch.inputs.EventPermissionConditionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var organizationAccess = new EventPermission("organizationAccess", EventPermissionArgs.builder()
 *             .principal("*")
 *             .statementId("OrganizationAccess")
 *             .condition(EventPermissionConditionArgs.builder()
 *                 .key("aws:PrincipalOrgID")
 *                 .type("StringEquals")
 *                 .value(example.id())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   organizationAccess:
 *     type: aws:cloudwatch:EventPermission
 *     name: OrganizationAccess
 *     properties:
 *       principal: '*'
 *       statementId: OrganizationAccess
 *       condition:
 *         key: aws:PrincipalOrgID
 *         type: StringEquals
 *         value: ${example.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import EventBridge permissions using the `event_bus_name/statement_id` (if you omit `event_bus_name`, the `default` event bus will be used). For example:
 * ```sh
 * $ pulumi import aws:cloudwatch/eventPermission:EventPermission DevAccountAccess example-event-bus/DevAccountAccess
 * ```
 * @property action The action that you are enabling the other account to perform. Defaults to `events:PutEvents`.
 * @property condition Configuration block to limit the event bus permissions you are granting to only accounts that fulfill the condition. Specified below.
 * @property eventBusName The name of the event bus to set the permissions on.
 * If you omit this, the permissions are set on the `default` event bus.
 * @property principal The 12-digit AWS account ID that you are permitting to put events to your default event bus. Specify `*` to permit any account to put events to your default event bus, optionally limited by `condition`.
 * @property statementId An identifier string for the external account that you are granting permissions to.
 */
public data class EventPermissionArgs(
    public val action: Output<String>? = null,
    public val condition: Output<EventPermissionConditionArgs>? = null,
    public val eventBusName: Output<String>? = null,
    public val principal: Output<String>? = null,
    public val statementId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.cloudwatch.EventPermissionArgs> {
    override fun toJava(): com.pulumi.aws.cloudwatch.EventPermissionArgs =
        com.pulumi.aws.cloudwatch.EventPermissionArgs.builder()
            .action(action?.applyValue({ args0 -> args0 }))
            .condition(condition?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .eventBusName(eventBusName?.applyValue({ args0 -> args0 }))
            .principal(principal?.applyValue({ args0 -> args0 }))
            .statementId(statementId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EventPermissionArgs].
 */
@PulumiTagMarker
public class EventPermissionArgsBuilder internal constructor() {
    private var action: Output<String>? = null

    private var condition: Output<EventPermissionConditionArgs>? = null

    private var eventBusName: Output<String>? = null

    private var principal: Output<String>? = null

    private var statementId: Output<String>? = null

    /**
     * @param value The action that you are enabling the other account to perform. Defaults to `events:PutEvents`.
     */
    @JvmName("ckgmhxmjqgekmgkq")
    public suspend fun action(`value`: Output<String>) {
        this.action = value
    }

    /**
     * @param value Configuration block to limit the event bus permissions you are granting to only accounts that fulfill the condition. Specified below.
     */
    @JvmName("boqpeufhmriuuvec")
    public suspend fun condition(`value`: Output<EventPermissionConditionArgs>) {
        this.condition = value
    }

    /**
     * @param value The name of the event bus to set the permissions on.
     * If you omit this, the permissions are set on the `default` event bus.
     */
    @JvmName("myybjxbyklrkosmb")
    public suspend fun eventBusName(`value`: Output<String>) {
        this.eventBusName = value
    }

    /**
     * @param value The 12-digit AWS account ID that you are permitting to put events to your default event bus. Specify `*` to permit any account to put events to your default event bus, optionally limited by `condition`.
     */
    @JvmName("jponbthjrlqtyxsf")
    public suspend fun principal(`value`: Output<String>) {
        this.principal = value
    }

    /**
     * @param value An identifier string for the external account that you are granting permissions to.
     */
    @JvmName("vcefpyunetqgsqdg")
    public suspend fun statementId(`value`: Output<String>) {
        this.statementId = value
    }

    /**
     * @param value The action that you are enabling the other account to perform. Defaults to `events:PutEvents`.
     */
    @JvmName("wqxpeiwwyoykashr")
    public suspend fun action(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.action = mapped
    }

    /**
     * @param value Configuration block to limit the event bus permissions you are granting to only accounts that fulfill the condition. Specified below.
     */
    @JvmName("gdtlkleofutewjqv")
    public suspend fun condition(`value`: EventPermissionConditionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.condition = mapped
    }

    /**
     * @param argument Configuration block to limit the event bus permissions you are granting to only accounts that fulfill the condition. Specified below.
     */
    @JvmName("ugxumfcyxvthkigs")
    public suspend fun condition(argument: suspend EventPermissionConditionArgsBuilder.() -> Unit) {
        val toBeMapped = EventPermissionConditionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.condition = mapped
    }

    /**
     * @param value The name of the event bus to set the permissions on.
     * If you omit this, the permissions are set on the `default` event bus.
     */
    @JvmName("mcjapeyvpwctatqe")
    public suspend fun eventBusName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eventBusName = mapped
    }

    /**
     * @param value The 12-digit AWS account ID that you are permitting to put events to your default event bus. Specify `*` to permit any account to put events to your default event bus, optionally limited by `condition`.
     */
    @JvmName("tcwiapqfnoomtyms")
    public suspend fun principal(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.principal = mapped
    }

    /**
     * @param value An identifier string for the external account that you are granting permissions to.
     */
    @JvmName("fjowtcurdupvufar")
    public suspend fun statementId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.statementId = mapped
    }

    internal fun build(): EventPermissionArgs = EventPermissionArgs(
        action = action,
        condition = condition,
        eventBusName = eventBusName,
        principal = principal,
        statementId = statementId,
    )
}
