@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudwatch.kotlin

import com.pulumi.aws.cloudwatch.EventRuleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an EventBridge Rule resource.
 * > **Note:** EventBridge was formerly known as CloudWatch Events. The functionality is identical.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const console = new aws.cloudwatch.EventRule("console", {
 *     name: "capture-aws-sign-in",
 *     description: "Capture each AWS Console Sign In",
 *     eventPattern: JSON.stringify({
 *         "detail-type": ["AWS Console Sign In via CloudTrail"],
 *     }),
 * });
 * const awsLogins = new aws.sns.Topic("aws_logins", {name: "aws-console-logins"});
 * const sns = new aws.cloudwatch.EventTarget("sns", {
 *     rule: console.name,
 *     targetId: "SendToSNS",
 *     arn: awsLogins.arn,
 * });
 * const snsTopicPolicy = awsLogins.arn.apply(arn => aws.iam.getPolicyDocumentOutput({
 *     statements: [{
 *         effect: "Allow",
 *         actions: ["SNS:Publish"],
 *         principals: [{
 *             type: "Service",
 *             identifiers: ["events&#46;amazonaws&#46;com"],
 *         }],
 *         resources: [arn],
 *     }],
 * }));
 * const _default = new aws.sns.TopicPolicy("default", {
 *     arn: awsLogins.arn,
 *     policy: snsTopicPolicy.apply(snsTopicPolicy => snsTopicPolicy.json),
 * });
 * ```
 * ```python
 * import pulumi
 * import json
 * import pulumi_aws as aws
 * console = aws.cloudwatch.EventRule("console",
 *     name="capture-aws-sign-in",
 *     description="Capture each AWS Console Sign In",
 *     event_pattern=json.dumps({
 *         "detail-type": ["AWS Console Sign In via CloudTrail"],
 *     }))
 * aws_logins = aws.sns.Topic("aws_logins", name="aws-console-logins")
 * sns = aws.cloudwatch.EventTarget("sns",
 *     rule=console.name,
 *     target_id="SendToSNS",
 *     arn=aws_logins.arn)
 * sns_topic_policy = aws_logins.arn.apply(lambda arn: aws.iam.get_policy_document_output(statements=[{
 *     "effect": "Allow",
 *     "actions": ["SNS:Publish"],
 *     "principals": [{
 *         "type": "Service",
 *         "identifiers": ["events&#46;amazonaws&#46;com"],
 *     }],
 *     "resources": [arn],
 * }]))
 * default = aws.sns.TopicPolicy("default",
 *     arn=aws_logins.arn,
 *     policy=sns_topic_policy.json)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using System.Text.Json;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var console = new Aws.CloudWatch.EventRule("console", new()
 *     {
 *         Name = "capture-aws-sign-in",
 *         Description = "Capture each AWS Console Sign In",
 *         EventPattern = JsonSerializer.Serialize(new Dictionary<string, object?>
 *         {
 *             ["detail-type"] = new[]
 *             {
 *                 "AWS Console Sign In via CloudTrail",
 *             },
 *         }),
 *     });
 *     var awsLogins = new Aws.Sns.Topic("aws_logins", new()
 *     {
 *         Name = "aws-console-logins",
 *     });
 *     var sns = new Aws.CloudWatch.EventTarget("sns", new()
 *     {
 *         Rule = console.Name,
 *         TargetId = "SendToSNS",
 *         Arn = awsLogins.Arn,
 *     });
 *     var snsTopicPolicy = Aws.Iam.GetPolicyDocument.Invoke(new()
 *     {
 *         Statements = new[]
 *         {
 *             new Aws.Iam.Inputs.GetPolicyDocumentStatementInputArgs
 *             {
 *                 Effect = "Allow",
 *                 Actions = new[]
 *                 {
 *                     "SNS:Publish",
 *                 },
 *                 Principals = new[]
 *                 {
 *                     new Aws.Iam.Inputs.GetPolicyDocumentStatementPrincipalInputArgs
 *                     {
 *                         Type = "Service",
 *                         Identifiers = new[]
 *                         {
 *                             "events.amazonaws.com",
 *                         },
 *                     },
 *                 },
 *                 Resources = new[]
 *                 {
 *                     awsLogins.Arn,
 *                 },
 *             },
 *         },
 *     });
 *     var @default = new Aws.Sns.TopicPolicy("default", new()
 *     {
 *         Arn = awsLogins.Arn,
 *         Policy = snsTopicPolicy.Apply(getPolicyDocumentResult => getPolicyDocumentResult.Json),
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"encoding/json"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cloudwatch"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/sns"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * tmpJSON0, err := json.Marshal(map[string]interface{}{
 * "detail-type": []string{
 * "AWS Console Sign In via CloudTrail",
 * },
 * })
 * if err != nil {
 * return err
 * }
 * json0 := string(tmpJSON0)
 * console, err := cloudwatch.NewEventRule(ctx, "console", &cloudwatch.EventRuleArgs{
 * Name: pulumi.String("capture-aws-sign-in"),
 * Description: pulumi.String("Capture each AWS Console Sign In"),
 * EventPattern: pulumi.String(json0),
 * })
 * if err != nil {
 * return err
 * }
 * awsLogins, err := sns.NewTopic(ctx, "aws_logins", &sns.TopicArgs{
 * Name: pulumi.String("aws-console-logins"),
 * })
 * if err != nil {
 * return err
 * }
 * _, err = cloudwatch.NewEventTarget(ctx, "sns", &cloudwatch.EventTargetArgs{
 * Rule: console.Name,
 * TargetId: pulumi.String("SendToSNS"),
 * Arn: awsLogins.Arn,
 * })
 * if err != nil {
 * return err
 * }
 * snsTopicPolicy := awsLogins.Arn.ApplyT(func(arn string) (iam.GetPolicyDocumentResult, error) {
 * return iam.GetPolicyDocumentResult(interface{}(iam.GetPolicyDocumentOutput(ctx, iam.GetPolicyDocumentOutputArgs{
 * Statements: []iam.GetPolicyDocumentStatement{
 * {
 * Effect: "Allow",
 * Actions: []string{
 * "SNS:Publish",
 * },
 * Principals: []iam.GetPolicyDocumentStatementPrincipal{
 * {
 * Type: "Service",
 * Identifiers: []string{
 * "events.amazonaws.com",
 * },
 * },
 * },
 * Resources: interface{}{
 * arn,
 * },
 * },
 * },
 * }, nil))), nil
 * }).(iam.GetPolicyDocumentResultOutput)
 * _, err = sns.NewTopicPolicy(ctx, "default", &sns.TopicPolicyArgs{
 * Arn: awsLogins.Arn,
 * Policy: pulumi.String(snsTopicPolicy.ApplyT(func(snsTopicPolicy iam.GetPolicyDocumentResult) (*string, error) {
 * return &snsTopicPolicy.Json, nil
 * }).(pulumi.StringPtrOutput)),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudwatch.EventRule;
 * import com.pulumi.aws.cloudwatch.EventRuleArgs;
 * import com.pulumi.aws.sns.Topic;
 * import com.pulumi.aws.sns.TopicArgs;
 * import com.pulumi.aws.cloudwatch.EventTarget;
 * import com.pulumi.aws.cloudwatch.EventTargetArgs;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.sns.TopicPolicy;
 * import com.pulumi.aws.sns.TopicPolicyArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var console = new EventRule("console", EventRuleArgs.builder()
 *             .name("capture-aws-sign-in")
 *             .description("Capture each AWS Console Sign In")
 *             .eventPattern(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("detail-type", jsonArray("AWS Console Sign In via CloudTrail"))
 *                 )))
 *             .build());
 *         var awsLogins = new Topic("awsLogins", TopicArgs.builder()
 *             .name("aws-console-logins")
 *             .build());
 *         var sns = new EventTarget("sns", EventTargetArgs.builder()
 *             .rule(console.name())
 *             .targetId("SendToSNS")
 *             .arn(awsLogins.arn())
 *             .build());
 *         final var snsTopicPolicy = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .actions("SNS:Publish")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("events.amazonaws.com")
 *                     .build())
 *                 .resources(awsLogins.arn())
 *                 .build())
 *             .build());
 *         var default_ = new TopicPolicy("default", TopicPolicyArgs.builder()
 *             .arn(awsLogins.arn())
 *             .policy(snsTopicPolicy.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult).applyValue(snsTopicPolicy -> snsTopicPolicy.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json())))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   console:
 *     type: aws:cloudwatch:EventRule
 *     properties:
 *       name: capture-aws-sign-in
 *       description: Capture each AWS Console Sign In
 *       eventPattern:
 *         fn::toJSON:
 *           detail-type:
 *             - AWS Console Sign In via CloudTrail
 *   sns:
 *     type: aws:cloudwatch:EventTarget
 *     properties:
 *       rule: ${console.name}
 *       targetId: SendToSNS
 *       arn: ${awsLogins.arn}
 *   awsLogins:
 *     type: aws:sns:Topic
 *     name: aws_logins
 *     properties:
 *       name: aws-console-logins
 *   default:
 *     type: aws:sns:TopicPolicy
 *     properties:
 *       arn: ${awsLogins.arn}
 *       policy: ${snsTopicPolicy.json}
 * variables:
 *   snsTopicPolicy:
 *     fn::invoke:
 *       Function: aws:iam:getPolicyDocument
 *       Arguments:
 *         statements:
 *           - effect: Allow
 *             actions:
 *               - SNS:Publish
 *             principals:
 *               - type: Service
 *                 identifiers:
 *                   - events.amazonaws.com
 *             resources:
 *               - ${awsLogins.arn}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import EventBridge Rules using the `event_bus_name/rule_name` (if you omit `event_bus_name`, the `default` event bus will be used). For example:
 * ```sh
 * $ pulumi import aws:cloudwatch/eventRule:EventRule console example-event-bus/capture-console-sign-in
 * ```
 * @property description The description of the rule.
 * @property eventBusName The name or ARN of the event bus to associate with this rule.
 * If you omit this, the `default` event bus is used.
 * @property eventPattern The event pattern described a JSON object. At least one of `schedule_expression` or `event_pattern` is required. See full documentation of [Events and Event Patterns in EventBridge](https://docs&#46;aws&#46;amazon&#46;com/eventbridge/latest/userguide/eventbridge-and-event-patterns&#46;html) for details&#46; **Note**: The event pattern size is 2048 by default but it is adjustable up to 4096 characters by submitting a service quota increase request&#46; See [Amazon EventBridge quotas](https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-quota.html) for details.
 * @property forceDestroy Used to delete managed rules created by AWS. Defaults to `false`.
 * @property isEnabled Whether the rule should be enabled.
 * Defaults to `true`.
 * Conflicts with `state`.
 * @property name The name of the rule. If omitted, this provider will assign a random, unique name. Conflicts with `name_prefix`.
 * @property namePrefix Creates a unique name beginning with the specified prefix. Conflicts with `name`. **Note**: Due to the length of the generated suffix, must be 38 characters or less.
 * @property roleArn The Amazon Resource Name (ARN) associated with the role that is used for target invocation.
 * @property scheduleExpression The scheduling expression. For example, `cron(0 20 * * ? *)` or `rate(5 minutes)`. At least one of `schedule_expression` or `event_pattern` is required. Can only be used on the default event bus. For more information, refer to the AWS documentation [Schedule Expressions for Rules](https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html).
 * @property state State of the rule.
 * Valid values are `DISABLED`, `ENABLED`, and `ENABLED_WITH_ALL_CLOUDTRAIL_MANAGEMENT_EVENTS`.
 * When state is `ENABLED`, the rule is enabled for all events except those delivered by CloudTrail.
 * To also enable the rule for events delivered by CloudTrail, set `state` to `ENABLED_WITH_ALL_CLOUDTRAIL_MANAGEMENT_EVENTS`.
 * Defaults to `ENABLED`.
 * Conflicts with `is_enabled`.
 * **NOTE:** The rule state  `ENABLED_WITH_ALL_CLOUDTRAIL_MANAGEMENT_EVENTS` cannot be used in conjunction with the `schedule_expression` argument.
 * @property tags A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class EventRuleArgs(
    public val description: Output<String>? = null,
    public val eventBusName: Output<String>? = null,
    public val eventPattern: Output<String>? = null,
    public val forceDestroy: Output<Boolean>? = null,
    @Deprecated(
        message = """
  Use "state" instead
  """,
    )
    public val isEnabled: Output<Boolean>? = null,
    public val name: Output<String>? = null,
    public val namePrefix: Output<String>? = null,
    public val roleArn: Output<String>? = null,
    public val scheduleExpression: Output<String>? = null,
    public val state: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.cloudwatch.EventRuleArgs> {
    override fun toJava(): com.pulumi.aws.cloudwatch.EventRuleArgs =
        com.pulumi.aws.cloudwatch.EventRuleArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .eventBusName(eventBusName?.applyValue({ args0 -> args0 }))
            .eventPattern(eventPattern?.applyValue({ args0 -> args0 }))
            .forceDestroy(forceDestroy?.applyValue({ args0 -> args0 }))
            .isEnabled(isEnabled?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .namePrefix(namePrefix?.applyValue({ args0 -> args0 }))
            .roleArn(roleArn?.applyValue({ args0 -> args0 }))
            .scheduleExpression(scheduleExpression?.applyValue({ args0 -> args0 }))
            .state(state?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [EventRuleArgs].
 */
@PulumiTagMarker
public class EventRuleArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var eventBusName: Output<String>? = null

    private var eventPattern: Output<String>? = null

    private var forceDestroy: Output<Boolean>? = null

    private var isEnabled: Output<Boolean>? = null

    private var name: Output<String>? = null

    private var namePrefix: Output<String>? = null

    private var roleArn: Output<String>? = null

    private var scheduleExpression: Output<String>? = null

    private var state: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The description of the rule.
     */
    @JvmName("ifliotscjekpsqax")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The name or ARN of the event bus to associate with this rule.
     * If you omit this, the `default` event bus is used.
     */
    @JvmName("jkbxwdiifvcvytqr")
    public suspend fun eventBusName(`value`: Output<String>) {
        this.eventBusName = value
    }

    /**
     * @param value The event pattern described a JSON object. At least one of `schedule_expression` or `event_pattern` is required. See full documentation of [Events and Event Patterns in EventBridge](https://docs&#46;aws&#46;amazon&#46;com/eventbridge/latest/userguide/eventbridge-and-event-patterns&#46;html) for details&#46; **Note**: The event pattern size is 2048 by default but it is adjustable up to 4096 characters by submitting a service quota increase request&#46; See [Amazon EventBridge quotas](https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-quota.html) for details.
     */
    @JvmName("yyhcfurmlmikbhgi")
    public suspend fun eventPattern(`value`: Output<String>) {
        this.eventPattern = value
    }

    /**
     * @param value Used to delete managed rules created by AWS. Defaults to `false`.
     */
    @JvmName("upkyfgkcmtglbndr")
    public suspend fun forceDestroy(`value`: Output<Boolean>) {
        this.forceDestroy = value
    }

    /**
     * @param value Whether the rule should be enabled.
     * Defaults to `true`.
     * Conflicts with `state`.
     */
    @Deprecated(
        message = """
  Use "state" instead
  """,
    )
    @JvmName("taxmlbscndipuiax")
    public suspend fun isEnabled(`value`: Output<Boolean>) {
        this.isEnabled = value
    }

    /**
     * @param value The name of the rule. If omitted, this provider will assign a random, unique name. Conflicts with `name_prefix`.
     */
    @JvmName("tnsgqywrdxcekkyv")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Creates a unique name beginning with the specified prefix. Conflicts with `name`. **Note**: Due to the length of the generated suffix, must be 38 characters or less.
     */
    @JvmName("kkriepxqfywipjqk")
    public suspend fun namePrefix(`value`: Output<String>) {
        this.namePrefix = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) associated with the role that is used for target invocation.
     */
    @JvmName("lrtqqfkcfsoeqabu")
    public suspend fun roleArn(`value`: Output<String>) {
        this.roleArn = value
    }

    /**
     * @param value The scheduling expression. For example, `cron(0 20 * * ? *)` or `rate(5 minutes)`. At least one of `schedule_expression` or `event_pattern` is required. Can only be used on the default event bus. For more information, refer to the AWS documentation [Schedule Expressions for Rules](https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html).
     */
    @JvmName("krysgftjkfsatwrw")
    public suspend fun scheduleExpression(`value`: Output<String>) {
        this.scheduleExpression = value
    }

    /**
     * @param value State of the rule.
     * Valid values are `DISABLED`, `ENABLED`, and `ENABLED_WITH_ALL_CLOUDTRAIL_MANAGEMENT_EVENTS`.
     * When state is `ENABLED`, the rule is enabled for all events except those delivered by CloudTrail.
     * To also enable the rule for events delivered by CloudTrail, set `state` to `ENABLED_WITH_ALL_CLOUDTRAIL_MANAGEMENT_EVENTS`.
     * Defaults to `ENABLED`.
     * Conflicts with `is_enabled`.
     * **NOTE:** The rule state  `ENABLED_WITH_ALL_CLOUDTRAIL_MANAGEMENT_EVENTS` cannot be used in conjunction with the `schedule_expression` argument.
     */
    @JvmName("sjeqdtqjvhgxtutn")
    public suspend fun state(`value`: Output<String>) {
        this.state = value
    }

    /**
     * @param value A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("qwtdnadyycjacxpa")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The description of the rule.
     */
    @JvmName("rxvananbwopdyook")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The name or ARN of the event bus to associate with this rule.
     * If you omit this, the `default` event bus is used.
     */
    @JvmName("nbnacxnylegtsmkw")
    public suspend fun eventBusName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eventBusName = mapped
    }

    /**
     * @param value The event pattern described a JSON object. At least one of `schedule_expression` or `event_pattern` is required. See full documentation of [Events and Event Patterns in EventBridge](https://docs&#46;aws&#46;amazon&#46;com/eventbridge/latest/userguide/eventbridge-and-event-patterns&#46;html) for details&#46; **Note**: The event pattern size is 2048 by default but it is adjustable up to 4096 characters by submitting a service quota increase request&#46; See [Amazon EventBridge quotas](https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-quota.html) for details.
     */
    @JvmName("wqdxuowuylymcwuj")
    public suspend fun eventPattern(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eventPattern = mapped
    }

    /**
     * @param value Used to delete managed rules created by AWS. Defaults to `false`.
     */
    @JvmName("ldnoqenhwnktjuai")
    public suspend fun forceDestroy(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.forceDestroy = mapped
    }

    /**
     * @param value Whether the rule should be enabled.
     * Defaults to `true`.
     * Conflicts with `state`.
     */
    @Deprecated(
        message = """
  Use "state" instead
  """,
    )
    @JvmName("mrykdahcyvwpkusx")
    public suspend fun isEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isEnabled = mapped
    }

    /**
     * @param value The name of the rule. If omitted, this provider will assign a random, unique name. Conflicts with `name_prefix`.
     */
    @JvmName("govjiwwbqsucgaae")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Creates a unique name beginning with the specified prefix. Conflicts with `name`. **Note**: Due to the length of the generated suffix, must be 38 characters or less.
     */
    @JvmName("udladnkbdgrabcfg")
    public suspend fun namePrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namePrefix = mapped
    }

    /**
     * @param value The Amazon Resource Name (ARN) associated with the role that is used for target invocation.
     */
    @JvmName("oouoswxirfqylebb")
    public suspend fun roleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roleArn = mapped
    }

    /**
     * @param value The scheduling expression. For example, `cron(0 20 * * ? *)` or `rate(5 minutes)`. At least one of `schedule_expression` or `event_pattern` is required. Can only be used on the default event bus. For more information, refer to the AWS documentation [Schedule Expressions for Rules](https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html).
     */
    @JvmName("ddibutlgsvnqnxij")
    public suspend fun scheduleExpression(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scheduleExpression = mapped
    }

    /**
     * @param value State of the rule.
     * Valid values are `DISABLED`, `ENABLED`, and `ENABLED_WITH_ALL_CLOUDTRAIL_MANAGEMENT_EVENTS`.
     * When state is `ENABLED`, the rule is enabled for all events except those delivered by CloudTrail.
     * To also enable the rule for events delivered by CloudTrail, set `state` to `ENABLED_WITH_ALL_CLOUDTRAIL_MANAGEMENT_EVENTS`.
     * Defaults to `ENABLED`.
     * Conflicts with `is_enabled`.
     * **NOTE:** The rule state  `ENABLED_WITH_ALL_CLOUDTRAIL_MANAGEMENT_EVENTS` cannot be used in conjunction with the `schedule_expression` argument.
     */
    @JvmName("njoaodfijiermbkb")
    public suspend fun state(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("pgajvjkouqekqxpn")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("xmaquarrdqfveons")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): EventRuleArgs = EventRuleArgs(
        description = description,
        eventBusName = eventBusName,
        eventPattern = eventPattern,
        forceDestroy = forceDestroy,
        isEnabled = isEnabled,
        name = name,
        namePrefix = namePrefix,
        roleArn = roleArn,
        scheduleExpression = scheduleExpression,
        state = state,
        tags = tags,
    )
}
