@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudwatch.kotlin

import com.pulumi.aws.cloudwatch.InternetMonitorArgs.builder
import com.pulumi.aws.cloudwatch.kotlin.inputs.InternetMonitorHealthEventsConfigArgs
import com.pulumi.aws.cloudwatch.kotlin.inputs.InternetMonitorHealthEventsConfigArgsBuilder
import com.pulumi.aws.cloudwatch.kotlin.inputs.InternetMonitorInternetMeasurementsLogDeliveryArgs
import com.pulumi.aws.cloudwatch.kotlin.inputs.InternetMonitorInternetMeasurementsLogDeliveryArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a Internet Monitor Monitor resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.cloudwatch.InternetMonitor("example", {monitorName: "exmple"});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.cloudwatch.InternetMonitor("example", monitor_name="exmple")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.CloudWatch.InternetMonitor("example", new()
 *     {
 *         MonitorName = "exmple",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cloudwatch"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cloudwatch.NewInternetMonitor(ctx, "example", &cloudwatch.InternetMonitorArgs{
 * 			MonitorName: pulumi.String("exmple"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudwatch.InternetMonitor;
 * import com.pulumi.aws.cloudwatch.InternetMonitorArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new InternetMonitor("example", InternetMonitorArgs.builder()
 *             .monitorName("exmple")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:cloudwatch:InternetMonitor
 *     properties:
 *       monitorName: exmple
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Internet Monitor Monitors using the `monitor_name`. For example:
 * ```sh
 * $ pulumi import aws:cloudwatch/internetMonitor:InternetMonitor some some-monitor
 * ```
 * @property healthEventsConfig Health event thresholds. A health event threshold percentage, for performance and availability, determines when Internet Monitor creates a health event when there's an internet issue that affects your application end users. See Health Events Config below.
 * @property internetMeasurementsLogDelivery Publish internet measurements for Internet Monitor to an Amazon S3 bucket in addition to CloudWatch Logs.
 * @property maxCityNetworksToMonitor The maximum number of city-networks to monitor for your resources. A city-network is the location (city) where clients access your application resources from and the network or ASN, such as an internet service provider (ISP), that clients access the resources through. This limit helps control billing costs.
 * @property monitorName The name of the monitor.
 * The following arguments are optional:
 * @property resources The resources to include in a monitor, which you provide as a set of Amazon Resource Names (ARNs).
 * @property status The status for a monitor. The accepted values for Status with the UpdateMonitor API call are the following: `ACTIVE` and `INACTIVE`.
 * @property tags Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property trafficPercentageToMonitor The percentage of the internet-facing traffic for your application that you want to monitor with this monitor.
 */
public data class InternetMonitorArgs(
    public val healthEventsConfig: Output<InternetMonitorHealthEventsConfigArgs>? = null,
    public val internetMeasurementsLogDelivery: Output<InternetMonitorInternetMeasurementsLogDeliveryArgs>? = null,
    public val maxCityNetworksToMonitor: Output<Int>? = null,
    public val monitorName: Output<String>? = null,
    public val resources: Output<List<String>>? = null,
    public val status: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val trafficPercentageToMonitor: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.aws.cloudwatch.InternetMonitorArgs> {
    override fun toJava(): com.pulumi.aws.cloudwatch.InternetMonitorArgs =
        com.pulumi.aws.cloudwatch.InternetMonitorArgs.builder()
            .healthEventsConfig(
                healthEventsConfig?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .internetMeasurementsLogDelivery(
                internetMeasurementsLogDelivery?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .maxCityNetworksToMonitor(maxCityNetworksToMonitor?.applyValue({ args0 -> args0 }))
            .monitorName(monitorName?.applyValue({ args0 -> args0 }))
            .resources(resources?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .status(status?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .trafficPercentageToMonitor(trafficPercentageToMonitor?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InternetMonitorArgs].
 */
@PulumiTagMarker
public class InternetMonitorArgsBuilder internal constructor() {
    private var healthEventsConfig: Output<InternetMonitorHealthEventsConfigArgs>? = null

    private var internetMeasurementsLogDelivery:
        Output<InternetMonitorInternetMeasurementsLogDeliveryArgs>? = null

    private var maxCityNetworksToMonitor: Output<Int>? = null

    private var monitorName: Output<String>? = null

    private var resources: Output<List<String>>? = null

    private var status: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var trafficPercentageToMonitor: Output<Int>? = null

    /**
     * @param value Health event thresholds. A health event threshold percentage, for performance and availability, determines when Internet Monitor creates a health event when there's an internet issue that affects your application end users. See Health Events Config below.
     */
    @JvmName("hmvprholvtjcplru")
    public suspend fun healthEventsConfig(`value`: Output<InternetMonitorHealthEventsConfigArgs>) {
        this.healthEventsConfig = value
    }

    /**
     * @param value Publish internet measurements for Internet Monitor to an Amazon S3 bucket in addition to CloudWatch Logs.
     */
    @JvmName("roftputbodmrcrcm")
    public suspend fun internetMeasurementsLogDelivery(`value`: Output<InternetMonitorInternetMeasurementsLogDeliveryArgs>) {
        this.internetMeasurementsLogDelivery = value
    }

    /**
     * @param value The maximum number of city-networks to monitor for your resources. A city-network is the location (city) where clients access your application resources from and the network or ASN, such as an internet service provider (ISP), that clients access the resources through. This limit helps control billing costs.
     */
    @JvmName("nryyvtmnuirhokvu")
    public suspend fun maxCityNetworksToMonitor(`value`: Output<Int>) {
        this.maxCityNetworksToMonitor = value
    }

    /**
     * @param value The name of the monitor.
     * The following arguments are optional:
     */
    @JvmName("ppwnahrypbpeypyj")
    public suspend fun monitorName(`value`: Output<String>) {
        this.monitorName = value
    }

    /**
     * @param value The resources to include in a monitor, which you provide as a set of Amazon Resource Names (ARNs).
     */
    @JvmName("hbpfewbiailkiabv")
    public suspend fun resources(`value`: Output<List<String>>) {
        this.resources = value
    }

    @JvmName("iaigvlhlxsbugayb")
    public suspend fun resources(vararg values: Output<String>) {
        this.resources = Output.all(values.asList())
    }

    /**
     * @param values The resources to include in a monitor, which you provide as a set of Amazon Resource Names (ARNs).
     */
    @JvmName("oacuhypfatrnkmjq")
    public suspend fun resources(values: List<Output<String>>) {
        this.resources = Output.all(values)
    }

    /**
     * @param value The status for a monitor. The accepted values for Status with the UpdateMonitor API call are the following: `ACTIVE` and `INACTIVE`.
     */
    @JvmName("ckhmidirsmkogrrr")
    public suspend fun status(`value`: Output<String>) {
        this.status = value
    }

    /**
     * @param value Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("xftxdjblyeykflur")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The percentage of the internet-facing traffic for your application that you want to monitor with this monitor.
     */
    @JvmName("dbgxmkvnyjbvomgd")
    public suspend fun trafficPercentageToMonitor(`value`: Output<Int>) {
        this.trafficPercentageToMonitor = value
    }

    /**
     * @param value Health event thresholds. A health event threshold percentage, for performance and availability, determines when Internet Monitor creates a health event when there's an internet issue that affects your application end users. See Health Events Config below.
     */
    @JvmName("lwerpdksmlmkpiix")
    public suspend fun healthEventsConfig(`value`: InternetMonitorHealthEventsConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.healthEventsConfig = mapped
    }

    /**
     * @param argument Health event thresholds. A health event threshold percentage, for performance and availability, determines when Internet Monitor creates a health event when there's an internet issue that affects your application end users. See Health Events Config below.
     */
    @JvmName("lxjkiivoyeqprolf")
    public suspend fun healthEventsConfig(argument: suspend InternetMonitorHealthEventsConfigArgsBuilder.() -> Unit) {
        val toBeMapped = InternetMonitorHealthEventsConfigArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.healthEventsConfig = mapped
    }

    /**
     * @param value Publish internet measurements for Internet Monitor to an Amazon S3 bucket in addition to CloudWatch Logs.
     */
    @JvmName("dcxvdwidchdcyvhm")
    public suspend fun internetMeasurementsLogDelivery(`value`: InternetMonitorInternetMeasurementsLogDeliveryArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.internetMeasurementsLogDelivery = mapped
    }

    /**
     * @param argument Publish internet measurements for Internet Monitor to an Amazon S3 bucket in addition to CloudWatch Logs.
     */
    @JvmName("moqdmusaqrdwupga")
    public suspend fun internetMeasurementsLogDelivery(argument: suspend InternetMonitorInternetMeasurementsLogDeliveryArgsBuilder.() -> Unit) {
        val toBeMapped = InternetMonitorInternetMeasurementsLogDeliveryArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.internetMeasurementsLogDelivery = mapped
    }

    /**
     * @param value The maximum number of city-networks to monitor for your resources. A city-network is the location (city) where clients access your application resources from and the network or ASN, such as an internet service provider (ISP), that clients access the resources through. This limit helps control billing costs.
     */
    @JvmName("lecqmgmkmaxmdnpo")
    public suspend fun maxCityNetworksToMonitor(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxCityNetworksToMonitor = mapped
    }

    /**
     * @param value The name of the monitor.
     * The following arguments are optional:
     */
    @JvmName("nxsmlmosibltykrj")
    public suspend fun monitorName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.monitorName = mapped
    }

    /**
     * @param value The resources to include in a monitor, which you provide as a set of Amazon Resource Names (ARNs).
     */
    @JvmName("byvlwfvvamqlmyuu")
    public suspend fun resources(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resources = mapped
    }

    /**
     * @param values The resources to include in a monitor, which you provide as a set of Amazon Resource Names (ARNs).
     */
    @JvmName("yvuqpwtmnejswevf")
    public suspend fun resources(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resources = mapped
    }

    /**
     * @param value The status for a monitor. The accepted values for Status with the UpdateMonitor API call are the following: `ACTIVE` and `INACTIVE`.
     */
    @JvmName("uscigkbeigwjbcwl")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("fvwowjovnovhkjaw")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("tambinaykrjjdleu")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The percentage of the internet-facing traffic for your application that you want to monitor with this monitor.
     */
    @JvmName("bbxjdmrkgafijldq")
    public suspend fun trafficPercentageToMonitor(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.trafficPercentageToMonitor = mapped
    }

    internal fun build(): InternetMonitorArgs = InternetMonitorArgs(
        healthEventsConfig = healthEventsConfig,
        internetMeasurementsLogDelivery = internetMeasurementsLogDelivery,
        maxCityNetworksToMonitor = maxCityNetworksToMonitor,
        monitorName = monitorName,
        resources = resources,
        status = status,
        tags = tags,
        trafficPercentageToMonitor = trafficPercentageToMonitor,
    )
}
