@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudwatch.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [LogAccountPolicy].
 */
@PulumiTagMarker
public class LogAccountPolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: LogAccountPolicyArgs = LogAccountPolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend LogAccountPolicyArgsBuilder.() -> Unit) {
        val builder = LogAccountPolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): LogAccountPolicy {
        val builtJavaResource = com.pulumi.aws.cloudwatch.LogAccountPolicy(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return LogAccountPolicy(builtJavaResource)
    }
}

/**
 * Provides a CloudWatch Log Account Policy resource.
 * ## Example Usage
 * ### Account Data Protection Policy
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const dataProtection = new aws.cloudwatch.LogAccountPolicy("data_protection", {
 *     policyName: "data-protection",
 *     policyType: "DATA_PROTECTION_POLICY",
 *     policyDocument: JSON.stringify({
 *         Name: "DataProtection",
 *         Version: "2021-06-01",
 *         Statement: [
 *             {
 *                 Sid: "Audit",
 *                 DataIdentifier: ["arn:aws:dataprotection::aws:data-identifier/EmailAddress"],
 *                 Operation: {
 *                     Audit: {
 *                         FindingsDestination: {},
 *                     },
 *                 },
 *             },
 *             {
 *                 Sid: "Redact",
 *                 DataIdentifier: ["arn:aws:dataprotection::aws:data-identifier/EmailAddress"],
 *                 Operation: {
 *                     Deidentify: {
 *                         MaskConfig: {},
 *                     },
 *                 },
 *             },
 *         ],
 *     }),
 * });
 * ```
 * ```python
 * import pulumi
 * import json
 * import pulumi_aws as aws
 * data_protection = aws.cloudwatch.LogAccountPolicy("data_protection",
 *     policy_name="data-protection",
 *     policy_type="DATA_PROTECTION_POLICY",
 *     policy_document=json.dumps({
 *         "Name": "DataProtection",
 *         "Version": "2021-06-01",
 *         "Statement": [
 *             {
 *                 "Sid": "Audit",
 *                 "DataIdentifier": ["arn:aws:dataprotection::aws:data-identifier/EmailAddress"],
 *                 "Operation": {
 *                     "Audit": {
 *                         "FindingsDestination": {},
 *                     },
 *                 },
 *             },
 *             {
 *                 "Sid": "Redact",
 *                 "DataIdentifier": ["arn:aws:dataprotection::aws:data-identifier/EmailAddress"],
 *                 "Operation": {
 *                     "Deidentify": {
 *                         "MaskConfig": {},
 *                     },
 *                 },
 *             },
 *         ],
 *     }))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using System.Text.Json;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var dataProtection = new Aws.CloudWatch.LogAccountPolicy("data_protection", new()
 *     {
 *         PolicyName = "data-protection",
 *         PolicyType = "DATA_PROTECTION_POLICY",
 *         PolicyDocument = JsonSerializer.Serialize(new Dictionary<string, object?>
 *         {
 *             ["Name"] = "DataProtection",
 *             ["Version"] = "2021-06-01",
 *             ["Statement"] = new[]
 *             {
 *                 new Dictionary<string, object?>
 *                 {
 *                     ["Sid"] = "Audit",
 *                     ["DataIdentifier"] = new[]
 *                     {
 *                         "arn:aws:dataprotection::aws:data-identifier/EmailAddress",
 *                     },
 *                     ["Operation"] = new Dictionary<string, object?>
 *                     {
 *                         ["Audit"] = new Dictionary<string, object?>
 *                         {
 *                             ["FindingsDestination"] = new Dictionary<string, object?>
 *                             {
 *                             },
 *                         },
 *                     },
 *                 },
 *                 new Dictionary<string, object?>
 *                 {
 *                     ["Sid"] = "Redact",
 *                     ["DataIdentifier"] = new[]
 *                     {
 *                         "arn:aws:dataprotection::aws:data-identifier/EmailAddress",
 *                     },
 *                     ["Operation"] = new Dictionary<string, object?>
 *                     {
 *                         ["Deidentify"] = new Dictionary<string, object?>
 *                         {
 *                             ["MaskConfig"] = new Dictionary<string, object?>
 *                             {
 *                             },
 *                         },
 *                     },
 *                 },
 *             },
 *         }),
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"encoding/json"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cloudwatch"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		tmpJSON0, err := json.Marshal(map[string]interface{}{
 * 			"Name":    "DataProtection",
 * 			"Version": "2021-06-01",
 * 			"Statement": []interface{}{
 * 				map[string]interface{}{
 * 					"Sid": "Audit",
 * 					"DataIdentifier": []string{
 * 						"arn:aws:dataprotection::aws:data-identifier/EmailAddress",
 * 					},
 * 					"Operation": map[string]interface{}{
 * 						"Audit": map[string]interface{}{
 * 							"FindingsDestination": nil,
 * 						},
 * 					},
 * 				},
 * 				map[string]interface{}{
 * 					"Sid": "Redact",
 * 					"DataIdentifier": []string{
 * 						"arn:aws:dataprotection::aws:data-identifier/EmailAddress",
 * 					},
 * 					"Operation": map[string]interface{}{
 * 						"Deidentify": map[string]interface{}{
 * 							"MaskConfig": nil,
 * 						},
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		json0 := string(tmpJSON0)
 * 		_, err = cloudwatch.NewLogAccountPolicy(ctx, "data_protection", &cloudwatch.LogAccountPolicyArgs{
 * 			PolicyName:     pulumi.String("data-protection"),
 * 			PolicyType:     pulumi.String("DATA_PROTECTION_POLICY"),
 * 			PolicyDocument: pulumi.String(json0),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudwatch.LogAccountPolicy;
 * import com.pulumi.aws.cloudwatch.LogAccountPolicyArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var dataProtection = new LogAccountPolicy("dataProtection", LogAccountPolicyArgs.builder()
 *             .policyName("data-protection")
 *             .policyType("DATA_PROTECTION_POLICY")
 *             .policyDocument(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("Name", "DataProtection"),
 *                     jsonProperty("Version", "2021-06-01"),
 *                     jsonProperty("Statement", jsonArray(
 *                         jsonObject(
 *                             jsonProperty("Sid", "Audit"),
 *                             jsonProperty("DataIdentifier", jsonArray("arn:aws:dataprotection::aws:data-identifier/EmailAddress")),
 *                             jsonProperty("Operation", jsonObject(
 *                                 jsonProperty("Audit", jsonObject(
 *                                     jsonProperty("FindingsDestination", jsonObject(
 *                                     ))
 *                                 ))
 *                             ))
 *                         ),
 *                         jsonObject(
 *                             jsonProperty("Sid", "Redact"),
 *                             jsonProperty("DataIdentifier", jsonArray("arn:aws:dataprotection::aws:data-identifier/EmailAddress")),
 *                             jsonProperty("Operation", jsonObject(
 *                                 jsonProperty("Deidentify", jsonObject(
 *                                     jsonProperty("MaskConfig", jsonObject(
 *                                     ))
 *                                 ))
 *                             ))
 *                         )
 *                     ))
 *                 )))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   dataProtection:
 *     type: aws:cloudwatch:LogAccountPolicy
 *     name: data_protection
 *     properties:
 *       policyName: data-protection
 *       policyType: DATA_PROTECTION_POLICY
 *       policyDocument:
 *         fn::toJSON:
 *           Name: DataProtection
 *           Version: 2021-06-01
 *           Statement:
 *             - Sid: Audit
 *               DataIdentifier:
 *                 - arn:aws:dataprotection::aws:data-identifier/EmailAddress
 *               Operation:
 *                 Audit:
 *                   FindingsDestination: {}
 *             - Sid: Redact
 *               DataIdentifier:
 *                 - arn:aws:dataprotection::aws:data-identifier/EmailAddress
 *               Operation:
 *                 Deidentify:
 *                   MaskConfig: {}
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Subscription Filter Policy
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const subscriptionFilter = new aws.cloudwatch.LogAccountPolicy("subscription_filter", {
 *     policyName: "subscription-filter",
 *     policyType: "SUBSCRIPTION_FILTER_POLICY",
 *     policyDocument: JSON.stringify({
 *         DestinationArn: test.arn,
 *         FilterPattern: "test",
 *     }),
 *     selectionCriteria: "LogGroupName NOT IN [\"excluded_log_group_name\"]",
 * });
 * ```
 * ```python
 * import pulumi
 * import json
 * import pulumi_aws as aws
 * subscription_filter = aws.cloudwatch.LogAccountPolicy("subscription_filter",
 *     policy_name="subscription-filter",
 *     policy_type="SUBSCRIPTION_FILTER_POLICY",
 *     policy_document=json.dumps({
 *         "DestinationArn": test["arn"],
 *         "FilterPattern": "test",
 *     }),
 *     selection_criteria="LogGroupName NOT IN [\"excluded_log_group_name\"]")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using System.Text.Json;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var subscriptionFilter = new Aws.CloudWatch.LogAccountPolicy("subscription_filter", new()
 *     {
 *         PolicyName = "subscription-filter",
 *         PolicyType = "SUBSCRIPTION_FILTER_POLICY",
 *         PolicyDocument = JsonSerializer.Serialize(new Dictionary<string, object?>
 *         {
 *             ["DestinationArn"] = test.Arn,
 *             ["FilterPattern"] = "test",
 *         }),
 *         SelectionCriteria = "LogGroupName NOT IN [\"excluded_log_group_name\"]",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"encoding/json"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cloudwatch"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		tmpJSON0, err := json.Marshal(map[string]interface{}{
 * 			"DestinationArn": test.Arn,
 * 			"FilterPattern":  "test",
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		json0 := string(tmpJSON0)
 * 		_, err = cloudwatch.NewLogAccountPolicy(ctx, "subscription_filter", &cloudwatch.LogAccountPolicyArgs{
 * 			PolicyName:        pulumi.String("subscription-filter"),
 * 			PolicyType:        pulumi.String("SUBSCRIPTION_FILTER_POLICY"),
 * 			PolicyDocument:    pulumi.String(json0),
 * 			SelectionCriteria: pulumi.String("LogGroupName NOT IN [\"excluded_log_group_name\"]"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudwatch.LogAccountPolicy;
 * import com.pulumi.aws.cloudwatch.LogAccountPolicyArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var subscriptionFilter = new LogAccountPolicy("subscriptionFilter", LogAccountPolicyArgs.builder()
 *             .policyName("subscription-filter")
 *             .policyType("SUBSCRIPTION_FILTER_POLICY")
 *             .policyDocument(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("DestinationArn", test.arn()),
 *                     jsonProperty("FilterPattern", "test")
 *                 )))
 *             .selectionCriteria("LogGroupName NOT IN [\"excluded_log_group_name\"]")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   subscriptionFilter:
 *     type: aws:cloudwatch:LogAccountPolicy
 *     name: subscription_filter
 *     properties:
 *       policyName: subscription-filter
 *       policyType: SUBSCRIPTION_FILTER_POLICY
 *       policyDocument:
 *         fn::toJSON:
 *           DestinationArn: ${test.arn}
 *           FilterPattern: test
 *       selectionCriteria: LogGroupName NOT IN ["excluded_log_group_name"]
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import this resource using the `policy_name` and `policy_type` separated by `:`. For example:
 * ```sh
 * $ pulumi import aws:cloudwatch/logAccountPolicy:LogAccountPolicy example "my-account-policy:SUBSCRIPTION_FILTER_POLICY"
 * ```
 */
public class LogAccountPolicy internal constructor(
    override val javaResource: com.pulumi.aws.cloudwatch.LogAccountPolicy,
) : KotlinCustomResource(javaResource, LogAccountPolicyMapper) {
    /**
     * Text of the account policy. Refer to the [AWS docs](https://docs.aws.amazon.com/cli/latest/reference/logs/put-account-policy.html) for more information.
     */
    public val policyDocument: Output<String>
        get() = javaResource.policyDocument().applyValue({ args0 -> args0 })

    /**
     * Name of the account policy.
     */
    public val policyName: Output<String>
        get() = javaResource.policyName().applyValue({ args0 -> args0 })

    /**
     * Type of account policy. Either `DATA_PROTECTION_POLICY` or `SUBSCRIPTION_FILTER_POLICY`. You can have one account policy per type in an account.
     */
    public val policyType: Output<String>
        get() = javaResource.policyType().applyValue({ args0 -> args0 })

    /**
     * Currently defaults to and only accepts the value: `ALL`.
     */
    public val scope: Output<String>?
        get() = javaResource.scope().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Criteria for applying a subscription filter policy to a selection of log groups. The only allowable criteria selector is `LogGroupName NOT IN []`.
     */
    public val selectionCriteria: Output<String>?
        get() = javaResource.selectionCriteria().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object LogAccountPolicyMapper : ResourceMapper<LogAccountPolicy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.cloudwatch.LogAccountPolicy::class == javaResource::class

    override fun map(javaResource: Resource): LogAccountPolicy = LogAccountPolicy(
        javaResource as
            com.pulumi.aws.cloudwatch.LogAccountPolicy,
    )
}

/**
 * @see [LogAccountPolicy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [LogAccountPolicy].
 */
public suspend fun logAccountPolicy(
    name: String,
    block: suspend LogAccountPolicyResourceBuilder.() -> Unit,
): LogAccountPolicy {
    val builder = LogAccountPolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [LogAccountPolicy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun logAccountPolicy(name: String): LogAccountPolicy {
    val builder = LogAccountPolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
