@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudwatch.kotlin

import com.pulumi.aws.cloudwatch.LogDataProtectionPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a CloudWatch Log Data Protection Policy resource.
 * Read more about protecting sensitive user data in the [User Guide](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/mask-sensitive-log-data.html).
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.cloudwatch.LogGroup("example", {name: "example"});
 * const exampleBucketV2 = new aws.s3.BucketV2("example", {bucket: "example"});
 * const exampleLogDataProtectionPolicy = new aws.cloudwatch.LogDataProtectionPolicy("example", {
 *     logGroupName: example.name,
 *     policyDocument: pulumi.jsonStringify({
 *         Name: "Example",
 *         Version: "2021-06-01",
 *         Statement: [
 *             {
 *                 Sid: "Audit",
 *                 DataIdentifier: ["arn:aws:dataprotection::aws:data-identifier/EmailAddress"],
 *                 Operation: {
 *                     Audit: {
 *                         FindingsDestination: {
 *                             S3: {
 *                                 Bucket: exampleBucketV2.bucket,
 *                             },
 *                         },
 *                     },
 *                 },
 *             },
 *             {
 *                 Sid: "Redact",
 *                 DataIdentifier: ["arn:aws:dataprotection::aws:data-identifier/EmailAddress"],
 *                 Operation: {
 *                     Deidentify: {
 *                         MaskConfig: {},
 *                     },
 *                 },
 *             },
 *         ],
 *     }),
 * });
 * ```
 * ```python
 * import pulumi
 * import json
 * import pulumi_aws as aws
 * example = aws.cloudwatch.LogGroup("example", name="example")
 * example_bucket_v2 = aws.s3.BucketV2("example", bucket="example")
 * example_log_data_protection_policy = aws.cloudwatch.LogDataProtectionPolicy("example",
 *     log_group_name=example.name,
 *     policy_document=pulumi.Output.json_dumps({
 *         "Name": "Example",
 *         "Version": "2021-06-01",
 *         "Statement": [
 *             {
 *                 "Sid": "Audit",
 *                 "DataIdentifier": ["arn:aws:dataprotection::aws:data-identifier/EmailAddress"],
 *                 "Operation": {
 *                     "Audit": {
 *                         "FindingsDestination": {
 *                             "S3": {
 *                                 "Bucket": example_bucket_v2.bucket,
 *                             },
 *                         },
 *                     },
 *                 },
 *             },
 *             {
 *                 "Sid": "Redact",
 *                 "DataIdentifier": ["arn:aws:dataprotection::aws:data-identifier/EmailAddress"],
 *                 "Operation": {
 *                     "Deidentify": {
 *                         "MaskConfig": {},
 *                     },
 *                 },
 *             },
 *         ],
 *     }))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using System.Text.Json;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.CloudWatch.LogGroup("example", new()
 *     {
 *         Name = "example",
 *     });
 *     var exampleBucketV2 = new Aws.S3.BucketV2("example", new()
 *     {
 *         Bucket = "example",
 *     });
 *     var exampleLogDataProtectionPolicy = new Aws.CloudWatch.LogDataProtectionPolicy("example", new()
 *     {
 *         LogGroupName = example.Name,
 *         PolicyDocument = Output.JsonSerialize(Output.Create(new Dictionary<string, object?>
 *         {
 *             ["Name"] = "Example",
 *             ["Version"] = "2021-06-01",
 *             ["Statement"] = new[]
 *             {
 *                 new Dictionary<string, object?>
 *                 {
 *                     ["Sid"] = "Audit",
 *                     ["DataIdentifier"] = new[]
 *                     {
 *                         "arn:aws:dataprotection::aws:data-identifier/EmailAddress",
 *                     },
 *                     ["Operation"] = new Dictionary<string, object?>
 *                     {
 *                         ["Audit"] = new Dictionary<string, object?>
 *                         {
 *                             ["FindingsDestination"] = new Dictionary<string, object?>
 *                             {
 *                                 ["S3"] = new Dictionary<string, object?>
 *                                 {
 *                                     ["Bucket"] = exampleBucketV2.Bucket,
 *                                 },
 *                             },
 *                         },
 *                     },
 *                 },
 *                 new Dictionary<string, object?>
 *                 {
 *                     ["Sid"] = "Redact",
 *                     ["DataIdentifier"] = new[]
 *                     {
 *                         "arn:aws:dataprotection::aws:data-identifier/EmailAddress",
 *                     },
 *                     ["Operation"] = new Dictionary<string, object?>
 *                     {
 *                         ["Deidentify"] = new Dictionary<string, object?>
 *                         {
 *                             ["MaskConfig"] = new Dictionary<string, object?>
 *                             {
 *                             },
 *                         },
 *                     },
 *                 },
 *             },
 *         })),
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"encoding/json"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cloudwatch"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/s3"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := cloudwatch.NewLogGroup(ctx, "example", &cloudwatch.LogGroupArgs{
 * 			Name: pulumi.String("example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleBucketV2, err := s3.NewBucketV2(ctx, "example", &s3.BucketV2Args{
 * 			Bucket: pulumi.String("example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = cloudwatch.NewLogDataProtectionPolicy(ctx, "example", &cloudwatch.LogDataProtectionPolicyArgs{
 * 			LogGroupName: example.Name,
 * 			PolicyDocument: exampleBucketV2.Bucket.ApplyT(func(bucket string) (pulumi.String, error) {
 * 				var _zero pulumi.String
 * 				tmpJSON0, err := json.Marshal(map[string]interface{}{
 * 					"Name":    "Example",
 * 					"Version": "2021-06-01",
 * 					"Statement": []interface{}{
 * 						map[string]interface{}{
 * 							"Sid": "Audit",
 * 							"DataIdentifier": []string{
 * 								"arn:aws:dataprotection::aws:data-identifier/EmailAddress",
 * 							},
 * 							"Operation": map[string]interface{}{
 * 								"Audit": map[string]interface{}{
 * 									"FindingsDestination": map[string]interface{}{
 * 										"S3": map[string]interface{}{
 * 											"Bucket": bucket,
 * 										},
 * 									},
 * 								},
 * 							},
 * 						},
 * 						map[string]interface{}{
 * 							"Sid": "Redact",
 * 							"DataIdentifier": []string{
 * 								"arn:aws:dataprotection::aws:data-identifier/EmailAddress",
 * 							},
 * 							"Operation": map[string]interface{}{
 * 								"Deidentify": map[string]interface{}{
 * 									"MaskConfig": nil,
 * 								},
 * 							},
 * 						},
 * 					},
 * 				})
 * 				if err != nil {
 * 					return _zero, err
 * 				}
 * 				json0 := string(tmpJSON0)
 * 				return pulumi.String(json0), nil
 * 			}).(pulumi.StringOutput),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudwatch.LogGroup;
 * import com.pulumi.aws.cloudwatch.LogGroupArgs;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.BucketV2Args;
 * import com.pulumi.aws.cloudwatch.LogDataProtectionPolicy;
 * import com.pulumi.aws.cloudwatch.LogDataProtectionPolicyArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new LogGroup("example", LogGroupArgs.builder()
 *             .name("example")
 *             .build());
 *         var exampleBucketV2 = new BucketV2("exampleBucketV2", BucketV2Args.builder()
 *             .bucket("example")
 *             .build());
 *         var exampleLogDataProtectionPolicy = new LogDataProtectionPolicy("exampleLogDataProtectionPolicy", LogDataProtectionPolicyArgs.builder()
 *             .logGroupName(example.name())
 *             .policyDocument(exampleBucketV2.bucket().applyValue(bucket -> serializeJson(
 *                 jsonObject(
 *                     jsonProperty("Name", "Example"),
 *                     jsonProperty("Version", "2021-06-01"),
 *                     jsonProperty("Statement", jsonArray(
 *                         jsonObject(
 *                             jsonProperty("Sid", "Audit"),
 *                             jsonProperty("DataIdentifier", jsonArray("arn:aws:dataprotection::aws:data-identifier/EmailAddress")),
 *                             jsonProperty("Operation", jsonObject(
 *                                 jsonProperty("Audit", jsonObject(
 *                                     jsonProperty("FindingsDestination", jsonObject(
 *                                         jsonProperty("S3", jsonObject(
 *                                             jsonProperty("Bucket", bucket)
 *                                         ))
 *                                     ))
 *                                 ))
 *                             ))
 *                         ),
 *                         jsonObject(
 *                             jsonProperty("Sid", "Redact"),
 *                             jsonProperty("DataIdentifier", jsonArray("arn:aws:dataprotection::aws:data-identifier/EmailAddress")),
 *                             jsonProperty("Operation", jsonObject(
 *                                 jsonProperty("Deidentify", jsonObject(
 *                                     jsonProperty("MaskConfig", jsonObject(
 *                                     ))
 *                                 ))
 *                             ))
 *                         )
 *                     ))
 *                 ))))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:cloudwatch:LogGroup
 *     properties:
 *       name: example
 *   exampleBucketV2:
 *     type: aws:s3:BucketV2
 *     name: example
 *     properties:
 *       bucket: example
 *   exampleLogDataProtectionPolicy:
 *     type: aws:cloudwatch:LogDataProtectionPolicy
 *     name: example
 *     properties:
 *       logGroupName: ${example.name}
 *       policyDocument:
 *         fn::toJSON:
 *           Name: Example
 *           Version: 2021-06-01
 *           Statement:
 *             - Sid: Audit
 *               DataIdentifier:
 *                 - arn:aws:dataprotection::aws:data-identifier/EmailAddress
 *               Operation:
 *                 Audit:
 *                   FindingsDestination:
 *                     S3:
 *                       Bucket: ${exampleBucketV2.bucket}
 *             - Sid: Redact
 *               DataIdentifier:
 *                 - arn:aws:dataprotection::aws:data-identifier/EmailAddress
 *               Operation:
 *                 Deidentify:
 *                   MaskConfig: {}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import this resource using the `log_group_name`. For example:
 * ```sh
 * $ pulumi import aws:cloudwatch/logDataProtectionPolicy:LogDataProtectionPolicy example my-log-group
 * ```
 * @property logGroupName The name of the log group under which the log stream is to be created.
 * @property policyDocument Specifies the data protection policy in JSON. Read more at [Data protection policy syntax](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/mask-sensitive-log-data-start.html#mask-sensitive-log-data-policysyntax).
 */
public data class LogDataProtectionPolicyArgs(
    public val logGroupName: Output<String>? = null,
    public val policyDocument: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.cloudwatch.LogDataProtectionPolicyArgs> {
    override fun toJava(): com.pulumi.aws.cloudwatch.LogDataProtectionPolicyArgs =
        com.pulumi.aws.cloudwatch.LogDataProtectionPolicyArgs.builder()
            .logGroupName(logGroupName?.applyValue({ args0 -> args0 }))
            .policyDocument(policyDocument?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LogDataProtectionPolicyArgs].
 */
@PulumiTagMarker
public class LogDataProtectionPolicyArgsBuilder internal constructor() {
    private var logGroupName: Output<String>? = null

    private var policyDocument: Output<String>? = null

    /**
     * @param value The name of the log group under which the log stream is to be created.
     */
    @JvmName("itflvkyicdsfthaf")
    public suspend fun logGroupName(`value`: Output<String>) {
        this.logGroupName = value
    }

    /**
     * @param value Specifies the data protection policy in JSON. Read more at [Data protection policy syntax](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/mask-sensitive-log-data-start.html#mask-sensitive-log-data-policysyntax).
     */
    @JvmName("ccmrffqkupidllap")
    public suspend fun policyDocument(`value`: Output<String>) {
        this.policyDocument = value
    }

    /**
     * @param value The name of the log group under which the log stream is to be created.
     */
    @JvmName("luemthdnigaslpbr")
    public suspend fun logGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logGroupName = mapped
    }

    /**
     * @param value Specifies the data protection policy in JSON. Read more at [Data protection policy syntax](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/mask-sensitive-log-data-start.html#mask-sensitive-log-data-policysyntax).
     */
    @JvmName("foymeblryimnbhgh")
    public suspend fun policyDocument(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyDocument = mapped
    }

    internal fun build(): LogDataProtectionPolicyArgs = LogDataProtectionPolicyArgs(
        logGroupName = logGroupName,
        policyDocument = policyDocument,
    )
}
