@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudwatch.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [LogDestination].
 */
@PulumiTagMarker
public class LogDestinationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: LogDestinationArgs = LogDestinationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend LogDestinationArgsBuilder.() -> Unit) {
        val builder = LogDestinationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): LogDestination {
        val builtJavaResource = com.pulumi.aws.cloudwatch.LogDestination(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return LogDestination(builtJavaResource)
    }
}

/**
 * Provides a CloudWatch Logs destination resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const testDestination = new aws.cloudwatch.LogDestination("test_destination", {
 *     name: "test_destination",
 *     roleArn: iamForCloudwatch.arn,
 *     targetArn: kinesisForCloudwatch.arn,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test_destination = aws.cloudwatch.LogDestination("test_destination",
 *     name="test_destination",
 *     role_arn=iam_for_cloudwatch["arn"],
 *     target_arn=kinesis_for_cloudwatch["arn"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var testDestination = new Aws.CloudWatch.LogDestination("test_destination", new()
 *     {
 *         Name = "test_destination",
 *         RoleArn = iamForCloudwatch.Arn,
 *         TargetArn = kinesisForCloudwatch.Arn,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cloudwatch"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cloudwatch.NewLogDestination(ctx, "test_destination", &cloudwatch.LogDestinationArgs{
 * 			Name:      pulumi.String("test_destination"),
 * 			RoleArn:   pulumi.Any(iamForCloudwatch.Arn),
 * 			TargetArn: pulumi.Any(kinesisForCloudwatch.Arn),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudwatch.LogDestination;
 * import com.pulumi.aws.cloudwatch.LogDestinationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var testDestination = new LogDestination("testDestination", LogDestinationArgs.builder()
 *             .name("test_destination")
 *             .roleArn(iamForCloudwatch.arn())
 *             .targetArn(kinesisForCloudwatch.arn())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   testDestination:
 *     type: aws:cloudwatch:LogDestination
 *     name: test_destination
 *     properties:
 *       name: test_destination
 *       roleArn: ${iamForCloudwatch.arn}
 *       targetArn: ${kinesisForCloudwatch.arn}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import CloudWatch Logs destinations using the `name`. For example:
 * ```sh
 * $ pulumi import aws:cloudwatch/logDestination:LogDestination test_destination test_destination
 * ```
 */
public class LogDestination internal constructor(
    override val javaResource: com.pulumi.aws.cloudwatch.LogDestination,
) : KotlinCustomResource(javaResource, LogDestinationMapper) {
    /**
     * The Amazon Resource Name (ARN) specifying the log destination.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * A name for the log destination.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The ARN of an IAM role that grants Amazon CloudWatch Logs permissions to put data into the target.
     */
    public val roleArn: Output<String>
        get() = javaResource.roleArn().applyValue({ args0 -> args0 })

    /**
     * A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * The ARN of the target Amazon Kinesis stream resource for the destination.
     */
    public val targetArn: Output<String>
        get() = javaResource.targetArn().applyValue({ args0 -> args0 })
}

public object LogDestinationMapper : ResourceMapper<LogDestination> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.cloudwatch.LogDestination::class == javaResource::class

    override fun map(javaResource: Resource): LogDestination = LogDestination(
        javaResource as
            com.pulumi.aws.cloudwatch.LogDestination,
    )
}

/**
 * @see [LogDestination].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [LogDestination].
 */
public suspend fun logDestination(
    name: String,
    block: suspend LogDestinationResourceBuilder.() -> Unit,
): LogDestination {
    val builder = LogDestinationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [LogDestination].
 * @param name The _unique_ name of the resulting resource.
 */
public fun logDestination(name: String): LogDestination {
    val builder = LogDestinationResourceBuilder()
    builder.name(name)
    return builder.build()
}
