@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudwatch.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [LogDestinationPolicy].
 */
@PulumiTagMarker
public class LogDestinationPolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: LogDestinationPolicyArgs = LogDestinationPolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend LogDestinationPolicyArgsBuilder.() -> Unit) {
        val builder = LogDestinationPolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): LogDestinationPolicy {
        val builtJavaResource = com.pulumi.aws.cloudwatch.LogDestinationPolicy(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return LogDestinationPolicy(builtJavaResource)
    }
}

/**
 * Provides a CloudWatch Logs destination policy resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const testDestination = new aws.cloudwatch.LogDestination("test_destination", {
 *     name: "test_destination",
 *     roleArn: iamForCloudwatch.arn,
 *     targetArn: kinesisForCloudwatch.arn,
 * });
 * const testDestinationPolicy = aws.iam.getPolicyDocumentOutput({
 *     statements: [{
 *         effect: "Allow",
 *         principals: [{
 *             type: "AWS",
 *             identifiers: ["123456789012"],
 *         }],
 *         actions: ["logs:PutSubscriptionFilter"],
 *         resources: [testDestination&#46;arn],
 *     }],
 * });
 * const testDestinationPolicyLogDestinationPolicy = new aws.cloudwatch.LogDestinationPolicy("test_destination_policy", {
 *     destinationName: testDestination.name,
 *     accessPolicy: testDestinationPolicy.apply(testDestinationPolicy => testDestinationPolicy.json),
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test_destination = aws.cloudwatch.LogDestination("test_destination",
 *     name="test_destination",
 *     role_arn=iam_for_cloudwatch["arn"],
 *     target_arn=kinesis_for_cloudwatch["arn"])
 * test_destination_policy = aws.iam.get_policy_document_output(statements=[{
 *     "effect": "Allow",
 *     "principals": [{
 *         "type": "AWS",
 *         "identifiers": ["123456789012"],
 *     }],
 *     "actions": ["logs:PutSubscriptionFilter"],
 *     "resources": [test_destination&#46;arn],
 * }])
 * test_destination_policy_log_destination_policy = aws.cloudwatch.LogDestinationPolicy("test_destination_policy",
 *     destination_name=test_destination.name,
 *     access_policy=test_destination_policy.json)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var testDestination = new Aws.CloudWatch.LogDestination("test_destination", new()
 *     {
 *         Name = "test_destination",
 *         RoleArn = iamForCloudwatch.Arn,
 *         TargetArn = kinesisForCloudwatch.Arn,
 *     });
 *     var testDestinationPolicy = Aws.Iam.GetPolicyDocument.Invoke(new()
 *     {
 *         Statements = new[]
 *         {
 *             new Aws.Iam.Inputs.GetPolicyDocumentStatementInputArgs
 *             {
 *                 Effect = "Allow",
 *                 Principals = new[]
 *                 {
 *                     new Aws.Iam.Inputs.GetPolicyDocumentStatementPrincipalInputArgs
 *                     {
 *                         Type = "AWS",
 *                         Identifiers = new[]
 *                         {
 *                             "123456789012",
 *                         },
 *                     },
 *                 },
 *                 Actions = new[]
 *                 {
 *                     "logs:PutSubscriptionFilter",
 *                 },
 *                 Resources = new[]
 *                 {
 *                     testDestination.Arn,
 *                 },
 *             },
 *         },
 *     });
 *     var testDestinationPolicyLogDestinationPolicy = new Aws.CloudWatch.LogDestinationPolicy("test_destination_policy", new()
 *     {
 *         DestinationName = testDestination.Name,
 *         AccessPolicy = testDestinationPolicy.Apply(getPolicyDocumentResult => getPolicyDocumentResult.Json),
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cloudwatch"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		testDestination, err := cloudwatch.NewLogDestination(ctx, "test_destination", &cloudwatch.LogDestinationArgs{
 * 			Name:      pulumi.String("test_destination"),
 * 			RoleArn:   pulumi.Any(iamForCloudwatch.Arn),
 * 			TargetArn: pulumi.Any(kinesisForCloudwatch.Arn),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		testDestinationPolicy := iam.GetPolicyDocumentOutput(ctx, iam.GetPolicyDocumentOutputArgs{
 * 			Statements: iam.GetPolicyDocumentStatementArray{
 * 				&iam.GetPolicyDocumentStatementArgs{
 * 					Effect: pulumi.String("Allow"),
 * 					Principals: iam.GetPolicyDocumentStatementPrincipalArray{
 * 						&iam.GetPolicyDocumentStatementPrincipalArgs{
 * 							Type: pulumi.String("AWS"),
 * 							Identifiers: pulumi.StringArray{
 * 								pulumi.String("123456789012"),
 * 							},
 * 						},
 * 					},
 * 					Actions: pulumi.StringArray{
 * 						pulumi.String("logs:PutSubscriptionFilter"),
 * 					},
 * 					Resources: pulumi.StringArray{
 * 						testDestination.Arn,
 * 					},
 * 				},
 * 			},
 * 		}, nil)
 * 		_, err = cloudwatch.NewLogDestinationPolicy(ctx, "test_destination_policy", &cloudwatch.LogDestinationPolicyArgs{
 * 			DestinationName: testDestination.Name,
 * 			AccessPolicy: pulumi.String(testDestinationPolicy.ApplyT(func(testDestinationPolicy iam.GetPolicyDocumentResult) (*string, error) {
 * 				return &testDestinationPolicy.Json, nil
 * 			}).(pulumi.StringPtrOutput)),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudwatch.LogDestination;
 * import com.pulumi.aws.cloudwatch.LogDestinationArgs;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.cloudwatch.LogDestinationPolicy;
 * import com.pulumi.aws.cloudwatch.LogDestinationPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var testDestination = new LogDestination("testDestination", LogDestinationArgs.builder()
 *             .name("test_destination")
 *             .roleArn(iamForCloudwatch.arn())
 *             .targetArn(kinesisForCloudwatch.arn())
 *             .build());
 *         final var testDestinationPolicy = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("AWS")
 *                     .identifiers("123456789012")
 *                     .build())
 *                 .actions("logs:PutSubscriptionFilter")
 *                 .resources(testDestination.arn())
 *                 .build())
 *             .build());
 *         var testDestinationPolicyLogDestinationPolicy = new LogDestinationPolicy("testDestinationPolicyLogDestinationPolicy", LogDestinationPolicyArgs.builder()
 *             .destinationName(testDestination.name())
 *             .accessPolicy(testDestinationPolicy.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult).applyValue(testDestinationPolicy -> testDestinationPolicy.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json())))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   testDestination:
 *     type: aws:cloudwatch:LogDestination
 *     name: test_destination
 *     properties:
 *       name: test_destination
 *       roleArn: ${iamForCloudwatch.arn}
 *       targetArn: ${kinesisForCloudwatch.arn}
 *   testDestinationPolicyLogDestinationPolicy:
 *     type: aws:cloudwatch:LogDestinationPolicy
 *     name: test_destination_policy
 *     properties:
 *       destinationName: ${testDestination.name}
 *       accessPolicy: ${testDestinationPolicy.json}
 * variables:
 *   testDestinationPolicy:
 *     fn::invoke:
 *       Function: aws:iam:getPolicyDocument
 *       Arguments:
 *         statements:
 *           - effect: Allow
 *             principals:
 *               - type: AWS
 *                 identifiers:
 *                   - '123456789012'
 *             actions:
 *               - logs:PutSubscriptionFilter
 *             resources:
 *               - ${testDestination.arn}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import CloudWatch Logs destination policies using the `destination_name`. For example:
 * ```sh
 * $ pulumi import aws:cloudwatch/logDestinationPolicy:LogDestinationPolicy test_destination_policy test_destination
 * ```
 */
public class LogDestinationPolicy internal constructor(
    override val javaResource: com.pulumi.aws.cloudwatch.LogDestinationPolicy,
) : KotlinCustomResource(javaResource, LogDestinationPolicyMapper) {
    /**
     * The policy document. This is a JSON formatted string.
     */
    public val accessPolicy: Output<String>
        get() = javaResource.accessPolicy().applyValue({ args0 -> args0 })

    /**
     * A name for the subscription filter
     */
    public val destinationName: Output<String>
        get() = javaResource.destinationName().applyValue({ args0 -> args0 })

    /**
     * Specify true if you are updating an existing destination policy to grant permission to an organization ID instead of granting permission to individual AWS accounts.
     */
    public val forceUpdate: Output<Boolean>?
        get() = javaResource.forceUpdate().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object LogDestinationPolicyMapper : ResourceMapper<LogDestinationPolicy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.cloudwatch.LogDestinationPolicy::class == javaResource::class

    override fun map(javaResource: Resource): LogDestinationPolicy = LogDestinationPolicy(
        javaResource
            as com.pulumi.aws.cloudwatch.LogDestinationPolicy,
    )
}

/**
 * @see [LogDestinationPolicy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [LogDestinationPolicy].
 */
public suspend fun logDestinationPolicy(
    name: String,
    block: suspend LogDestinationPolicyResourceBuilder.() -> Unit,
): LogDestinationPolicy {
    val builder = LogDestinationPolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [LogDestinationPolicy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun logDestinationPolicy(name: String): LogDestinationPolicy {
    val builder = LogDestinationPolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
