@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudwatch.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [LogGroup].
 */
@PulumiTagMarker
public class LogGroupResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: LogGroupArgs = LogGroupArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend LogGroupArgsBuilder.() -> Unit) {
        val builder = LogGroupArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): LogGroup {
        val builtJavaResource = com.pulumi.aws.cloudwatch.LogGroup(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return LogGroup(builtJavaResource)
    }
}

/**
 * Provides a CloudWatch Log Group resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const yada = new aws.cloudwatch.LogGroup("yada", {
 *     name: "Yada",
 *     tags: {
 *         Environment: "production",
 *         Application: "serviceA",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * yada = aws.cloudwatch.LogGroup("yada",
 *     name="Yada",
 *     tags={
 *         "Environment": "production",
 *         "Application": "serviceA",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var yada = new Aws.CloudWatch.LogGroup("yada", new()
 *     {
 *         Name = "Yada",
 *         Tags =
 *         {
 *             { "Environment", "production" },
 *             { "Application", "serviceA" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cloudwatch"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cloudwatch.NewLogGroup(ctx, "yada", &cloudwatch.LogGroupArgs{
 * 			Name: pulumi.String("Yada"),
 * 			Tags: pulumi.StringMap{
 * 				"Environment": pulumi.String("production"),
 * 				"Application": pulumi.String("serviceA"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudwatch.LogGroup;
 * import com.pulumi.aws.cloudwatch.LogGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var yada = new LogGroup("yada", LogGroupArgs.builder()
 *             .name("Yada")
 *             .tags(Map.ofEntries(
 *                 Map.entry("Environment", "production"),
 *                 Map.entry("Application", "serviceA")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   yada:
 *     type: aws:cloudwatch:LogGroup
 *     properties:
 *       name: Yada
 *       tags:
 *         Environment: production
 *         Application: serviceA
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Cloudwatch Log Groups using the `name`. For example:
 * ```sh
 * $ pulumi import aws:cloudwatch/logGroup:LogGroup test_group yada
 * ```
 */
public class LogGroup internal constructor(
    override val javaResource: com.pulumi.aws.cloudwatch.LogGroup,
) : KotlinCustomResource(javaResource, LogGroupMapper) {
    /**
     * The Amazon Resource Name (ARN) specifying the log group. Any `:*` suffix added by the API, denoting all CloudWatch Log Streams under the CloudWatch Log Group, is removed for greater compatibility with other AWS services that do not accept the suffix.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The ARN of the KMS Key to use when encrypting log data. Please note, after the AWS KMS CMK is disassociated from the log group,
     * AWS CloudWatch Logs stops encrypting newly ingested data for the log group. All previously ingested data remains encrypted, and AWS CloudWatch Logs requires
     * permissions for the CMK whenever the encrypted data is requested.
     */
    public val kmsKeyId: Output<String>?
        get() = javaResource.kmsKeyId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Specified the log class of the log group. Possible values are: `STANDARD` or `INFREQUENT_ACCESS`.
     */
    public val logGroupClass: Output<String>
        get() = javaResource.logGroupClass().applyValue({ args0 -> args0 })

    /**
     * The name of the log group. If omitted, this provider will assign a random, unique name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Creates a unique name beginning with the specified prefix. Conflicts with `name`.
     */
    public val namePrefix: Output<String>
        get() = javaResource.namePrefix().applyValue({ args0 -> args0 })

    /**
     * Specifies the number of days
     * you want to retain log events in the specified log group.  Possible values are: 1, 3, 5, 7, 14, 30, 60, 90, 120, 150, 180, 365, 400, 545, 731, 1096, 1827, 2192, 2557, 2922, 3288, 3653, and 0.
     * If you select 0, the events in the log group are always retained and never expire.
     */
    public val retentionInDays: Output<Int>?
        get() = javaResource.retentionInDays().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Set to true if you do not wish the log group (and any logs it may contain) to be deleted at destroy time, and instead just remove the log group from the state.
     */
    public val skipDestroy: Output<Boolean>?
        get() = javaResource.skipDestroy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object LogGroupMapper : ResourceMapper<LogGroup> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.cloudwatch.LogGroup::class == javaResource::class

    override fun map(javaResource: Resource): LogGroup = LogGroup(
        javaResource as
            com.pulumi.aws.cloudwatch.LogGroup,
    )
}

/**
 * @see [LogGroup].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [LogGroup].
 */
public suspend fun logGroup(name: String, block: suspend LogGroupResourceBuilder.() -> Unit): LogGroup {
    val builder = LogGroupResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [LogGroup].
 * @param name The _unique_ name of the resulting resource.
 */
public fun logGroup(name: String): LogGroup {
    val builder = LogGroupResourceBuilder()
    builder.name(name)
    return builder.build()
}
