@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudwatch.kotlin

import com.pulumi.aws.cloudwatch.LogGroupArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a CloudWatch Log Group resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const yada = new aws.cloudwatch.LogGroup("yada", {
 *     name: "Yada",
 *     tags: {
 *         Environment: "production",
 *         Application: "serviceA",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * yada = aws.cloudwatch.LogGroup("yada",
 *     name="Yada",
 *     tags={
 *         "Environment": "production",
 *         "Application": "serviceA",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var yada = new Aws.CloudWatch.LogGroup("yada", new()
 *     {
 *         Name = "Yada",
 *         Tags =
 *         {
 *             { "Environment", "production" },
 *             { "Application", "serviceA" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cloudwatch"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cloudwatch.NewLogGroup(ctx, "yada", &cloudwatch.LogGroupArgs{
 * 			Name: pulumi.String("Yada"),
 * 			Tags: pulumi.StringMap{
 * 				"Environment": pulumi.String("production"),
 * 				"Application": pulumi.String("serviceA"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudwatch.LogGroup;
 * import com.pulumi.aws.cloudwatch.LogGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var yada = new LogGroup("yada", LogGroupArgs.builder()
 *             .name("Yada")
 *             .tags(Map.ofEntries(
 *                 Map.entry("Environment", "production"),
 *                 Map.entry("Application", "serviceA")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   yada:
 *     type: aws:cloudwatch:LogGroup
 *     properties:
 *       name: Yada
 *       tags:
 *         Environment: production
 *         Application: serviceA
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Cloudwatch Log Groups using the `name`. For example:
 * ```sh
 * $ pulumi import aws:cloudwatch/logGroup:LogGroup test_group yada
 * ```
 * @property kmsKeyId The ARN of the KMS Key to use when encrypting log data. Please note, after the AWS KMS CMK is disassociated from the log group,
 * AWS CloudWatch Logs stops encrypting newly ingested data for the log group. All previously ingested data remains encrypted, and AWS CloudWatch Logs requires
 * permissions for the CMK whenever the encrypted data is requested.
 * @property logGroupClass Specified the log class of the log group. Possible values are: `STANDARD` or `INFREQUENT_ACCESS`.
 * @property name The name of the log group. If omitted, this provider will assign a random, unique name.
 * @property namePrefix Creates a unique name beginning with the specified prefix. Conflicts with `name`.
 * @property retentionInDays Specifies the number of days
 * you want to retain log events in the specified log group.  Possible values are: 1, 3, 5, 7, 14, 30, 60, 90, 120, 150, 180, 365, 400, 545, 731, 1096, 1827, 2192, 2557, 2922, 3288, 3653, and 0.
 * If you select 0, the events in the log group are always retained and never expire.
 * @property skipDestroy Set to true if you do not wish the log group (and any logs it may contain) to be deleted at destroy time, and instead just remove the log group from the state.
 * @property tags A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class LogGroupArgs(
    public val kmsKeyId: Output<String>? = null,
    public val logGroupClass: Output<String>? = null,
    public val name: Output<String>? = null,
    public val namePrefix: Output<String>? = null,
    public val retentionInDays: Output<Int>? = null,
    public val skipDestroy: Output<Boolean>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.cloudwatch.LogGroupArgs> {
    override fun toJava(): com.pulumi.aws.cloudwatch.LogGroupArgs =
        com.pulumi.aws.cloudwatch.LogGroupArgs.builder()
            .kmsKeyId(kmsKeyId?.applyValue({ args0 -> args0 }))
            .logGroupClass(logGroupClass?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .namePrefix(namePrefix?.applyValue({ args0 -> args0 }))
            .retentionInDays(retentionInDays?.applyValue({ args0 -> args0 }))
            .skipDestroy(skipDestroy?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [LogGroupArgs].
 */
@PulumiTagMarker
public class LogGroupArgsBuilder internal constructor() {
    private var kmsKeyId: Output<String>? = null

    private var logGroupClass: Output<String>? = null

    private var name: Output<String>? = null

    private var namePrefix: Output<String>? = null

    private var retentionInDays: Output<Int>? = null

    private var skipDestroy: Output<Boolean>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The ARN of the KMS Key to use when encrypting log data. Please note, after the AWS KMS CMK is disassociated from the log group,
     * AWS CloudWatch Logs stops encrypting newly ingested data for the log group. All previously ingested data remains encrypted, and AWS CloudWatch Logs requires
     * permissions for the CMK whenever the encrypted data is requested.
     */
    @JvmName("ionxmkcadyivjwbq")
    public suspend fun kmsKeyId(`value`: Output<String>) {
        this.kmsKeyId = value
    }

    /**
     * @param value Specified the log class of the log group. Possible values are: `STANDARD` or `INFREQUENT_ACCESS`.
     */
    @JvmName("psmknqxnpovsqmek")
    public suspend fun logGroupClass(`value`: Output<String>) {
        this.logGroupClass = value
    }

    /**
     * @param value The name of the log group. If omitted, this provider will assign a random, unique name.
     */
    @JvmName("guabcfeoiernqxym")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Creates a unique name beginning with the specified prefix. Conflicts with `name`.
     */
    @JvmName("buqvrsigdffoapjb")
    public suspend fun namePrefix(`value`: Output<String>) {
        this.namePrefix = value
    }

    /**
     * @param value Specifies the number of days
     * you want to retain log events in the specified log group.  Possible values are: 1, 3, 5, 7, 14, 30, 60, 90, 120, 150, 180, 365, 400, 545, 731, 1096, 1827, 2192, 2557, 2922, 3288, 3653, and 0.
     * If you select 0, the events in the log group are always retained and never expire.
     */
    @JvmName("grdgwwmmxgmeuxjd")
    public suspend fun retentionInDays(`value`: Output<Int>) {
        this.retentionInDays = value
    }

    /**
     * @param value Set to true if you do not wish the log group (and any logs it may contain) to be deleted at destroy time, and instead just remove the log group from the state.
     */
    @JvmName("ygeifhobacrvfjbh")
    public suspend fun skipDestroy(`value`: Output<Boolean>) {
        this.skipDestroy = value
    }

    /**
     * @param value A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("eqsouagwvgtvwljx")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The ARN of the KMS Key to use when encrypting log data. Please note, after the AWS KMS CMK is disassociated from the log group,
     * AWS CloudWatch Logs stops encrypting newly ingested data for the log group. All previously ingested data remains encrypted, and AWS CloudWatch Logs requires
     * permissions for the CMK whenever the encrypted data is requested.
     */
    @JvmName("yliojaekwauilecs")
    public suspend fun kmsKeyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsKeyId = mapped
    }

    /**
     * @param value Specified the log class of the log group. Possible values are: `STANDARD` or `INFREQUENT_ACCESS`.
     */
    @JvmName("hsvawrjnutneynvs")
    public suspend fun logGroupClass(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logGroupClass = mapped
    }

    /**
     * @param value The name of the log group. If omitted, this provider will assign a random, unique name.
     */
    @JvmName("gxtnyhbqypgobqym")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Creates a unique name beginning with the specified prefix. Conflicts with `name`.
     */
    @JvmName("xbqjdqqkcyiwdwis")
    public suspend fun namePrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namePrefix = mapped
    }

    /**
     * @param value Specifies the number of days
     * you want to retain log events in the specified log group.  Possible values are: 1, 3, 5, 7, 14, 30, 60, 90, 120, 150, 180, 365, 400, 545, 731, 1096, 1827, 2192, 2557, 2922, 3288, 3653, and 0.
     * If you select 0, the events in the log group are always retained and never expire.
     */
    @JvmName("urxhmdghniwxwblk")
    public suspend fun retentionInDays(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.retentionInDays = mapped
    }

    /**
     * @param value Set to true if you do not wish the log group (and any logs it may contain) to be deleted at destroy time, and instead just remove the log group from the state.
     */
    @JvmName("rpjupufmxbeocumq")
    public suspend fun skipDestroy(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.skipDestroy = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("vntjdjwnekswfxie")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ggiwbxhbvpljrdqo")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): LogGroupArgs = LogGroupArgs(
        kmsKeyId = kmsKeyId,
        logGroupClass = logGroupClass,
        name = name,
        namePrefix = namePrefix,
        retentionInDays = retentionInDays,
        skipDestroy = skipDestroy,
        tags = tags,
    )
}
