@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudwatch.kotlin

import com.pulumi.aws.cloudwatch.kotlin.outputs.LogMetricFilterMetricTransformation
import com.pulumi.aws.cloudwatch.kotlin.outputs.LogMetricFilterMetricTransformation.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [LogMetricFilter].
 */
@PulumiTagMarker
public class LogMetricFilterResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: LogMetricFilterArgs = LogMetricFilterArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend LogMetricFilterArgsBuilder.() -> Unit) {
        val builder = LogMetricFilterArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): LogMetricFilter {
        val builtJavaResource = com.pulumi.aws.cloudwatch.LogMetricFilter(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return LogMetricFilter(builtJavaResource)
    }
}

/**
 * Provides a CloudWatch Log Metric Filter resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const dada = new aws.cloudwatch.LogGroup("dada", {name: "MyApp/access.log"});
 * const yada = new aws.cloudwatch.LogMetricFilter("yada", {
 *     name: "MyAppAccessCount",
 *     pattern: "",
 *     logGroupName: dada.name,
 *     metricTransformation: {
 *         name: "EventCount",
 *         namespace: "YourNamespace",
 *         value: "1",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * dada = aws.cloudwatch.LogGroup("dada", name="MyApp/access.log")
 * yada = aws.cloudwatch.LogMetricFilter("yada",
 *     name="MyAppAccessCount",
 *     pattern="",
 *     log_group_name=dada.name,
 *     metric_transformation={
 *         "name": "EventCount",
 *         "namespace": "YourNamespace",
 *         "value": "1",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var dada = new Aws.CloudWatch.LogGroup("dada", new()
 *     {
 *         Name = "MyApp/access.log",
 *     });
 *     var yada = new Aws.CloudWatch.LogMetricFilter("yada", new()
 *     {
 *         Name = "MyAppAccessCount",
 *         Pattern = "",
 *         LogGroupName = dada.Name,
 *         MetricTransformation = new Aws.CloudWatch.Inputs.LogMetricFilterMetricTransformationArgs
 *         {
 *             Name = "EventCount",
 *             Namespace = "YourNamespace",
 *             Value = "1",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cloudwatch"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		dada, err := cloudwatch.NewLogGroup(ctx, "dada", &cloudwatch.LogGroupArgs{
 * 			Name: pulumi.String("MyApp/access.log"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = cloudwatch.NewLogMetricFilter(ctx, "yada", &cloudwatch.LogMetricFilterArgs{
 * 			Name:         pulumi.String("MyAppAccessCount"),
 * 			Pattern:      pulumi.String(""),
 * 			LogGroupName: dada.Name,
 * 			MetricTransformation: &cloudwatch.LogMetricFilterMetricTransformationArgs{
 * 				Name:      pulumi.String("EventCount"),
 * 				Namespace: pulumi.String("YourNamespace"),
 * 				Value:     pulumi.String("1"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudwatch.LogGroup;
 * import com.pulumi.aws.cloudwatch.LogGroupArgs;
 * import com.pulumi.aws.cloudwatch.LogMetricFilter;
 * import com.pulumi.aws.cloudwatch.LogMetricFilterArgs;
 * import com.pulumi.aws.cloudwatch.inputs.LogMetricFilterMetricTransformationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var dada = new LogGroup("dada", LogGroupArgs.builder()
 *             .name("MyApp/access.log")
 *             .build());
 *         var yada = new LogMetricFilter("yada", LogMetricFilterArgs.builder()
 *             .name("MyAppAccessCount")
 *             .pattern("")
 *             .logGroupName(dada.name())
 *             .metricTransformation(LogMetricFilterMetricTransformationArgs.builder()
 *                 .name("EventCount")
 *                 .namespace("YourNamespace")
 *                 .value("1")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   yada:
 *     type: aws:cloudwatch:LogMetricFilter
 *     properties:
 *       name: MyAppAccessCount
 *       pattern:
 *       logGroupName: ${dada.name}
 *       metricTransformation:
 *         name: EventCount
 *         namespace: YourNamespace
 *         value: '1'
 *   dada:
 *     type: aws:cloudwatch:LogGroup
 *     properties:
 *       name: MyApp/access.log
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import CloudWatch Log Metric Filter using the `log_group_name:name`. For example:
 * ```sh
 * $ pulumi import aws:cloudwatch/logMetricFilter:LogMetricFilter test /aws/lambda/function:test
 * ```
 */
public class LogMetricFilter internal constructor(
    override val javaResource: com.pulumi.aws.cloudwatch.LogMetricFilter,
) : KotlinCustomResource(javaResource, LogMetricFilterMapper) {
    /**
     * The name of the log group to associate the metric filter with.
     */
    public val logGroupName: Output<String>
        get() = javaResource.logGroupName().applyValue({ args0 -> args0 })

    /**
     * A block defining collection of information needed to define how metric data gets emitted. See below.
     */
    public val metricTransformation: Output<LogMetricFilterMetricTransformation>
        get() = javaResource.metricTransformation().applyValue({ args0 ->
            args0.let({ args0 ->
                toKotlin(args0)
            })
        })

    /**
     * A name for the metric filter.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * A valid [CloudWatch Logs filter pattern](https://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/FilterAndPatternSyntax.html)
     * for extracting metric data out of ingested log events.
     */
    public val pattern: Output<String>
        get() = javaResource.pattern().applyValue({ args0 -> args0 })
}

public object LogMetricFilterMapper : ResourceMapper<LogMetricFilter> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.cloudwatch.LogMetricFilter::class == javaResource::class

    override fun map(javaResource: Resource): LogMetricFilter = LogMetricFilter(
        javaResource as
            com.pulumi.aws.cloudwatch.LogMetricFilter,
    )
}

/**
 * @see [LogMetricFilter].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [LogMetricFilter].
 */
public suspend fun logMetricFilter(
    name: String,
    block: suspend LogMetricFilterResourceBuilder.() -> Unit,
): LogMetricFilter {
    val builder = LogMetricFilterResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [LogMetricFilter].
 * @param name The _unique_ name of the resulting resource.
 */
public fun logMetricFilter(name: String): LogMetricFilter {
    val builder = LogMetricFilterResourceBuilder()
    builder.name(name)
    return builder.build()
}
