@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudwatch.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [LogStream].
 */
@PulumiTagMarker
public class LogStreamResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: LogStreamArgs = LogStreamArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend LogStreamArgsBuilder.() -> Unit) {
        val builder = LogStreamArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): LogStream {
        val builtJavaResource = com.pulumi.aws.cloudwatch.LogStream(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return LogStream(builtJavaResource)
    }
}

/**
 * Provides a CloudWatch Log Stream resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const yada = new aws.cloudwatch.LogGroup("yada", {name: "Yada"});
 * const foo = new aws.cloudwatch.LogStream("foo", {
 *     name: "SampleLogStream1234",
 *     logGroupName: yada.name,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * yada = aws.cloudwatch.LogGroup("yada", name="Yada")
 * foo = aws.cloudwatch.LogStream("foo",
 *     name="SampleLogStream1234",
 *     log_group_name=yada.name)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var yada = new Aws.CloudWatch.LogGroup("yada", new()
 *     {
 *         Name = "Yada",
 *     });
 *     var foo = new Aws.CloudWatch.LogStream("foo", new()
 *     {
 *         Name = "SampleLogStream1234",
 *         LogGroupName = yada.Name,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cloudwatch"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		yada, err := cloudwatch.NewLogGroup(ctx, "yada", &cloudwatch.LogGroupArgs{
 * 			Name: pulumi.String("Yada"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = cloudwatch.NewLogStream(ctx, "foo", &cloudwatch.LogStreamArgs{
 * 			Name:         pulumi.String("SampleLogStream1234"),
 * 			LogGroupName: yada.Name,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudwatch.LogGroup;
 * import com.pulumi.aws.cloudwatch.LogGroupArgs;
 * import com.pulumi.aws.cloudwatch.LogStream;
 * import com.pulumi.aws.cloudwatch.LogStreamArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var yada = new LogGroup("yada", LogGroupArgs.builder()
 *             .name("Yada")
 *             .build());
 *         var foo = new LogStream("foo", LogStreamArgs.builder()
 *             .name("SampleLogStream1234")
 *             .logGroupName(yada.name())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   yada:
 *     type: aws:cloudwatch:LogGroup
 *     properties:
 *       name: Yada
 *   foo:
 *     type: aws:cloudwatch:LogStream
 *     properties:
 *       name: SampleLogStream1234
 *       logGroupName: ${yada.name}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Cloudwatch Log Stream using the stream's `log_group_name` and `name`. For example:
 * ```sh
 * $ pulumi import aws:cloudwatch/logStream:LogStream foo Yada:SampleLogStream1234
 * ```
 */
public class LogStream internal constructor(
    override val javaResource: com.pulumi.aws.cloudwatch.LogStream,
) : KotlinCustomResource(javaResource, LogStreamMapper) {
    /**
     * The Amazon Resource Name (ARN) specifying the log stream.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The name of the log group under which the log stream is to be created.
     */
    public val logGroupName: Output<String>
        get() = javaResource.logGroupName().applyValue({ args0 -> args0 })

    /**
     * The name of the log stream. Must not be longer than 512 characters and must not contain `:`
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })
}

public object LogStreamMapper : ResourceMapper<LogStream> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.cloudwatch.LogStream::class == javaResource::class

    override fun map(javaResource: Resource): LogStream = LogStream(
        javaResource as
            com.pulumi.aws.cloudwatch.LogStream,
    )
}

/**
 * @see [LogStream].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [LogStream].
 */
public suspend fun logStream(name: String, block: suspend LogStreamResourceBuilder.() -> Unit): LogStream {
    val builder = LogStreamResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [LogStream].
 * @param name The _unique_ name of the resulting resource.
 */
public fun logStream(name: String): LogStream {
    val builder = LogStreamResourceBuilder()
    builder.name(name)
    return builder.build()
}
