@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudwatch.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [LogSubscriptionFilter].
 */
@PulumiTagMarker
public class LogSubscriptionFilterResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: LogSubscriptionFilterArgs = LogSubscriptionFilterArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend LogSubscriptionFilterArgsBuilder.() -> Unit) {
        val builder = LogSubscriptionFilterArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): LogSubscriptionFilter {
        val builtJavaResource = com.pulumi.aws.cloudwatch.LogSubscriptionFilter(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return LogSubscriptionFilter(builtJavaResource)
    }
}

/**
 * Provides a CloudWatch Logs subscription filter resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const testLambdafunctionLogfilter = new aws.cloudwatch.LogSubscriptionFilter("test_lambdafunction_logfilter", {
 *     name: "test_lambdafunction_logfilter",
 *     roleArn: iamForLambda.arn,
 *     logGroup: "/aws/lambda/example_lambda_name",
 *     filterPattern: "logtype test",
 *     destinationArn: testLogstream.arn,
 *     distribution: "Random",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test_lambdafunction_logfilter = aws.cloudwatch.LogSubscriptionFilter("test_lambdafunction_logfilter",
 *     name="test_lambdafunction_logfilter",
 *     role_arn=iam_for_lambda["arn"],
 *     log_group="/aws/lambda/example_lambda_name",
 *     filter_pattern="logtype test",
 *     destination_arn=test_logstream["arn"],
 *     distribution="Random")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var testLambdafunctionLogfilter = new Aws.CloudWatch.LogSubscriptionFilter("test_lambdafunction_logfilter", new()
 *     {
 *         Name = "test_lambdafunction_logfilter",
 *         RoleArn = iamForLambda.Arn,
 *         LogGroup = "/aws/lambda/example_lambda_name",
 *         FilterPattern = "logtype test",
 *         DestinationArn = testLogstream.Arn,
 *         Distribution = "Random",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cloudwatch"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cloudwatch.NewLogSubscriptionFilter(ctx, "test_lambdafunction_logfilter", &cloudwatch.LogSubscriptionFilterArgs{
 * 			Name:           pulumi.String("test_lambdafunction_logfilter"),
 * 			RoleArn:        pulumi.Any(iamForLambda.Arn),
 * 			LogGroup:       pulumi.Any("/aws/lambda/example_lambda_name"),
 * 			FilterPattern:  pulumi.String("logtype test"),
 * 			DestinationArn: pulumi.Any(testLogstream.Arn),
 * 			Distribution:   pulumi.String("Random"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudwatch.LogSubscriptionFilter;
 * import com.pulumi.aws.cloudwatch.LogSubscriptionFilterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var testLambdafunctionLogfilter = new LogSubscriptionFilter("testLambdafunctionLogfilter", LogSubscriptionFilterArgs.builder()
 *             .name("test_lambdafunction_logfilter")
 *             .roleArn(iamForLambda.arn())
 *             .logGroup("/aws/lambda/example_lambda_name")
 *             .filterPattern("logtype test")
 *             .destinationArn(testLogstream.arn())
 *             .distribution("Random")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   testLambdafunctionLogfilter:
 *     type: aws:cloudwatch:LogSubscriptionFilter
 *     name: test_lambdafunction_logfilter
 *     properties:
 *       name: test_lambdafunction_logfilter
 *       roleArn: ${iamForLambda.arn}
 *       logGroup: /aws/lambda/example_lambda_name
 *       filterPattern: logtype test
 *       destinationArn: ${testLogstream.arn}
 *       distribution: Random
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import CloudWatch Logs subscription filter using the log group name and subscription filter name separated by `|`. For example:
 * ```sh
 * $ pulumi import aws:cloudwatch/logSubscriptionFilter:LogSubscriptionFilter test_lambdafunction_logfilter "/aws/lambda/example_lambda_name|test_lambdafunction_logfilter"
 * ```
 */
public class LogSubscriptionFilter internal constructor(
    override val javaResource: com.pulumi.aws.cloudwatch.LogSubscriptionFilter,
) : KotlinCustomResource(javaResource, LogSubscriptionFilterMapper) {
    /**
     * The ARN of the destination to deliver matching log events to. Kinesis stream or Lambda function ARN.
     */
    public val destinationArn: Output<String>
        get() = javaResource.destinationArn().applyValue({ args0 -> args0 })

    /**
     * The method used to distribute log data to the destination. By default log data is grouped by log stream, but the grouping can be set to random for a more even distribution. This property is only applicable when the destination is an Amazon Kinesis stream. Valid values are "Random" and "ByLogStream".
     */
    public val distribution: Output<String>?
        get() = javaResource.distribution().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A valid CloudWatch Logs filter pattern for subscribing to a filtered stream of log events. Use empty string `""` to match everything. For more information, see the [Amazon CloudWatch Logs User Guide](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/FilterAndPatternSyntax.html).
     */
    public val filterPattern: Output<String>
        get() = javaResource.filterPattern().applyValue({ args0 -> args0 })

    /**
     * The name of the log group to associate the subscription filter with
     */
    public val logGroup: Output<String>
        get() = javaResource.logGroup().applyValue({ args0 -> args0 })

    /**
     * A name for the subscription filter
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The ARN of an IAM role that grants Amazon CloudWatch Logs permissions to deliver ingested log events to the destination. If you use Lambda as a destination, you should skip this argument and use `aws.lambda.Permission` resource for granting access from CloudWatch logs to the destination Lambda function.
     */
    public val roleArn: Output<String>
        get() = javaResource.roleArn().applyValue({ args0 -> args0 })
}

public object LogSubscriptionFilterMapper : ResourceMapper<LogSubscriptionFilter> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.cloudwatch.LogSubscriptionFilter::class == javaResource::class

    override fun map(javaResource: Resource): LogSubscriptionFilter =
        LogSubscriptionFilter(javaResource as com.pulumi.aws.cloudwatch.LogSubscriptionFilter)
}

/**
 * @see [LogSubscriptionFilter].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [LogSubscriptionFilter].
 */
public suspend fun logSubscriptionFilter(
    name: String,
    block: suspend LogSubscriptionFilterResourceBuilder.() -> Unit,
): LogSubscriptionFilter {
    val builder = LogSubscriptionFilterResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [LogSubscriptionFilter].
 * @param name The _unique_ name of the resulting resource.
 */
public fun logSubscriptionFilter(name: String): LogSubscriptionFilter {
    val builder = LogSubscriptionFilterResourceBuilder()
    builder.name(name)
    return builder.build()
}
