@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudwatch.kotlin

import com.pulumi.aws.cloudwatch.kotlin.outputs.MetricAlarmMetricQuery
import com.pulumi.aws.cloudwatch.kotlin.outputs.MetricAlarmMetricQuery.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [MetricAlarm].
 */
@PulumiTagMarker
public class MetricAlarmResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: MetricAlarmArgs = MetricAlarmArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend MetricAlarmArgsBuilder.() -> Unit) {
        val builder = MetricAlarmArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): MetricAlarm {
        val builtJavaResource = com.pulumi.aws.cloudwatch.MetricAlarm(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return MetricAlarm(builtJavaResource)
    }
}

/**
 * Provides a CloudWatch Metric Alarm resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const foobar = new aws.cloudwatch.MetricAlarm("foobar", {
 *     name: "test-foobar5",
 *     comparisonOperator: "GreaterThanOrEqualToThreshold",
 *     evaluationPeriods: 2,
 *     metricName: "CPUUtilization",
 *     namespace: "AWS/EC2",
 *     period: 120,
 *     statistic: "Average",
 *     threshold: 80,
 *     alarmDescription: "This metric monitors ec2 cpu utilization",
 *     insufficientDataActions: [],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * foobar = aws.cloudwatch.MetricAlarm("foobar",
 *     name="test-foobar5",
 *     comparison_operator="GreaterThanOrEqualToThreshold",
 *     evaluation_periods=2,
 *     metric_name="CPUUtilization",
 *     namespace="AWS/EC2",
 *     period=120,
 *     statistic="Average",
 *     threshold=80,
 *     alarm_description="This metric monitors ec2 cpu utilization",
 *     insufficient_data_actions=[])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var foobar = new Aws.CloudWatch.MetricAlarm("foobar", new()
 *     {
 *         Name = "test-foobar5",
 *         ComparisonOperator = "GreaterThanOrEqualToThreshold",
 *         EvaluationPeriods = 2,
 *         MetricName = "CPUUtilization",
 *         Namespace = "AWS/EC2",
 *         Period = 120,
 *         Statistic = "Average",
 *         Threshold = 80,
 *         AlarmDescription = "This metric monitors ec2 cpu utilization",
 *         InsufficientDataActions = new[] {},
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cloudwatch"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/sns"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cloudwatch.NewMetricAlarm(ctx, "foobar", &cloudwatch.MetricAlarmArgs{
 * 			Name:                    pulumi.String("test-foobar5"),
 * 			ComparisonOperator:      pulumi.String("GreaterThanOrEqualToThreshold"),
 * 			EvaluationPeriods:       pulumi.Int(2),
 * 			MetricName:              pulumi.String("CPUUtilization"),
 * 			Namespace:               pulumi.String("AWS/EC2"),
 * 			Period:                  pulumi.Int(120),
 * 			Statistic:               pulumi.String("Average"),
 * 			Threshold:               pulumi.Float64(80),
 * 			AlarmDescription:        pulumi.String("This metric monitors ec2 cpu utilization"),
 * 			InsufficientDataActions: pulumi.Array{},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudwatch.MetricAlarm;
 * import com.pulumi.aws.cloudwatch.MetricAlarmArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var foobar = new MetricAlarm("foobar", MetricAlarmArgs.builder()
 *             .name("test-foobar5")
 *             .comparisonOperator("GreaterThanOrEqualToThreshold")
 *             .evaluationPeriods(2)
 *             .metricName("CPUUtilization")
 *             .namespace("AWS/EC2")
 *             .period(120)
 *             .statistic("Average")
 *             .threshold(80)
 *             .alarmDescription("This metric monitors ec2 cpu utilization")
 *             .insufficientDataActions()
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   foobar:
 *     type: aws:cloudwatch:MetricAlarm
 *     properties:
 *       name: test-foobar5
 *       comparisonOperator: GreaterThanOrEqualToThreshold
 *       evaluationPeriods: 2
 *       metricName: CPUUtilization
 *       namespace: AWS/EC2
 *       period: 120
 *       statistic: Average
 *       threshold: 80
 *       alarmDescription: This metric monitors ec2 cpu utilization
 *       insufficientDataActions: []
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Example in Conjunction with Scaling Policies
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const bat = new aws.autoscaling.Policy("bat", {
 *     name: "foobar3-test",
 *     scalingAdjustment: 4,
 *     adjustmentType: "ChangeInCapacity",
 *     cooldown: 300,
 *     autoscalingGroupName: bar.name,
 * });
 * const batMetricAlarm = new aws.cloudwatch.MetricAlarm("bat", {
 *     name: "test-foobar5",
 *     comparisonOperator: "GreaterThanOrEqualToThreshold",
 *     evaluationPeriods: 2,
 *     metricName: "CPUUtilization",
 *     namespace: "AWS/EC2",
 *     period: 120,
 *     statistic: "Average",
 *     threshold: 80,
 *     dimensions: {
 *         AutoScalingGroupName: bar.name,
 *     },
 *     alarmDescription: "This metric monitors ec2 cpu utilization",
 *     alarmActions: [bat&#46;arn],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * bat = aws.autoscaling.Policy("bat",
 *     name="foobar3-test",
 *     scaling_adjustment=4,
 *     adjustment_type="ChangeInCapacity",
 *     cooldown=300,
 *     autoscaling_group_name=bar["name"])
 * bat_metric_alarm = aws.cloudwatch.MetricAlarm("bat",
 *     name="test-foobar5",
 *     comparison_operator="GreaterThanOrEqualToThreshold",
 *     evaluation_periods=2,
 *     metric_name="CPUUtilization",
 *     namespace="AWS/EC2",
 *     period=120,
 *     statistic="Average",
 *     threshold=80,
 *     dimensions={
 *         "AutoScalingGroupName": bar["name"],
 *     },
 *     alarm_description="This metric monitors ec2 cpu utilization",
 *     alarm_actions=[bat&#46;arn])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var bat = new Aws.AutoScaling.Policy("bat", new()
 *     {
 *         Name = "foobar3-test",
 *         ScalingAdjustment = 4,
 *         AdjustmentType = "ChangeInCapacity",
 *         Cooldown = 300,
 *         AutoscalingGroupName = bar.Name,
 *     });
 *     var batMetricAlarm = new Aws.CloudWatch.MetricAlarm("bat", new()
 *     {
 *         Name = "test-foobar5",
 *         ComparisonOperator = "GreaterThanOrEqualToThreshold",
 *         EvaluationPeriods = 2,
 *         MetricName = "CPUUtilization",
 *         Namespace = "AWS/EC2",
 *         Period = 120,
 *         Statistic = "Average",
 *         Threshold = 80,
 *         Dimensions =
 *         {
 *             { "AutoScalingGroupName", bar.Name },
 *         },
 *         AlarmDescription = "This metric monitors ec2 cpu utilization",
 *         AlarmActions = new[]
 *         {
 *             bat.Arn,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/autoscaling"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cloudwatch"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/sns"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		bat, err := autoscaling.NewPolicy(ctx, "bat", &autoscaling.PolicyArgs{
 * 			Name:                 pulumi.String("foobar3-test"),
 * 			ScalingAdjustment:    pulumi.Int(4),
 * 			AdjustmentType:       pulumi.String("ChangeInCapacity"),
 * 			Cooldown:             pulumi.Int(300),
 * 			AutoscalingGroupName: pulumi.Any(bar.Name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = cloudwatch.NewMetricAlarm(ctx, "bat", &cloudwatch.MetricAlarmArgs{
 * 			Name:               pulumi.String("test-foobar5"),
 * 			ComparisonOperator: pulumi.String("GreaterThanOrEqualToThreshold"),
 * 			EvaluationPeriods:  pulumi.Int(2),
 * 			MetricName:         pulumi.String("CPUUtilization"),
 * 			Namespace:          pulumi.String("AWS/EC2"),
 * 			Period:             pulumi.Int(120),
 * 			Statistic:          pulumi.String("Average"),
 * 			Threshold:          pulumi.Float64(80),
 * 			Dimensions: pulumi.StringMap{
 * 				"AutoScalingGroupName": pulumi.Any(bar.Name),
 * 			},
 * 			AlarmDescription: pulumi.String("This metric monitors ec2 cpu utilization"),
 * 			AlarmActions: pulumi.Array{
 * 				bat.Arn,
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.autoscaling.Policy;
 * import com.pulumi.aws.autoscaling.PolicyArgs;
 * import com.pulumi.aws.cloudwatch.MetricAlarm;
 * import com.pulumi.aws.cloudwatch.MetricAlarmArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var bat = new Policy("bat", PolicyArgs.builder()
 *             .name("foobar3-test")
 *             .scalingAdjustment(4)
 *             .adjustmentType("ChangeInCapacity")
 *             .cooldown(300)
 *             .autoscalingGroupName(bar.name())
 *             .build());
 *         var batMetricAlarm = new MetricAlarm("batMetricAlarm", MetricAlarmArgs.builder()
 *             .name("test-foobar5")
 *             .comparisonOperator("GreaterThanOrEqualToThreshold")
 *             .evaluationPeriods(2)
 *             .metricName("CPUUtilization")
 *             .namespace("AWS/EC2")
 *             .period(120)
 *             .statistic("Average")
 *             .threshold(80)
 *             .dimensions(Map.of("AutoScalingGroupName", bar.name()))
 *             .alarmDescription("This metric monitors ec2 cpu utilization")
 *             .alarmActions(bat.arn())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   bat:
 *     type: aws:autoscaling:Policy
 *     properties:
 *       name: foobar3-test
 *       scalingAdjustment: 4
 *       adjustmentType: ChangeInCapacity
 *       cooldown: 300
 *       autoscalingGroupName: ${bar.name}
 *   batMetricAlarm:
 *     type: aws:cloudwatch:MetricAlarm
 *     name: bat
 *     properties:
 *       name: test-foobar5
 *       comparisonOperator: GreaterThanOrEqualToThreshold
 *       evaluationPeriods: 2
 *       metricName: CPUUtilization
 *       namespace: AWS/EC2
 *       period: 120
 *       statistic: Average
 *       threshold: 80
 *       dimensions:
 *         AutoScalingGroupName: ${bar.name}
 *       alarmDescription: This metric monitors ec2 cpu utilization
 *       alarmActions:
 *         - ${bat.arn}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Example with an Expression
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const foobar = new aws.cloudwatch.MetricAlarm("foobar", {
 *     name: "test-foobar",
 *     comparisonOperator: "GreaterThanOrEqualToThreshold",
 *     evaluationPeriods: 2,
 *     threshold: 10,
 *     alarmDescription: "Request error rate has exceeded 10%",
 *     insufficientDataActions: [],
 *     metricQueries: [
 *         {
 *             id: "e1",
 *             expression: "m2/m1*100",
 *             label: "Error Rate",
 *             returnData: true,
 *         },
 *         {
 *             id: "m1",
 *             metric: {
 *                 metricName: "RequestCount",
 *                 namespace: "AWS/ApplicationELB",
 *                 period: 120,
 *                 stat: "Sum",
 *                 unit: "Count",
 *                 dimensions: {
 *                     LoadBalancer: "app/web",
 *                 },
 *             },
 *         },
 *         {
 *             id: "m2",
 *             metric: {
 *                 metricName: "HTTPCode_ELB_5XX_Count",
 *                 namespace: "AWS/ApplicationELB",
 *                 period: 120,
 *                 stat: "Sum",
 *                 unit: "Count",
 *                 dimensions: {
 *                     LoadBalancer: "app/web",
 *                 },
 *             },
 *         },
 *     ],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * foobar = aws.cloudwatch.MetricAlarm("foobar",
 *     name="test-foobar",
 *     comparison_operator="GreaterThanOrEqualToThreshold",
 *     evaluation_periods=2,
 *     threshold=10,
 *     alarm_description="Request error rate has exceeded 10%",
 *     insufficient_data_actions=[],
 *     metric_queries=[
 *         {
 *             "id": "e1",
 *             "expression": "m2/m1*100",
 *             "label": "Error Rate",
 *             "return_data": True,
 *         },
 *         {
 *             "id": "m1",
 *             "metric": {
 *                 "metric_name": "RequestCount",
 *                 "namespace": "AWS/ApplicationELB",
 *                 "period": 120,
 *                 "stat": "Sum",
 *                 "unit": "Count",
 *                 "dimensions": {
 *                     "load_balancer": "app/web",
 *                 },
 *             },
 *         },
 *         {
 *             "id": "m2",
 *             "metric": {
 *                 "metric_name": "HTTPCode_ELB_5XX_Count",
 *                 "namespace": "AWS/ApplicationELB",
 *                 "period": 120,
 *                 "stat": "Sum",
 *                 "unit": "Count",
 *                 "dimensions": {
 *                     "load_balancer": "app/web",
 *                 },
 *             },
 *         },
 *     ])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var foobar = new Aws.CloudWatch.MetricAlarm("foobar", new()
 *     {
 *         Name = "test-foobar",
 *         ComparisonOperator = "GreaterThanOrEqualToThreshold",
 *         EvaluationPeriods = 2,
 *         Threshold = 10,
 *         AlarmDescription = "Request error rate has exceeded 10%",
 *         InsufficientDataActions = new[] {},
 *         MetricQueries = new[]
 *         {
 *             new Aws.CloudWatch.Inputs.MetricAlarmMetricQueryArgs
 *             {
 *                 Id = "e1",
 *                 Expression = "m2/m1*100",
 *                 Label = "Error Rate",
 *                 ReturnData = true,
 *             },
 *             new Aws.CloudWatch.Inputs.MetricAlarmMetricQueryArgs
 *             {
 *                 Id = "m1",
 *                 Metric = new Aws.CloudWatch.Inputs.MetricAlarmMetricQueryMetricArgs
 *                 {
 *                     MetricName = "RequestCount",
 *                     Namespace = "AWS/ApplicationELB",
 *                     Period = 120,
 *                     Stat = "Sum",
 *                     Unit = "Count",
 *                     Dimensions =
 *                     {
 *                         { "LoadBalancer", "app/web" },
 *                     },
 *                 },
 *             },
 *             new Aws.CloudWatch.Inputs.MetricAlarmMetricQueryArgs
 *             {
 *                 Id = "m2",
 *                 Metric = new Aws.CloudWatch.Inputs.MetricAlarmMetricQueryMetricArgs
 *                 {
 *                     MetricName = "HTTPCode_ELB_5XX_Count",
 *                     Namespace = "AWS/ApplicationELB",
 *                     Period = 120,
 *                     Stat = "Sum",
 *                     Unit = "Count",
 *                     Dimensions =
 *                     {
 *                         { "LoadBalancer", "app/web" },
 *                     },
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cloudwatch"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/sns"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cloudwatch.NewMetricAlarm(ctx, "foobar", &cloudwatch.MetricAlarmArgs{
 * 			Name:                    pulumi.String("test-foobar"),
 * 			ComparisonOperator:      pulumi.String("GreaterThanOrEqualToThreshold"),
 * 			EvaluationPeriods:       pulumi.Int(2),
 * 			Threshold:               pulumi.Float64(10),
 * 			AlarmDescription:        pulumi.String("Request error rate has exceeded 10%"),
 * 			InsufficientDataActions: pulumi.Array{},
 * 			MetricQueries: cloudwatch.MetricAlarmMetricQueryArray{
 * 				&cloudwatch.MetricAlarmMetricQueryArgs{
 * 					Id:         pulumi.String("e1"),
 * 					Expression: pulumi.String("m2/m1*100"),
 * 					Label:      pulumi.String("Error Rate"),
 * 					ReturnData: pulumi.Bool(true),
 * 				},
 * 				&cloudwatch.MetricAlarmMetricQueryArgs{
 * 					Id: pulumi.String("m1"),
 * 					Metric: &cloudwatch.MetricAlarmMetricQueryMetricArgs{
 * 						MetricName: pulumi.String("RequestCount"),
 * 						Namespace:  pulumi.String("AWS/ApplicationELB"),
 * 						Period:     pulumi.Int(120),
 * 						Stat:       pulumi.String("Sum"),
 * 						Unit:       pulumi.String("Count"),
 * 						Dimensions: pulumi.StringMap{
 * 							"LoadBalancer": pulumi.String("app/web"),
 * 						},
 * 					},
 * 				},
 * 				&cloudwatch.MetricAlarmMetricQueryArgs{
 * 					Id: pulumi.String("m2"),
 * 					Metric: &cloudwatch.MetricAlarmMetricQueryMetricArgs{
 * 						MetricName: pulumi.String("HTTPCode_ELB_5XX_Count"),
 * 						Namespace:  pulumi.String("AWS/ApplicationELB"),
 * 						Period:     pulumi.Int(120),
 * 						Stat:       pulumi.String("Sum"),
 * 						Unit:       pulumi.String("Count"),
 * 						Dimensions: pulumi.StringMap{
 * 							"LoadBalancer": pulumi.String("app/web"),
 * 						},
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudwatch.MetricAlarm;
 * import com.pulumi.aws.cloudwatch.MetricAlarmArgs;
 * import com.pulumi.aws.cloudwatch.inputs.MetricAlarmMetricQueryArgs;
 * import com.pulumi.aws.cloudwatch.inputs.MetricAlarmMetricQueryMetricArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var foobar = new MetricAlarm("foobar", MetricAlarmArgs.builder()
 *             .name("test-foobar")
 *             .comparisonOperator("GreaterThanOrEqualToThreshold")
 *             .evaluationPeriods(2)
 *             .threshold(10)
 *             .alarmDescription("Request error rate has exceeded 10%")
 *             .insufficientDataActions()
 *             .metricQueries(
 *                 MetricAlarmMetricQueryArgs.builder()
 *                     .id("e1")
 *                     .expression("m2/m1*100")
 *                     .label("Error Rate")
 *                     .returnData("true")
 *                     .build(),
 *                 MetricAlarmMetricQueryArgs.builder()
 *                     .id("m1")
 *                     .metric(MetricAlarmMetricQueryMetricArgs.builder()
 *                         .metricName("RequestCount")
 *                         .namespace("AWS/ApplicationELB")
 *                         .period(120)
 *                         .stat("Sum")
 *                         .unit("Count")
 *                         .dimensions(Map.of("LoadBalancer", "app/web"))
 *                         .build())
 *                     .build(),
 *                 MetricAlarmMetricQueryArgs.builder()
 *                     .id("m2")
 *                     .metric(MetricAlarmMetricQueryMetricArgs.builder()
 *                         .metricName("HTTPCode_ELB_5XX_Count")
 *                         .namespace("AWS/ApplicationELB")
 *                         .period(120)
 *                         .stat("Sum")
 *                         .unit("Count")
 *                         .dimensions(Map.of("LoadBalancer", "app/web"))
 *                         .build())
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   foobar:
 *     type: aws:cloudwatch:MetricAlarm
 *     properties:
 *       name: test-foobar
 *       comparisonOperator: GreaterThanOrEqualToThreshold
 *       evaluationPeriods: 2
 *       threshold: 10
 *       alarmDescription: Request error rate has exceeded 10%
 *       insufficientDataActions: []
 *       metricQueries:
 *         - id: e1
 *           expression: m2/m1*100
 *           label: Error Rate
 *           returnData: 'true'
 *         - id: m1
 *           metric:
 *             metricName: RequestCount
 *             namespace: AWS/ApplicationELB
 *             period: 120
 *             stat: Sum
 *             unit: Count
 *             dimensions:
 *               LoadBalancer: app/web
 *         - id: m2
 *           metric:
 *             metricName: HTTPCode_ELB_5XX_Count
 *             namespace: AWS/ApplicationELB
 *             period: 120
 *             stat: Sum
 *             unit: Count
 *             dimensions:
 *               LoadBalancer: app/web
 * ```
 * <!--End PulumiCodeChooser -->
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const xxAnomalyDetection = new aws.cloudwatch.MetricAlarm("xx_anomaly_detection", {
 *     name: "test-foobar",
 *     comparisonOperator: "GreaterThanUpperThreshold",
 *     evaluationPeriods: 2,
 *     thresholdMetricId: "e1",
 *     alarmDescription: "This metric monitors ec2 cpu utilization",
 *     insufficientDataActions: [],
 *     metricQueries: [
 *         {
 *             id: "e1",
 *             expression: "ANOMALY_DETECTION_BAND(m1)",
 *             label: "CPUUtilization (Expected)",
 *             returnData: true,
 *         },
 *         {
 *             id: "m1",
 *             returnData: true,
 *             metric: {
 *                 metricName: "CPUUtilization",
 *                 namespace: "AWS/EC2",
 *                 period: 120,
 *                 stat: "Average",
 *                 unit: "Count",
 *                 dimensions: {
 *                     InstanceId: "i-abc123",
 *                 },
 *             },
 *         },
 *     ],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * xx_anomaly_detection = aws.cloudwatch.MetricAlarm("xx_anomaly_detection",
 *     name="test-foobar",
 *     comparison_operator="GreaterThanUpperThreshold",
 *     evaluation_periods=2,
 *     threshold_metric_id="e1",
 *     alarm_description="This metric monitors ec2 cpu utilization",
 *     insufficient_data_actions=[],
 *     metric_queries=[
 *         {
 *             "id": "e1",
 *             "expression": "ANOMALY_DETECTION_BAND(m1)",
 *             "label": "CPUUtilization (Expected)",
 *             "return_data": True,
 *         },
 *         {
 *             "id": "m1",
 *             "return_data": True,
 *             "metric": {
 *                 "metric_name": "CPUUtilization",
 *                 "namespace": "AWS/EC2",
 *                 "period": 120,
 *                 "stat": "Average",
 *                 "unit": "Count",
 *                 "dimensions": {
 *                     "instance_id": "i-abc123",
 *                 },
 *             },
 *         },
 *     ])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var xxAnomalyDetection = new Aws.CloudWatch.MetricAlarm("xx_anomaly_detection", new()
 *     {
 *         Name = "test-foobar",
 *         ComparisonOperator = "GreaterThanUpperThreshold",
 *         EvaluationPeriods = 2,
 *         ThresholdMetricId = "e1",
 *         AlarmDescription = "This metric monitors ec2 cpu utilization",
 *         InsufficientDataActions = new[] {},
 *         MetricQueries = new[]
 *         {
 *             new Aws.CloudWatch.Inputs.MetricAlarmMetricQueryArgs
 *             {
 *                 Id = "e1",
 *                 Expression = "ANOMALY_DETECTION_BAND(m1)",
 *                 Label = "CPUUtilization (Expected)",
 *                 ReturnData = true,
 *             },
 *             new Aws.CloudWatch.Inputs.MetricAlarmMetricQueryArgs
 *             {
 *                 Id = "m1",
 *                 ReturnData = true,
 *                 Metric = new Aws.CloudWatch.Inputs.MetricAlarmMetricQueryMetricArgs
 *                 {
 *                     MetricName = "CPUUtilization",
 *                     Namespace = "AWS/EC2",
 *                     Period = 120,
 *                     Stat = "Average",
 *                     Unit = "Count",
 *                     Dimensions =
 *                     {
 *                         { "InstanceId", "i-abc123" },
 *                     },
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cloudwatch"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/sns"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cloudwatch.NewMetricAlarm(ctx, "xx_anomaly_detection", &cloudwatch.MetricAlarmArgs{
 * 			Name:                    pulumi.String("test-foobar"),
 * 			ComparisonOperator:      pulumi.String("GreaterThanUpperThreshold"),
 * 			EvaluationPeriods:       pulumi.Int(2),
 * 			ThresholdMetricId:       pulumi.String("e1"),
 * 			AlarmDescription:        pulumi.String("This metric monitors ec2 cpu utilization"),
 * 			InsufficientDataActions: pulumi.Array{},
 * 			MetricQueries: cloudwatch.MetricAlarmMetricQueryArray{
 * 				&cloudwatch.MetricAlarmMetricQueryArgs{
 * 					Id:         pulumi.String("e1"),
 * 					Expression: pulumi.String("ANOMALY_DETECTION_BAND(m1)"),
 * 					Label:      pulumi.String("CPUUtilization (Expected)"),
 * 					ReturnData: pulumi.Bool(true),
 * 				},
 * 				&cloudwatch.MetricAlarmMetricQueryArgs{
 * 					Id:         pulumi.String("m1"),
 * 					ReturnData: pulumi.Bool(true),
 * 					Metric: &cloudwatch.MetricAlarmMetricQueryMetricArgs{
 * 						MetricName: pulumi.String("CPUUtilization"),
 * 						Namespace:  pulumi.String("AWS/EC2"),
 * 						Period:     pulumi.Int(120),
 * 						Stat:       pulumi.String("Average"),
 * 						Unit:       pulumi.String("Count"),
 * 						Dimensions: pulumi.StringMap{
 * 							"InstanceId": pulumi.String("i-abc123"),
 * 						},
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudwatch.MetricAlarm;
 * import com.pulumi.aws.cloudwatch.MetricAlarmArgs;
 * import com.pulumi.aws.cloudwatch.inputs.MetricAlarmMetricQueryArgs;
 * import com.pulumi.aws.cloudwatch.inputs.MetricAlarmMetricQueryMetricArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var xxAnomalyDetection = new MetricAlarm("xxAnomalyDetection", MetricAlarmArgs.builder()
 *             .name("test-foobar")
 *             .comparisonOperator("GreaterThanUpperThreshold")
 *             .evaluationPeriods(2)
 *             .thresholdMetricId("e1")
 *             .alarmDescription("This metric monitors ec2 cpu utilization")
 *             .insufficientDataActions()
 *             .metricQueries(
 *                 MetricAlarmMetricQueryArgs.builder()
 *                     .id("e1")
 *                     .expression("ANOMALY_DETECTION_BAND(m1)")
 *                     .label("CPUUtilization (Expected)")
 *                     .returnData("true")
 *                     .build(),
 *                 MetricAlarmMetricQueryArgs.builder()
 *                     .id("m1")
 *                     .returnData("true")
 *                     .metric(MetricAlarmMetricQueryMetricArgs.builder()
 *                         .metricName("CPUUtilization")
 *                         .namespace("AWS/EC2")
 *                         .period(120)
 *                         .stat("Average")
 *                         .unit("Count")
 *                         .dimensions(Map.of("InstanceId", "i-abc123"))
 *                         .build())
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   xxAnomalyDetection:
 *     type: aws:cloudwatch:MetricAlarm
 *     name: xx_anomaly_detection
 *     properties:
 *       name: test-foobar
 *       comparisonOperator: GreaterThanUpperThreshold
 *       evaluationPeriods: 2
 *       thresholdMetricId: e1
 *       alarmDescription: This metric monitors ec2 cpu utilization
 *       insufficientDataActions: []
 *       metricQueries:
 *         - id: e1
 *           expression: ANOMALY_DETECTION_BAND(m1)
 *           label: CPUUtilization (Expected)
 *           returnData: 'true'
 *         - id: m1
 *           returnData: 'true'
 *           metric:
 *             metricName: CPUUtilization
 *             namespace: AWS/EC2
 *             period: 120
 *             stat: Average
 *             unit: Count
 *             dimensions:
 *               InstanceId: i-abc123
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Example of monitoring Healthy Hosts on NLB using Target Group and NLB
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const nlbHealthyhosts = new aws.cloudwatch.MetricAlarm("nlb_healthyhosts", {
 *     name: "alarmname",
 *     comparisonOperator: "LessThanThreshold",
 *     evaluationPeriods: 1,
 *     metricName: "HealthyHostCount",
 *     namespace: "AWS/NetworkELB",
 *     period: 60,
 *     statistic: "Average",
 *     threshold: logstashServersCount,
 *     alarmDescription: "Number of healthy nodes in Target Group",
 *     actionsEnabled: true,
 *     alarmActions: [sns&#46;arn],
 *     okActions: [sns&#46;arn],
 *     dimensions: {
 *         TargetGroup: lb_tg.arnSuffix,
 *         LoadBalancer: lb.arnSuffix,
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * nlb_healthyhosts = aws.cloudwatch.MetricAlarm("nlb_healthyhosts",
 *     name="alarmname",
 *     comparison_operator="LessThanThreshold",
 *     evaluation_periods=1,
 *     metric_name="HealthyHostCount",
 *     namespace="AWS/NetworkELB",
 *     period=60,
 *     statistic="Average",
 *     threshold=logstash_servers_count,
 *     alarm_description="Number of healthy nodes in Target Group",
 *     actions_enabled=True,
 *     alarm_actions=[sns["arn"]],
 *     ok_actions=[sns["arn"]],
 *     dimensions={
 *         "TargetGroup": lb_tg["arnSuffix"],
 *         "LoadBalancer": lb["arnSuffix"],
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var nlbHealthyhosts = new Aws.CloudWatch.MetricAlarm("nlb_healthyhosts", new()
 *     {
 *         Name = "alarmname",
 *         ComparisonOperator = "LessThanThreshold",
 *         EvaluationPeriods = 1,
 *         MetricName = "HealthyHostCount",
 *         Namespace = "AWS/NetworkELB",
 *         Period = 60,
 *         Statistic = "Average",
 *         Threshold = logstashServersCount,
 *         AlarmDescription = "Number of healthy nodes in Target Group",
 *         ActionsEnabled = true,
 *         AlarmActions = new[]
 *         {
 *             sns.Arn,
 *         },
 *         OkActions = new[]
 *         {
 *             sns.Arn,
 *         },
 *         Dimensions =
 *         {
 *             { "TargetGroup", lb_tg.ArnSuffix },
 *             { "LoadBalancer", lb.ArnSuffix },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cloudwatch"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/sns"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cloudwatch.NewMetricAlarm(ctx, "nlb_healthyhosts", &cloudwatch.MetricAlarmArgs{
 * 			Name:               pulumi.String("alarmname"),
 * 			ComparisonOperator: pulumi.String("LessThanThreshold"),
 * 			EvaluationPeriods:  pulumi.Int(1),
 * 			MetricName:         pulumi.String("HealthyHostCount"),
 * 			Namespace:          pulumi.String("AWS/NetworkELB"),
 * 			Period:             pulumi.Int(60),
 * 			Statistic:          pulumi.String("Average"),
 * 			Threshold:          pulumi.Any(logstashServersCount),
 * 			AlarmDescription:   pulumi.String("Number of healthy nodes in Target Group"),
 * 			ActionsEnabled:     pulumi.Bool(true),
 * 			AlarmActions: pulumi.Array{
 * 				sns.Arn,
 * 			},
 * 			OkActions: pulumi.Array{
 * 				sns.Arn,
 * 			},
 * 			Dimensions: pulumi.StringMap{
 * 				"TargetGroup":  pulumi.Any(lb_tg.ArnSuffix),
 * 				"LoadBalancer": pulumi.Any(lb.ArnSuffix),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudwatch.MetricAlarm;
 * import com.pulumi.aws.cloudwatch.MetricAlarmArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var nlbHealthyhosts = new MetricAlarm("nlbHealthyhosts", MetricAlarmArgs.builder()
 *             .name("alarmname")
 *             .comparisonOperator("LessThanThreshold")
 *             .evaluationPeriods(1)
 *             .metricName("HealthyHostCount")
 *             .namespace("AWS/NetworkELB")
 *             .period(60)
 *             .statistic("Average")
 *             .threshold(logstashServersCount)
 *             .alarmDescription("Number of healthy nodes in Target Group")
 *             .actionsEnabled("true")
 *             .alarmActions(sns.arn())
 *             .okActions(sns.arn())
 *             .dimensions(Map.ofEntries(
 *                 Map.entry("TargetGroup", lb_tg.arnSuffix()),
 *                 Map.entry("LoadBalancer", lb.arnSuffix())
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   nlbHealthyhosts:
 *     type: aws:cloudwatch:MetricAlarm
 *     name: nlb_healthyhosts
 *     properties:
 *       name: alarmname
 *       comparisonOperator: LessThanThreshold
 *       evaluationPeriods: 1
 *       metricName: HealthyHostCount
 *       namespace: AWS/NetworkELB
 *       period: 60
 *       statistic: Average
 *       threshold: ${logstashServersCount}
 *       alarmDescription: Number of healthy nodes in Target Group
 *       actionsEnabled: 'true'
 *       alarmActions:
 *         - ${sns.arn}
 *       okActions:
 *         - ${sns.arn}
 *       dimensions:
 *         TargetGroup: ${["lb-tg"].arnSuffix}
 *         LoadBalancer: ${lb.arnSuffix}
 * ```
 * <!--End PulumiCodeChooser -->
 * > **NOTE:**  You cannot create a metric alarm consisting of both `statistic` and `extended_statistic` parameters.
 * You must choose one or the other
 * ## Import
 * Using `pulumi import`, import CloudWatch Metric Alarm using the `alarm_name`. For example:
 * ```sh
 * $ pulumi import aws:cloudwatch/metricAlarm:MetricAlarm test alarm-12345
 * ```
 */
public class MetricAlarm internal constructor(
    override val javaResource: com.pulumi.aws.cloudwatch.MetricAlarm,
) : KotlinCustomResource(javaResource, MetricAlarmMapper) {
    /**
     * Indicates whether or not actions should be executed during any changes to the alarm's state. Defaults to `true`.
     */
    public val actionsEnabled: Output<Boolean>?
        get() = javaResource.actionsEnabled().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The list of actions to execute when this alarm transitions into an ALARM state from any other state. Each action is specified as an Amazon Resource Name (ARN).
     */
    public val alarmActions: Output<List<String>>?
        get() = javaResource.alarmActions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * The description for the alarm.
     */
    public val alarmDescription: Output<String>?
        get() = javaResource.alarmDescription().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ARN of the CloudWatch Metric Alarm.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The arithmetic operation to use when comparing the specified Statistic and Threshold. The specified Statistic value is used as the first operand. Either of the following is supported: `GreaterThanOrEqualToThreshold`, `GreaterThanThreshold`, `LessThanThreshold`, `LessThanOrEqualToThreshold`. Additionally, the values  `LessThanLowerOrGreaterThanUpperThreshold`, `LessThanLowerThreshold`, and `GreaterThanUpperThreshold` are used only for alarms based on anomaly detection models.
     */
    public val comparisonOperator: Output<String>
        get() = javaResource.comparisonOperator().applyValue({ args0 -> args0 })

    /**
     * The number of datapoints that must be breaching to trigger the alarm.
     */
    public val datapointsToAlarm: Output<Int>?
        get() = javaResource.datapointsToAlarm().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The dimensions for the alarm's associated metric.  For the list of available dimensions see the AWS documentation [here](http://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/CW_Support_For_AWS.html).
     */
    public val dimensions: Output<Map<String, String>>?
        get() = javaResource.dimensions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Used only for alarms based on percentiles.
     * If you specify `ignore`, the alarm state will not change during periods with too few data points to be statistically significant.
     * If you specify `evaluate` or omit this parameter, the alarm will always be evaluated and possibly change state no matter how many data points are available.
     * The following values are supported: `ignore`, and `evaluate`.
     */
    public val evaluateLowSampleCountPercentiles: Output<String>
        get() = javaResource.evaluateLowSampleCountPercentiles().applyValue({ args0 -> args0 })

    /**
     * The number of periods over which data is compared to the specified threshold.
     */
    public val evaluationPeriods: Output<Int>
        get() = javaResource.evaluationPeriods().applyValue({ args0 -> args0 })

    /**
     * The percentile statistic for the metric associated with the alarm. Specify a value between p0.0 and p100.
     */
    public val extendedStatistic: Output<String>?
        get() = javaResource.extendedStatistic().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The list of actions to execute when this alarm transitions into an INSUFFICIENT_DATA state from any other state. Each action is specified as an Amazon Resource Name (ARN).
     */
    public val insufficientDataActions: Output<List<String>>?
        get() = javaResource.insufficientDataActions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * The name for the alarm's associated metric.
     * See docs for [supported metrics](https://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/CW_Support_For_AWS.html).
     */
    public val metricName: Output<String>?
        get() = javaResource.metricName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Enables you to create an alarm based on a metric math expression. You may specify at most 20.
     */
    public val metricQueries: Output<List<MetricAlarmMetricQuery>>?
        get() = javaResource.metricQueries().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })
            }).orElse(null)
        })

    /**
     * The descriptive name for the alarm. This name must be unique within the user's AWS account
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The namespace for the alarm's associated metric. See docs for the [list of namespaces](https://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/aws-namespaces.html).
     * See docs for [supported metrics](https://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/CW_Support_For_AWS.html).
     */
    public val namespace: Output<String>?
        get() = javaResource.namespace().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The list of actions to execute when this alarm transitions into an OK state from any other state. Each action is specified as an Amazon Resource Name (ARN).
     */
    public val okActions: Output<List<String>>?
        get() = javaResource.okActions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * The period in seconds over which the specified `statistic` is applied.
     * Valid values are `10`, `30`, or any multiple of `60`.
     */
    public val period: Output<Int>?
        get() = javaResource.period().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The statistic to apply to the alarm's associated metric.
     * Either of the following is supported: `SampleCount`, `Average`, `Sum`, `Minimum`, `Maximum`
     */
    public val statistic: Output<String>?
        get() = javaResource.statistic().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * > **NOTE:**  If you specify at least one `metric_query`, you may not specify a `metric_name`, `namespace`, `period` or `statistic`. If you do not specify a `metric_query`, you must specify each of these (although you may use `extended_statistic` instead of `statistic`).
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * The value against which the specified statistic is compared. This parameter is required for alarms based on static thresholds, but should not be used for alarms based on anomaly detection models.
     */
    public val threshold: Output<Double>?
        get() = javaResource.threshold().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * If this is an alarm based on an anomaly detection model, make this value match the ID of the ANOMALY_DETECTION_BAND function.
     */
    public val thresholdMetricId: Output<String>?
        get() = javaResource.thresholdMetricId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Sets how this alarm is to handle missing data points. The following values are supported: `missing`, `ignore`, `breaching` and `notBreaching`. Defaults to `missing`.
     */
    public val treatMissingData: Output<String>?
        get() = javaResource.treatMissingData().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The unit for the alarm's associated metric.
     */
    public val unit: Output<String>?
        get() = javaResource.unit().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object MetricAlarmMapper : ResourceMapper<MetricAlarm> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.cloudwatch.MetricAlarm::class == javaResource::class

    override fun map(javaResource: Resource): MetricAlarm = MetricAlarm(
        javaResource as
            com.pulumi.aws.cloudwatch.MetricAlarm,
    )
}

/**
 * @see [MetricAlarm].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [MetricAlarm].
 */
public suspend fun metricAlarm(name: String, block: suspend MetricAlarmResourceBuilder.() -> Unit): MetricAlarm {
    val builder = MetricAlarmResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [MetricAlarm].
 * @param name The _unique_ name of the resulting resource.
 */
public fun metricAlarm(name: String): MetricAlarm {
    val builder = MetricAlarmResourceBuilder()
    builder.name(name)
    return builder.build()
}
