@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudwatch.kotlin

import com.pulumi.aws.cloudwatch.QueryDefinitionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a CloudWatch Logs query definition resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.cloudwatch.QueryDefinition("example", {
 *     name: "custom_query",
 *     logGroupNames: [
 *         "/aws/logGroup1",
 *         "/aws/logGroup2",
 *     ],
 *     queryString: `fields @timestamp, @message
 * | sort @timestamp desc
 * | limit 25
 * `,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.cloudwatch.QueryDefinition("example",
 *     name="custom_query",
 *     log_group_names=[
 *         "/aws/logGroup1",
 *         "/aws/logGroup2",
 *     ],
 *     query_string="""fields @timestamp, @message
 * | sort @timestamp desc
 * | limit 25
 * """)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.CloudWatch.QueryDefinition("example", new()
 *     {
 *         Name = "custom_query",
 *         LogGroupNames = new[]
 *         {
 *             "/aws/logGroup1",
 *             "/aws/logGroup2",
 *         },
 *         QueryString = @"fields @timestamp, @message
 * | sort @timestamp desc
 * | limit 25
 * ",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cloudwatch"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cloudwatch.NewQueryDefinition(ctx, "example", &cloudwatch.QueryDefinitionArgs{
 * 			Name: pulumi.String("custom_query"),
 * 			LogGroupNames: pulumi.StringArray{
 * 				pulumi.String("/aws/logGroup1"),
 * 				pulumi.String("/aws/logGroup2"),
 * 			},
 * 			QueryString: pulumi.String("fields @timestamp, @message\n| sort @timestamp desc\n| limit 25\n"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudwatch.QueryDefinition;
 * import com.pulumi.aws.cloudwatch.QueryDefinitionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new QueryDefinition("example", QueryDefinitionArgs.builder()
 *             .name("custom_query")
 *             .logGroupNames(
 *                 "/aws/logGroup1",
 *                 "/aws/logGroup2")
 *             .queryString("""
 * fields @timestamp, @message
 * | sort @timestamp desc
 * | limit 25
 *             """)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:cloudwatch:QueryDefinition
 *     properties:
 *       name: custom_query
 *       logGroupNames:
 *         - /aws/logGroup1
 *         - /aws/logGroup2
 *       queryString: |
 *         fields @timestamp, @message
 *         | sort @timestamp desc
 *         | limit 25
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import CloudWatch query definitions using the query definition ARN. The ARN can be found on the "Edit Query" page for the query in the AWS Console. For example:
 * ```sh
 * $ pulumi import aws:cloudwatch/queryDefinition:QueryDefinition example arn:aws:logs:us-west-2:123456789012:query-definition:269951d7-6f75-496d-9d7b-6b7a5486bdbd
 * ```
 * @property logGroupNames Specific log groups to use with the query.
 * @property name The name of the query.
 * @property queryString The query to save. You can read more about CloudWatch Logs Query Syntax in the [documentation](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CWL_QuerySyntax.html).
 */
public data class QueryDefinitionArgs(
    public val logGroupNames: Output<List<String>>? = null,
    public val name: Output<String>? = null,
    public val queryString: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.cloudwatch.QueryDefinitionArgs> {
    override fun toJava(): com.pulumi.aws.cloudwatch.QueryDefinitionArgs =
        com.pulumi.aws.cloudwatch.QueryDefinitionArgs.builder()
            .logGroupNames(logGroupNames?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .name(name?.applyValue({ args0 -> args0 }))
            .queryString(queryString?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [QueryDefinitionArgs].
 */
@PulumiTagMarker
public class QueryDefinitionArgsBuilder internal constructor() {
    private var logGroupNames: Output<List<String>>? = null

    private var name: Output<String>? = null

    private var queryString: Output<String>? = null

    /**
     * @param value Specific log groups to use with the query.
     */
    @JvmName("ejusaaaautmenavp")
    public suspend fun logGroupNames(`value`: Output<List<String>>) {
        this.logGroupNames = value
    }

    @JvmName("ksipnbbowumranwf")
    public suspend fun logGroupNames(vararg values: Output<String>) {
        this.logGroupNames = Output.all(values.asList())
    }

    /**
     * @param values Specific log groups to use with the query.
     */
    @JvmName("fxwrjuwxiohnvwgd")
    public suspend fun logGroupNames(values: List<Output<String>>) {
        this.logGroupNames = Output.all(values)
    }

    /**
     * @param value The name of the query.
     */
    @JvmName("yfgdwqaqmfgsivqg")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The query to save. You can read more about CloudWatch Logs Query Syntax in the [documentation](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CWL_QuerySyntax.html).
     */
    @JvmName("mxrmkofegduindwt")
    public suspend fun queryString(`value`: Output<String>) {
        this.queryString = value
    }

    /**
     * @param value Specific log groups to use with the query.
     */
    @JvmName("pnxbwhhvonbwoqyq")
    public suspend fun logGroupNames(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logGroupNames = mapped
    }

    /**
     * @param values Specific log groups to use with the query.
     */
    @JvmName("twpdcyarmmcnucbx")
    public suspend fun logGroupNames(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.logGroupNames = mapped
    }

    /**
     * @param value The name of the query.
     */
    @JvmName("wcmmudguhbsusbjs")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The query to save. You can read more about CloudWatch Logs Query Syntax in the [documentation](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CWL_QuerySyntax.html).
     */
    @JvmName("cduqfdvvgigsqpkp")
    public suspend fun queryString(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.queryString = mapped
    }

    internal fun build(): QueryDefinitionArgs = QueryDefinitionArgs(
        logGroupNames = logGroupNames,
        name = name,
        queryString = queryString,
    )
}
