@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudwatch.kotlin.inputs

import com.pulumi.aws.cloudwatch.inputs.CompositeAlarmActionsSuppressorArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property alarm Can be an AlarmName or an Amazon Resource Name (ARN) from an existing alarm.
 * @property extensionPeriod The maximum time in seconds that the composite alarm waits after suppressor alarm goes out of the `ALARM` state. After this time, the composite alarm performs its actions.
 * @property waitPeriod The maximum time in seconds that the composite alarm waits for the suppressor alarm to go into the `ALARM` state. After this time, the composite alarm performs its actions.
 */
public data class CompositeAlarmActionsSuppressorArgs(
    public val alarm: Output<String>,
    public val extensionPeriod: Output<Int>,
    public val waitPeriod: Output<Int>,
) : ConvertibleToJava<com.pulumi.aws.cloudwatch.inputs.CompositeAlarmActionsSuppressorArgs> {
    override fun toJava(): com.pulumi.aws.cloudwatch.inputs.CompositeAlarmActionsSuppressorArgs =
        com.pulumi.aws.cloudwatch.inputs.CompositeAlarmActionsSuppressorArgs.builder()
            .alarm(alarm.applyValue({ args0 -> args0 }))
            .extensionPeriod(extensionPeriod.applyValue({ args0 -> args0 }))
            .waitPeriod(waitPeriod.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CompositeAlarmActionsSuppressorArgs].
 */
@PulumiTagMarker
public class CompositeAlarmActionsSuppressorArgsBuilder internal constructor() {
    private var alarm: Output<String>? = null

    private var extensionPeriod: Output<Int>? = null

    private var waitPeriod: Output<Int>? = null

    /**
     * @param value Can be an AlarmName or an Amazon Resource Name (ARN) from an existing alarm.
     */
    @JvmName("okiwnqijvxcswkec")
    public suspend fun alarm(`value`: Output<String>) {
        this.alarm = value
    }

    /**
     * @param value The maximum time in seconds that the composite alarm waits after suppressor alarm goes out of the `ALARM` state. After this time, the composite alarm performs its actions.
     */
    @JvmName("eqqcsdagpxuvyupb")
    public suspend fun extensionPeriod(`value`: Output<Int>) {
        this.extensionPeriod = value
    }

    /**
     * @param value The maximum time in seconds that the composite alarm waits for the suppressor alarm to go into the `ALARM` state. After this time, the composite alarm performs its actions.
     */
    @JvmName("meihqlsxsuwjuiko")
    public suspend fun waitPeriod(`value`: Output<Int>) {
        this.waitPeriod = value
    }

    /**
     * @param value Can be an AlarmName or an Amazon Resource Name (ARN) from an existing alarm.
     */
    @JvmName("tohuhduetplqdepm")
    public suspend fun alarm(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.alarm = mapped
    }

    /**
     * @param value The maximum time in seconds that the composite alarm waits after suppressor alarm goes out of the `ALARM` state. After this time, the composite alarm performs its actions.
     */
    @JvmName("gfyojkcdannhaoqs")
    public suspend fun extensionPeriod(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.extensionPeriod = mapped
    }

    /**
     * @param value The maximum time in seconds that the composite alarm waits for the suppressor alarm to go into the `ALARM` state. After this time, the composite alarm performs its actions.
     */
    @JvmName("evgoogflakenoeti")
    public suspend fun waitPeriod(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.waitPeriod = mapped
    }

    internal fun build(): CompositeAlarmActionsSuppressorArgs = CompositeAlarmActionsSuppressorArgs(
        alarm = alarm ?: throw PulumiNullFieldException("alarm"),
        extensionPeriod = extensionPeriod ?: throw PulumiNullFieldException("extensionPeriod"),
        waitPeriod = waitPeriod ?: throw PulumiNullFieldException("waitPeriod"),
    )
}
