@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudwatch.kotlin.inputs

import com.pulumi.aws.cloudwatch.inputs.EventConnectionAuthParametersApiKeyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property key Header Name.
 * @property value Header Value. Created and stored in AWS Secrets Manager.
 */
public data class EventConnectionAuthParametersApiKeyArgs(
    public val key: Output<String>,
    public val `value`: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.cloudwatch.inputs.EventConnectionAuthParametersApiKeyArgs> {
    override fun toJava(): com.pulumi.aws.cloudwatch.inputs.EventConnectionAuthParametersApiKeyArgs =
        com.pulumi.aws.cloudwatch.inputs.EventConnectionAuthParametersApiKeyArgs.builder()
            .key(key.applyValue({ args0 -> args0 }))
            .`value`(`value`.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EventConnectionAuthParametersApiKeyArgs].
 */
@PulumiTagMarker
public class EventConnectionAuthParametersApiKeyArgsBuilder internal constructor() {
    private var key: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value Header Name.
     */
    @JvmName("hlbkfpbietwktgbv")
    public suspend fun key(`value`: Output<String>) {
        this.key = value
    }

    /**
     * @param value Header Value. Created and stored in AWS Secrets Manager.
     */
    @JvmName("tpusijvlthrshqlp")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value Header Name.
     */
    @JvmName("ncwkafgdsknfqtds")
    public suspend fun key(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.key = mapped
    }

    /**
     * @param value Header Value. Created and stored in AWS Secrets Manager.
     */
    @JvmName("vojomjoyaduayoow")
    public suspend fun `value`(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): EventConnectionAuthParametersApiKeyArgs =
        EventConnectionAuthParametersApiKeyArgs(
            key = key ?: throw PulumiNullFieldException("key"),
            `value` = `value` ?: throw PulumiNullFieldException("value"),
        )
}
