@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudwatch.kotlin.inputs

import com.pulumi.aws.cloudwatch.inputs.EventConnectionAuthParametersArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property apiKey Parameters used for API_KEY authorization. An API key to include in the header for each authentication request. A maximum of 1 are allowed. Conflicts with `basic` and `oauth`. Documented below.
 * @property basic Parameters used for BASIC authorization. A maximum of 1 are allowed. Conflicts with `api_key` and `oauth`. Documented below.
 * @property invocationHttpParameters Invocation Http Parameters are additional credentials used to sign each Invocation of the ApiDestination created from this Connection. If the ApiDestination Rule Target has additional HttpParameters, the values will be merged together, with the Connection Invocation Http Parameters taking precedence. Secret values are stored and managed by AWS Secrets Manager. A maximum of 1 are allowed. Documented below.
 * @property oauth Parameters used for OAUTH_CLIENT_CREDENTIALS authorization. A maximum of 1 are allowed. Conflicts with `basic` and `api_key`. Documented below.
 */
public data class EventConnectionAuthParametersArgs(
    public val apiKey: Output<EventConnectionAuthParametersApiKeyArgs>? = null,
    public val basic: Output<EventConnectionAuthParametersBasicArgs>? = null,
    public val invocationHttpParameters: Output<EventConnectionAuthParametersInvocationHttpParametersArgs>? = null,
    public val oauth: Output<EventConnectionAuthParametersOauthArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.cloudwatch.inputs.EventConnectionAuthParametersArgs> {
    override fun toJava(): com.pulumi.aws.cloudwatch.inputs.EventConnectionAuthParametersArgs =
        com.pulumi.aws.cloudwatch.inputs.EventConnectionAuthParametersArgs.builder()
            .apiKey(apiKey?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .basic(basic?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .invocationHttpParameters(
                invocationHttpParameters?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .oauth(oauth?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [EventConnectionAuthParametersArgs].
 */
@PulumiTagMarker
public class EventConnectionAuthParametersArgsBuilder internal constructor() {
    private var apiKey: Output<EventConnectionAuthParametersApiKeyArgs>? = null

    private var basic: Output<EventConnectionAuthParametersBasicArgs>? = null

    private var invocationHttpParameters:
        Output<EventConnectionAuthParametersInvocationHttpParametersArgs>? = null

    private var oauth: Output<EventConnectionAuthParametersOauthArgs>? = null

    /**
     * @param value Parameters used for API_KEY authorization. An API key to include in the header for each authentication request. A maximum of 1 are allowed. Conflicts with `basic` and `oauth`. Documented below.
     */
    @JvmName("kkfgayqqgqgmirkd")
    public suspend fun apiKey(`value`: Output<EventConnectionAuthParametersApiKeyArgs>) {
        this.apiKey = value
    }

    /**
     * @param value Parameters used for BASIC authorization. A maximum of 1 are allowed. Conflicts with `api_key` and `oauth`. Documented below.
     */
    @JvmName("ubmwnuvfvpngsdak")
    public suspend fun basic(`value`: Output<EventConnectionAuthParametersBasicArgs>) {
        this.basic = value
    }

    /**
     * @param value Invocation Http Parameters are additional credentials used to sign each Invocation of the ApiDestination created from this Connection. If the ApiDestination Rule Target has additional HttpParameters, the values will be merged together, with the Connection Invocation Http Parameters taking precedence. Secret values are stored and managed by AWS Secrets Manager. A maximum of 1 are allowed. Documented below.
     */
    @JvmName("enqsxqrchftqydjp")
    public suspend fun invocationHttpParameters(`value`: Output<EventConnectionAuthParametersInvocationHttpParametersArgs>) {
        this.invocationHttpParameters = value
    }

    /**
     * @param value Parameters used for OAUTH_CLIENT_CREDENTIALS authorization. A maximum of 1 are allowed. Conflicts with `basic` and `api_key`. Documented below.
     */
    @JvmName("mqiinqquoqtohjgj")
    public suspend fun oauth(`value`: Output<EventConnectionAuthParametersOauthArgs>) {
        this.oauth = value
    }

    /**
     * @param value Parameters used for API_KEY authorization. An API key to include in the header for each authentication request. A maximum of 1 are allowed. Conflicts with `basic` and `oauth`. Documented below.
     */
    @JvmName("yuixujfofixulmtv")
    public suspend fun apiKey(`value`: EventConnectionAuthParametersApiKeyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.apiKey = mapped
    }

    /**
     * @param argument Parameters used for API_KEY authorization. An API key to include in the header for each authentication request. A maximum of 1 are allowed. Conflicts with `basic` and `oauth`. Documented below.
     */
    @JvmName("glwmrdixdcragxhh")
    public suspend fun apiKey(argument: suspend EventConnectionAuthParametersApiKeyArgsBuilder.() -> Unit) {
        val toBeMapped = EventConnectionAuthParametersApiKeyArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.apiKey = mapped
    }

    /**
     * @param value Parameters used for BASIC authorization. A maximum of 1 are allowed. Conflicts with `api_key` and `oauth`. Documented below.
     */
    @JvmName("xqkosasgemirmlat")
    public suspend fun basic(`value`: EventConnectionAuthParametersBasicArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.basic = mapped
    }

    /**
     * @param argument Parameters used for BASIC authorization. A maximum of 1 are allowed. Conflicts with `api_key` and `oauth`. Documented below.
     */
    @JvmName("jerqikaalvjdhjog")
    public suspend fun basic(argument: suspend EventConnectionAuthParametersBasicArgsBuilder.() -> Unit) {
        val toBeMapped = EventConnectionAuthParametersBasicArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.basic = mapped
    }

    /**
     * @param value Invocation Http Parameters are additional credentials used to sign each Invocation of the ApiDestination created from this Connection. If the ApiDestination Rule Target has additional HttpParameters, the values will be merged together, with the Connection Invocation Http Parameters taking precedence. Secret values are stored and managed by AWS Secrets Manager. A maximum of 1 are allowed. Documented below.
     */
    @JvmName("nodcbaakltqxeiqy")
    public suspend fun invocationHttpParameters(`value`: EventConnectionAuthParametersInvocationHttpParametersArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.invocationHttpParameters = mapped
    }

    /**
     * @param argument Invocation Http Parameters are additional credentials used to sign each Invocation of the ApiDestination created from this Connection. If the ApiDestination Rule Target has additional HttpParameters, the values will be merged together, with the Connection Invocation Http Parameters taking precedence. Secret values are stored and managed by AWS Secrets Manager. A maximum of 1 are allowed. Documented below.
     */
    @JvmName("ivcijwfadfpnwtfi")
    public suspend fun invocationHttpParameters(argument: suspend EventConnectionAuthParametersInvocationHttpParametersArgsBuilder.() -> Unit) {
        val toBeMapped =
            EventConnectionAuthParametersInvocationHttpParametersArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.invocationHttpParameters = mapped
    }

    /**
     * @param value Parameters used for OAUTH_CLIENT_CREDENTIALS authorization. A maximum of 1 are allowed. Conflicts with `basic` and `api_key`. Documented below.
     */
    @JvmName("kubyivlexxuykosp")
    public suspend fun oauth(`value`: EventConnectionAuthParametersOauthArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.oauth = mapped
    }

    /**
     * @param argument Parameters used for OAUTH_CLIENT_CREDENTIALS authorization. A maximum of 1 are allowed. Conflicts with `basic` and `api_key`. Documented below.
     */
    @JvmName("cynlostfrvisrjqe")
    public suspend fun oauth(argument: suspend EventConnectionAuthParametersOauthArgsBuilder.() -> Unit) {
        val toBeMapped = EventConnectionAuthParametersOauthArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.oauth = mapped
    }

    internal fun build(): EventConnectionAuthParametersArgs = EventConnectionAuthParametersArgs(
        apiKey = apiKey,
        basic = basic,
        invocationHttpParameters = invocationHttpParameters,
        oauth = oauth,
    )
}
