@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudwatch.kotlin.inputs

import com.pulumi.aws.cloudwatch.inputs.EventConnectionAuthParametersBasicArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property password A password for the authorization. Created and stored in AWS Secrets Manager.
 * @property username A username for the authorization.
 */
public data class EventConnectionAuthParametersBasicArgs(
    public val password: Output<String>,
    public val username: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.cloudwatch.inputs.EventConnectionAuthParametersBasicArgs> {
    override fun toJava(): com.pulumi.aws.cloudwatch.inputs.EventConnectionAuthParametersBasicArgs =
        com.pulumi.aws.cloudwatch.inputs.EventConnectionAuthParametersBasicArgs.builder()
            .password(password.applyValue({ args0 -> args0 }))
            .username(username.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EventConnectionAuthParametersBasicArgs].
 */
@PulumiTagMarker
public class EventConnectionAuthParametersBasicArgsBuilder internal constructor() {
    private var password: Output<String>? = null

    private var username: Output<String>? = null

    /**
     * @param value A password for the authorization. Created and stored in AWS Secrets Manager.
     */
    @JvmName("jfadpdxmckivnbej")
    public suspend fun password(`value`: Output<String>) {
        this.password = value
    }

    /**
     * @param value A username for the authorization.
     */
    @JvmName("mwlcwtukjlmxkjqh")
    public suspend fun username(`value`: Output<String>) {
        this.username = value
    }

    /**
     * @param value A password for the authorization. Created and stored in AWS Secrets Manager.
     */
    @JvmName("mhyycrkgcnmwhgxs")
    public suspend fun password(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value A username for the authorization.
     */
    @JvmName("stwqmwwdidylliii")
    public suspend fun username(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.username = mapped
    }

    internal fun build(): EventConnectionAuthParametersBasicArgs =
        EventConnectionAuthParametersBasicArgs(
            password = password ?: throw PulumiNullFieldException("password"),
            username = username ?: throw PulumiNullFieldException("username"),
        )
}
