@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudwatch.kotlin.inputs

import com.pulumi.aws.cloudwatch.inputs.EventConnectionAuthParametersInvocationHttpParametersArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property bodies Contains additional body string parameters for the connection. You can include up to 100 additional body string parameters per request. Each additional parameter counts towards the event payload size, which cannot exceed 64 KB. Each parameter can contain the following:
 * @property headers Contains additional header parameters for the connection. You can include up to 100 additional body string parameters per request. Each additional parameter counts towards the event payload size, which cannot exceed 64 KB. Each parameter can contain the following:
 * @property queryStrings Contains additional query string parameters for the connection. You can include up to 100 additional body string parameters per request. Each additional parameter counts towards the event payload size, which cannot exceed 64 KB. Each parameter can contain the following:
 */
public data class EventConnectionAuthParametersInvocationHttpParametersArgs(
    public val bodies: Output<List<EventConnectionAuthParametersInvocationHttpParametersBodyArgs>>? =
        null,
    public val headers: Output<List<EventConnectionAuthParametersInvocationHttpParametersHeaderArgs>>? =
        null,
    public val queryStrings: Output<List<EventConnectionAuthParametersInvocationHttpParametersQueryStringArgs>>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.cloudwatch.inputs.EventConnectionAuthParametersInvocationHttpParametersArgs> {
    override fun toJava(): com.pulumi.aws.cloudwatch.inputs.EventConnectionAuthParametersInvocationHttpParametersArgs =
        com.pulumi.aws.cloudwatch.inputs.EventConnectionAuthParametersInvocationHttpParametersArgs.builder()
            .bodies(bodies?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .headers(
                headers?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .queryStrings(
                queryStrings?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [EventConnectionAuthParametersInvocationHttpParametersArgs].
 */
@PulumiTagMarker
public class EventConnectionAuthParametersInvocationHttpParametersArgsBuilder internal constructor() {
    private var bodies: Output<List<EventConnectionAuthParametersInvocationHttpParametersBodyArgs>>? =
        null

    private var headers:
        Output<List<EventConnectionAuthParametersInvocationHttpParametersHeaderArgs>>? = null

    private var queryStrings:
        Output<List<EventConnectionAuthParametersInvocationHttpParametersQueryStringArgs>>? = null

    /**
     * @param value Contains additional body string parameters for the connection. You can include up to 100 additional body string parameters per request. Each additional parameter counts towards the event payload size, which cannot exceed 64 KB. Each parameter can contain the following:
     */
    @JvmName("aybrjvfdbycxlxqq")
    public suspend fun bodies(`value`: Output<List<EventConnectionAuthParametersInvocationHttpParametersBodyArgs>>) {
        this.bodies = value
    }

    @JvmName("ogrfgiekxqniujpt")
    public suspend fun bodies(vararg values: Output<EventConnectionAuthParametersInvocationHttpParametersBodyArgs>) {
        this.bodies = Output.all(values.asList())
    }

    /**
     * @param values Contains additional body string parameters for the connection. You can include up to 100 additional body string parameters per request. Each additional parameter counts towards the event payload size, which cannot exceed 64 KB. Each parameter can contain the following:
     */
    @JvmName("rtexcojpshmwtyuu")
    public suspend fun bodies(values: List<Output<EventConnectionAuthParametersInvocationHttpParametersBodyArgs>>) {
        this.bodies = Output.all(values)
    }

    /**
     * @param value Contains additional header parameters for the connection. You can include up to 100 additional body string parameters per request. Each additional parameter counts towards the event payload size, which cannot exceed 64 KB. Each parameter can contain the following:
     */
    @JvmName("caddjetggriqgvbp")
    public suspend fun headers(`value`: Output<List<EventConnectionAuthParametersInvocationHttpParametersHeaderArgs>>) {
        this.headers = value
    }

    @JvmName("bfbyslroqrcarjym")
    public suspend fun headers(vararg values: Output<EventConnectionAuthParametersInvocationHttpParametersHeaderArgs>) {
        this.headers = Output.all(values.asList())
    }

    /**
     * @param values Contains additional header parameters for the connection. You can include up to 100 additional body string parameters per request. Each additional parameter counts towards the event payload size, which cannot exceed 64 KB. Each parameter can contain the following:
     */
    @JvmName("lupafwgottwukqet")
    public suspend fun headers(values: List<Output<EventConnectionAuthParametersInvocationHttpParametersHeaderArgs>>) {
        this.headers = Output.all(values)
    }

    /**
     * @param value Contains additional query string parameters for the connection. You can include up to 100 additional body string parameters per request. Each additional parameter counts towards the event payload size, which cannot exceed 64 KB. Each parameter can contain the following:
     */
    @JvmName("wqkitdpsinmckiyg")
    public suspend fun queryStrings(`value`: Output<List<EventConnectionAuthParametersInvocationHttpParametersQueryStringArgs>>) {
        this.queryStrings = value
    }

    @JvmName("pktxlacaxuteuklb")
    public suspend fun queryStrings(vararg values: Output<EventConnectionAuthParametersInvocationHttpParametersQueryStringArgs>) {
        this.queryStrings = Output.all(values.asList())
    }

    /**
     * @param values Contains additional query string parameters for the connection. You can include up to 100 additional body string parameters per request. Each additional parameter counts towards the event payload size, which cannot exceed 64 KB. Each parameter can contain the following:
     */
    @JvmName("khokcclqordpovsg")
    public suspend fun queryStrings(values: List<Output<EventConnectionAuthParametersInvocationHttpParametersQueryStringArgs>>) {
        this.queryStrings = Output.all(values)
    }

    /**
     * @param value Contains additional body string parameters for the connection. You can include up to 100 additional body string parameters per request. Each additional parameter counts towards the event payload size, which cannot exceed 64 KB. Each parameter can contain the following:
     */
    @JvmName("aoulmegnugoydayv")
    public suspend fun bodies(`value`: List<EventConnectionAuthParametersInvocationHttpParametersBodyArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bodies = mapped
    }

    /**
     * @param argument Contains additional body string parameters for the connection. You can include up to 100 additional body string parameters per request. Each additional parameter counts towards the event payload size, which cannot exceed 64 KB. Each parameter can contain the following:
     */
    @JvmName("caxykguwilojytkx")
    public suspend fun bodies(argument: List<suspend EventConnectionAuthParametersInvocationHttpParametersBodyArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            EventConnectionAuthParametersInvocationHttpParametersBodyArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.bodies = mapped
    }

    /**
     * @param argument Contains additional body string parameters for the connection. You can include up to 100 additional body string parameters per request. Each additional parameter counts towards the event payload size, which cannot exceed 64 KB. Each parameter can contain the following:
     */
    @JvmName("tqywipfqmwapugjq")
    public suspend fun bodies(vararg argument: suspend EventConnectionAuthParametersInvocationHttpParametersBodyArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            EventConnectionAuthParametersInvocationHttpParametersBodyArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.bodies = mapped
    }

    /**
     * @param argument Contains additional body string parameters for the connection. You can include up to 100 additional body string parameters per request. Each additional parameter counts towards the event payload size, which cannot exceed 64 KB. Each parameter can contain the following:
     */
    @JvmName("jurquogbobytdrns")
    public suspend fun bodies(argument: suspend EventConnectionAuthParametersInvocationHttpParametersBodyArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                EventConnectionAuthParametersInvocationHttpParametersBodyArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.bodies = mapped
    }

    /**
     * @param values Contains additional body string parameters for the connection. You can include up to 100 additional body string parameters per request. Each additional parameter counts towards the event payload size, which cannot exceed 64 KB. Each parameter can contain the following:
     */
    @JvmName("rwwwbmmipvftvgsp")
    public suspend fun bodies(vararg values: EventConnectionAuthParametersInvocationHttpParametersBodyArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.bodies = mapped
    }

    /**
     * @param value Contains additional header parameters for the connection. You can include up to 100 additional body string parameters per request. Each additional parameter counts towards the event payload size, which cannot exceed 64 KB. Each parameter can contain the following:
     */
    @JvmName("quysqwxxxodelkhj")
    public suspend fun headers(`value`: List<EventConnectionAuthParametersInvocationHttpParametersHeaderArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.headers = mapped
    }

    /**
     * @param argument Contains additional header parameters for the connection. You can include up to 100 additional body string parameters per request. Each additional parameter counts towards the event payload size, which cannot exceed 64 KB. Each parameter can contain the following:
     */
    @JvmName("gcrunkfwhwykbgcj")
    public suspend fun headers(argument: List<suspend EventConnectionAuthParametersInvocationHttpParametersHeaderArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            EventConnectionAuthParametersInvocationHttpParametersHeaderArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.headers = mapped
    }

    /**
     * @param argument Contains additional header parameters for the connection. You can include up to 100 additional body string parameters per request. Each additional parameter counts towards the event payload size, which cannot exceed 64 KB. Each parameter can contain the following:
     */
    @JvmName("yoyierptewamgfpl")
    public suspend fun headers(vararg argument: suspend EventConnectionAuthParametersInvocationHttpParametersHeaderArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            EventConnectionAuthParametersInvocationHttpParametersHeaderArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.headers = mapped
    }

    /**
     * @param argument Contains additional header parameters for the connection. You can include up to 100 additional body string parameters per request. Each additional parameter counts towards the event payload size, which cannot exceed 64 KB. Each parameter can contain the following:
     */
    @JvmName("cksdqtbxnktgujbf")
    public suspend fun headers(argument: suspend EventConnectionAuthParametersInvocationHttpParametersHeaderArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                EventConnectionAuthParametersInvocationHttpParametersHeaderArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.headers = mapped
    }

    /**
     * @param values Contains additional header parameters for the connection. You can include up to 100 additional body string parameters per request. Each additional parameter counts towards the event payload size, which cannot exceed 64 KB. Each parameter can contain the following:
     */
    @JvmName("pwkxifsmlfnbggbk")
    public suspend fun headers(vararg values: EventConnectionAuthParametersInvocationHttpParametersHeaderArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.headers = mapped
    }

    /**
     * @param value Contains additional query string parameters for the connection. You can include up to 100 additional body string parameters per request. Each additional parameter counts towards the event payload size, which cannot exceed 64 KB. Each parameter can contain the following:
     */
    @JvmName("cxncdhnuncqepvdy")
    public suspend fun queryStrings(`value`: List<EventConnectionAuthParametersInvocationHttpParametersQueryStringArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.queryStrings = mapped
    }

    /**
     * @param argument Contains additional query string parameters for the connection. You can include up to 100 additional body string parameters per request. Each additional parameter counts towards the event payload size, which cannot exceed 64 KB. Each parameter can contain the following:
     */
    @JvmName("thclyylmurmctwoj")
    public suspend fun queryStrings(argument: List<suspend EventConnectionAuthParametersInvocationHttpParametersQueryStringArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            EventConnectionAuthParametersInvocationHttpParametersQueryStringArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.queryStrings = mapped
    }

    /**
     * @param argument Contains additional query string parameters for the connection. You can include up to 100 additional body string parameters per request. Each additional parameter counts towards the event payload size, which cannot exceed 64 KB. Each parameter can contain the following:
     */
    @JvmName("gubdhihihjqamnou")
    public suspend fun queryStrings(vararg argument: suspend EventConnectionAuthParametersInvocationHttpParametersQueryStringArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            EventConnectionAuthParametersInvocationHttpParametersQueryStringArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.queryStrings = mapped
    }

    /**
     * @param argument Contains additional query string parameters for the connection. You can include up to 100 additional body string parameters per request. Each additional parameter counts towards the event payload size, which cannot exceed 64 KB. Each parameter can contain the following:
     */
    @JvmName("cquswjxffwpqojtw")
    public suspend fun queryStrings(argument: suspend EventConnectionAuthParametersInvocationHttpParametersQueryStringArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                EventConnectionAuthParametersInvocationHttpParametersQueryStringArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.queryStrings = mapped
    }

    /**
     * @param values Contains additional query string parameters for the connection. You can include up to 100 additional body string parameters per request. Each additional parameter counts towards the event payload size, which cannot exceed 64 KB. Each parameter can contain the following:
     */
    @JvmName("wxcghngalbkdgcxw")
    public suspend fun queryStrings(vararg values: EventConnectionAuthParametersInvocationHttpParametersQueryStringArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.queryStrings = mapped
    }

    internal fun build(): EventConnectionAuthParametersInvocationHttpParametersArgs =
        EventConnectionAuthParametersInvocationHttpParametersArgs(
            bodies = bodies,
            headers = headers,
            queryStrings = queryStrings,
        )
}
