@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudwatch.kotlin.inputs

import com.pulumi.aws.cloudwatch.inputs.EventConnectionAuthParametersInvocationHttpParametersQueryStringArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property isValueSecret Specified whether the value is secret.
 * @property key The key for the parameter.
 * @property value The value associated with the key. Created and stored in AWS Secrets Manager if is secret.
 */
public data class EventConnectionAuthParametersInvocationHttpParametersQueryStringArgs(
    public val isValueSecret: Output<Boolean>? = null,
    public val key: Output<String>? = null,
    public val `value`: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.cloudwatch.inputs.EventConnectionAuthParametersInvocationHttpParametersQueryStringArgs> {
    override fun toJava(): com.pulumi.aws.cloudwatch.inputs.EventConnectionAuthParametersInvocationHttpParametersQueryStringArgs =
        com.pulumi.aws.cloudwatch.inputs.EventConnectionAuthParametersInvocationHttpParametersQueryStringArgs.builder()
            .isValueSecret(isValueSecret?.applyValue({ args0 -> args0 }))
            .key(key?.applyValue({ args0 -> args0 }))
            .`value`(`value`?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EventConnectionAuthParametersInvocationHttpParametersQueryStringArgs].
 */
@PulumiTagMarker
public class EventConnectionAuthParametersInvocationHttpParametersQueryStringArgsBuilder internal constructor() {
    private var isValueSecret: Output<Boolean>? = null

    private var key: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value Specified whether the value is secret.
     */
    @JvmName("raqvjfocptjogjmt")
    public suspend fun isValueSecret(`value`: Output<Boolean>) {
        this.isValueSecret = value
    }

    /**
     * @param value The key for the parameter.
     */
    @JvmName("euexuvxhvipynwdj")
    public suspend fun key(`value`: Output<String>) {
        this.key = value
    }

    /**
     * @param value The value associated with the key. Created and stored in AWS Secrets Manager if is secret.
     */
    @JvmName("ljbjnxxturtlqeoq")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value Specified whether the value is secret.
     */
    @JvmName("afxhoruehajmrdii")
    public suspend fun isValueSecret(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isValueSecret = mapped
    }

    /**
     * @param value The key for the parameter.
     */
    @JvmName("jedhfbcvyvwrlfho")
    public suspend fun key(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.key = mapped
    }

    /**
     * @param value The value associated with the key. Created and stored in AWS Secrets Manager if is secret.
     */
    @JvmName("xfqhprwcipbtfvyh")
    public suspend fun `value`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): EventConnectionAuthParametersInvocationHttpParametersQueryStringArgs =
        EventConnectionAuthParametersInvocationHttpParametersQueryStringArgs(
            isValueSecret = isValueSecret,
            key = key,
            `value` = `value`,
        )
}
