@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudwatch.kotlin.inputs

import com.pulumi.aws.cloudwatch.inputs.EventConnectionAuthParametersOauthClientParametersArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property clientId The client ID for the credentials to use for authorization. Created and stored in AWS Secrets Manager.
 * @property clientSecret The client secret for the credentials to use for authorization. Created and stored in AWS Secrets Manager.
 */
public data class EventConnectionAuthParametersOauthClientParametersArgs(
    public val clientId: Output<String>,
    public val clientSecret: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.cloudwatch.inputs.EventConnectionAuthParametersOauthClientParametersArgs> {
    override fun toJava(): com.pulumi.aws.cloudwatch.inputs.EventConnectionAuthParametersOauthClientParametersArgs =
        com.pulumi.aws.cloudwatch.inputs.EventConnectionAuthParametersOauthClientParametersArgs.builder()
            .clientId(clientId.applyValue({ args0 -> args0 }))
            .clientSecret(clientSecret.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EventConnectionAuthParametersOauthClientParametersArgs].
 */
@PulumiTagMarker
public class EventConnectionAuthParametersOauthClientParametersArgsBuilder internal constructor() {
    private var clientId: Output<String>? = null

    private var clientSecret: Output<String>? = null

    /**
     * @param value The client ID for the credentials to use for authorization. Created and stored in AWS Secrets Manager.
     */
    @JvmName("ukmawbsfyjvylxff")
    public suspend fun clientId(`value`: Output<String>) {
        this.clientId = value
    }

    /**
     * @param value The client secret for the credentials to use for authorization. Created and stored in AWS Secrets Manager.
     */
    @JvmName("hlnvwelerqtcxoex")
    public suspend fun clientSecret(`value`: Output<String>) {
        this.clientSecret = value
    }

    /**
     * @param value The client ID for the credentials to use for authorization. Created and stored in AWS Secrets Manager.
     */
    @JvmName("jhqysmlxpydaankm")
    public suspend fun clientId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.clientId = mapped
    }

    /**
     * @param value The client secret for the credentials to use for authorization. Created and stored in AWS Secrets Manager.
     */
    @JvmName("aqblrujochjajamv")
    public suspend fun clientSecret(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.clientSecret = mapped
    }

    internal fun build(): EventConnectionAuthParametersOauthClientParametersArgs =
        EventConnectionAuthParametersOauthClientParametersArgs(
            clientId = clientId ?: throw PulumiNullFieldException("clientId"),
            clientSecret = clientSecret ?: throw PulumiNullFieldException("clientSecret"),
        )
}
