@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudwatch.kotlin.inputs

import com.pulumi.aws.cloudwatch.inputs.EventConnectionAuthParametersOauthOauthHttpParametersBodyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property isValueSecret Specified whether the value is secret.
 * @property key The key for the parameter.
 * @property value The value associated with the key. Created and stored in AWS Secrets Manager if is secret.
 */
public data class EventConnectionAuthParametersOauthOauthHttpParametersBodyArgs(
    public val isValueSecret: Output<Boolean>? = null,
    public val key: Output<String>? = null,
    public val `value`: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.cloudwatch.inputs.EventConnectionAuthParametersOauthOauthHttpParametersBodyArgs> {
    override fun toJava(): com.pulumi.aws.cloudwatch.inputs.EventConnectionAuthParametersOauthOauthHttpParametersBodyArgs =
        com.pulumi.aws.cloudwatch.inputs.EventConnectionAuthParametersOauthOauthHttpParametersBodyArgs.builder()
            .isValueSecret(isValueSecret?.applyValue({ args0 -> args0 }))
            .key(key?.applyValue({ args0 -> args0 }))
            .`value`(`value`?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EventConnectionAuthParametersOauthOauthHttpParametersBodyArgs].
 */
@PulumiTagMarker
public class EventConnectionAuthParametersOauthOauthHttpParametersBodyArgsBuilder internal constructor() {
    private var isValueSecret: Output<Boolean>? = null

    private var key: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value Specified whether the value is secret.
     */
    @JvmName("xcfuolkmmlnfxymd")
    public suspend fun isValueSecret(`value`: Output<Boolean>) {
        this.isValueSecret = value
    }

    /**
     * @param value The key for the parameter.
     */
    @JvmName("crhwbjcdufwrfuum")
    public suspend fun key(`value`: Output<String>) {
        this.key = value
    }

    /**
     * @param value The value associated with the key. Created and stored in AWS Secrets Manager if is secret.
     */
    @JvmName("jsbmkglhjkyldigs")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value Specified whether the value is secret.
     */
    @JvmName("duikloiddriromcj")
    public suspend fun isValueSecret(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isValueSecret = mapped
    }

    /**
     * @param value The key for the parameter.
     */
    @JvmName("jiavknhqjydhiplj")
    public suspend fun key(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.key = mapped
    }

    /**
     * @param value The value associated with the key. Created and stored in AWS Secrets Manager if is secret.
     */
    @JvmName("rthvrtjorjbncnka")
    public suspend fun `value`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): EventConnectionAuthParametersOauthOauthHttpParametersBodyArgs =
        EventConnectionAuthParametersOauthOauthHttpParametersBodyArgs(
            isValueSecret = isValueSecret,
            key = key,
            `value` = `value`,
        )
}
