@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudwatch.kotlin.inputs

import com.pulumi.aws.cloudwatch.inputs.EventEndpointRoutingConfigFailoverConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property primary Parameters used for the primary Region. Documented below.
 * @property secondary Parameters used for the secondary Region, the Region that events are routed to when failover is triggered or event replication is enabled. Documented below.
 */
public data class EventEndpointRoutingConfigFailoverConfigArgs(
    public val primary: Output<EventEndpointRoutingConfigFailoverConfigPrimaryArgs>,
    public val secondary: Output<EventEndpointRoutingConfigFailoverConfigSecondaryArgs>,
) : ConvertibleToJava<com.pulumi.aws.cloudwatch.inputs.EventEndpointRoutingConfigFailoverConfigArgs> {
    override fun toJava(): com.pulumi.aws.cloudwatch.inputs.EventEndpointRoutingConfigFailoverConfigArgs =
        com.pulumi.aws.cloudwatch.inputs.EventEndpointRoutingConfigFailoverConfigArgs.builder()
            .primary(primary.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .secondary(secondary.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [EventEndpointRoutingConfigFailoverConfigArgs].
 */
@PulumiTagMarker
public class EventEndpointRoutingConfigFailoverConfigArgsBuilder internal constructor() {
    private var primary: Output<EventEndpointRoutingConfigFailoverConfigPrimaryArgs>? = null

    private var secondary: Output<EventEndpointRoutingConfigFailoverConfigSecondaryArgs>? = null

    /**
     * @param value Parameters used for the primary Region. Documented below.
     */
    @JvmName("qrkqorqwraasokeg")
    public suspend fun primary(`value`: Output<EventEndpointRoutingConfigFailoverConfigPrimaryArgs>) {
        this.primary = value
    }

    /**
     * @param value Parameters used for the secondary Region, the Region that events are routed to when failover is triggered or event replication is enabled. Documented below.
     */
    @JvmName("bbopwevuqgqcpejt")
    public suspend fun secondary(`value`: Output<EventEndpointRoutingConfigFailoverConfigSecondaryArgs>) {
        this.secondary = value
    }

    /**
     * @param value Parameters used for the primary Region. Documented below.
     */
    @JvmName("ggiwxotlopcrfmms")
    public suspend fun primary(`value`: EventEndpointRoutingConfigFailoverConfigPrimaryArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.primary = mapped
    }

    /**
     * @param argument Parameters used for the primary Region. Documented below.
     */
    @JvmName("ncxbvuppcjjsvklf")
    public suspend fun primary(argument: suspend EventEndpointRoutingConfigFailoverConfigPrimaryArgsBuilder.() -> Unit) {
        val toBeMapped = EventEndpointRoutingConfigFailoverConfigPrimaryArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.primary = mapped
    }

    /**
     * @param value Parameters used for the secondary Region, the Region that events are routed to when failover is triggered or event replication is enabled. Documented below.
     */
    @JvmName("shfprrjthtubsilv")
    public suspend fun secondary(`value`: EventEndpointRoutingConfigFailoverConfigSecondaryArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.secondary = mapped
    }

    /**
     * @param argument Parameters used for the secondary Region, the Region that events are routed to when failover is triggered or event replication is enabled. Documented below.
     */
    @JvmName("bgvqoispywqorcia")
    public suspend fun secondary(argument: suspend EventEndpointRoutingConfigFailoverConfigSecondaryArgsBuilder.() -> Unit) {
        val toBeMapped = EventEndpointRoutingConfigFailoverConfigSecondaryArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.secondary = mapped
    }

    internal fun build(): EventEndpointRoutingConfigFailoverConfigArgs =
        EventEndpointRoutingConfigFailoverConfigArgs(
            primary = primary ?: throw PulumiNullFieldException("primary"),
            secondary = secondary ?: throw PulumiNullFieldException("secondary"),
        )
}
