@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudwatch.kotlin.inputs

import com.pulumi.aws.cloudwatch.inputs.EventEndpointRoutingConfigFailoverConfigPrimaryArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property healthCheck The ARN of the health check used by the endpoint to determine whether failover is triggered.
 */
public data class EventEndpointRoutingConfigFailoverConfigPrimaryArgs(
    public val healthCheck: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.cloudwatch.inputs.EventEndpointRoutingConfigFailoverConfigPrimaryArgs> {
    override fun toJava(): com.pulumi.aws.cloudwatch.inputs.EventEndpointRoutingConfigFailoverConfigPrimaryArgs =
        com.pulumi.aws.cloudwatch.inputs.EventEndpointRoutingConfigFailoverConfigPrimaryArgs.builder()
            .healthCheck(healthCheck?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EventEndpointRoutingConfigFailoverConfigPrimaryArgs].
 */
@PulumiTagMarker
public class EventEndpointRoutingConfigFailoverConfigPrimaryArgsBuilder internal constructor() {
    private var healthCheck: Output<String>? = null

    /**
     * @param value The ARN of the health check used by the endpoint to determine whether failover is triggered.
     */
    @JvmName("qktyadlktkabgquv")
    public suspend fun healthCheck(`value`: Output<String>) {
        this.healthCheck = value
    }

    /**
     * @param value The ARN of the health check used by the endpoint to determine whether failover is triggered.
     */
    @JvmName("whgmpadrverkljjr")
    public suspend fun healthCheck(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.healthCheck = mapped
    }

    internal fun build(): EventEndpointRoutingConfigFailoverConfigPrimaryArgs =
        EventEndpointRoutingConfigFailoverConfigPrimaryArgs(
            healthCheck = healthCheck,
        )
}
