@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudwatch.kotlin.inputs

import com.pulumi.aws.cloudwatch.inputs.EventEndpointRoutingConfigFailoverConfigSecondaryArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property route The name of the secondary Region.
 */
public data class EventEndpointRoutingConfigFailoverConfigSecondaryArgs(
    public val route: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.cloudwatch.inputs.EventEndpointRoutingConfigFailoverConfigSecondaryArgs> {
    override fun toJava(): com.pulumi.aws.cloudwatch.inputs.EventEndpointRoutingConfigFailoverConfigSecondaryArgs =
        com.pulumi.aws.cloudwatch.inputs.EventEndpointRoutingConfigFailoverConfigSecondaryArgs.builder()
            .route(route?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EventEndpointRoutingConfigFailoverConfigSecondaryArgs].
 */
@PulumiTagMarker
public class EventEndpointRoutingConfigFailoverConfigSecondaryArgsBuilder internal constructor() {
    private var route: Output<String>? = null

    /**
     * @param value The name of the secondary Region.
     */
    @JvmName("gwqfrouldasryedg")
    public suspend fun route(`value`: Output<String>) {
        this.route = value
    }

    /**
     * @param value The name of the secondary Region.
     */
    @JvmName("wpcoowhmnfgxncab")
    public suspend fun route(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.route = mapped
    }

    internal fun build(): EventEndpointRoutingConfigFailoverConfigSecondaryArgs =
        EventEndpointRoutingConfigFailoverConfigSecondaryArgs(
            route = route,
        )
}
