@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudwatch.kotlin.inputs

import com.pulumi.aws.cloudwatch.inputs.EventPermissionConditionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property key Key for the condition. Valid values: `aws:PrincipalOrgID`.
 * @property type Type of condition. Value values: `StringEquals`.
 * @property value Value for the key.
 */
public data class EventPermissionConditionArgs(
    public val key: Output<String>,
    public val type: Output<String>,
    public val `value`: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.cloudwatch.inputs.EventPermissionConditionArgs> {
    override fun toJava(): com.pulumi.aws.cloudwatch.inputs.EventPermissionConditionArgs =
        com.pulumi.aws.cloudwatch.inputs.EventPermissionConditionArgs.builder()
            .key(key.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 }))
            .`value`(`value`.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EventPermissionConditionArgs].
 */
@PulumiTagMarker
public class EventPermissionConditionArgsBuilder internal constructor() {
    private var key: Output<String>? = null

    private var type: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value Key for the condition. Valid values: `aws:PrincipalOrgID`.
     */
    @JvmName("amjcwynmihfclffw")
    public suspend fun key(`value`: Output<String>) {
        this.key = value
    }

    /**
     * @param value Type of condition. Value values: `StringEquals`.
     */
    @JvmName("svorhpeajbxcgwru")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Value for the key.
     */
    @JvmName("tyrpsgmknaxoqxxb")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value Key for the condition. Valid values: `aws:PrincipalOrgID`.
     */
    @JvmName("rujbkaaucbpyapgd")
    public suspend fun key(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.key = mapped
    }

    /**
     * @param value Type of condition. Value values: `StringEquals`.
     */
    @JvmName("hjgswloxwdsasoii")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Value for the key.
     */
    @JvmName("lwnrrmwgbgwgyjrf")
    public suspend fun `value`(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): EventPermissionConditionArgs = EventPermissionConditionArgs(
        key = key ?: throw PulumiNullFieldException("key"),
        type = type ?: throw PulumiNullFieldException("type"),
        `value` = `value` ?: throw PulumiNullFieldException("value"),
    )
}
