@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudwatch.kotlin.inputs

import com.pulumi.aws.cloudwatch.inputs.EventTargetDeadLetterConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property arn ARN of the SQS queue specified as the target for the dead-letter queue.
 */
public data class EventTargetDeadLetterConfigArgs(
    public val arn: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.cloudwatch.inputs.EventTargetDeadLetterConfigArgs> {
    override fun toJava(): com.pulumi.aws.cloudwatch.inputs.EventTargetDeadLetterConfigArgs =
        com.pulumi.aws.cloudwatch.inputs.EventTargetDeadLetterConfigArgs.builder()
            .arn(arn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EventTargetDeadLetterConfigArgs].
 */
@PulumiTagMarker
public class EventTargetDeadLetterConfigArgsBuilder internal constructor() {
    private var arn: Output<String>? = null

    /**
     * @param value ARN of the SQS queue specified as the target for the dead-letter queue.
     */
    @JvmName("hatiopplvyusrdlq")
    public suspend fun arn(`value`: Output<String>) {
        this.arn = value
    }

    /**
     * @param value ARN of the SQS queue specified as the target for the dead-letter queue.
     */
    @JvmName("iavyinauvvnyturw")
    public suspend fun arn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.arn = mapped
    }

    internal fun build(): EventTargetDeadLetterConfigArgs = EventTargetDeadLetterConfigArgs(
        arn = arn,
    )
}
