@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudwatch.kotlin.inputs

import com.pulumi.aws.cloudwatch.inputs.EventTargetEcsTargetCapacityProviderStrategyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property base The base value designates how many tasks, at a minimum, to run on the specified capacity provider. Only one capacity provider in a capacity provider strategy can have a base defined. Defaults to `0`.
 * @property capacityProvider Short name of the capacity provider.
 * @property weight The weight value designates the relative percentage of the total number of tasks launched that should use the specified capacity provider. The weight value is taken into consideration after the base value, if defined, is satisfied.
 */
public data class EventTargetEcsTargetCapacityProviderStrategyArgs(
    public val base: Output<Int>? = null,
    public val capacityProvider: Output<String>,
    public val weight: Output<Int>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.cloudwatch.inputs.EventTargetEcsTargetCapacityProviderStrategyArgs> {
    override fun toJava(): com.pulumi.aws.cloudwatch.inputs.EventTargetEcsTargetCapacityProviderStrategyArgs =
        com.pulumi.aws.cloudwatch.inputs.EventTargetEcsTargetCapacityProviderStrategyArgs.builder()
            .base(base?.applyValue({ args0 -> args0 }))
            .capacityProvider(capacityProvider.applyValue({ args0 -> args0 }))
            .weight(weight?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EventTargetEcsTargetCapacityProviderStrategyArgs].
 */
@PulumiTagMarker
public class EventTargetEcsTargetCapacityProviderStrategyArgsBuilder internal constructor() {
    private var base: Output<Int>? = null

    private var capacityProvider: Output<String>? = null

    private var weight: Output<Int>? = null

    /**
     * @param value The base value designates how many tasks, at a minimum, to run on the specified capacity provider. Only one capacity provider in a capacity provider strategy can have a base defined. Defaults to `0`.
     */
    @JvmName("osjhcmcrutghhfks")
    public suspend fun base(`value`: Output<Int>) {
        this.base = value
    }

    /**
     * @param value Short name of the capacity provider.
     */
    @JvmName("crvpxfdhgwvyjhav")
    public suspend fun capacityProvider(`value`: Output<String>) {
        this.capacityProvider = value
    }

    /**
     * @param value The weight value designates the relative percentage of the total number of tasks launched that should use the specified capacity provider. The weight value is taken into consideration after the base value, if defined, is satisfied.
     */
    @JvmName("qvrswxyvmfgddfuu")
    public suspend fun weight(`value`: Output<Int>) {
        this.weight = value
    }

    /**
     * @param value The base value designates how many tasks, at a minimum, to run on the specified capacity provider. Only one capacity provider in a capacity provider strategy can have a base defined. Defaults to `0`.
     */
    @JvmName("olivqnkgjqhqebfk")
    public suspend fun base(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.base = mapped
    }

    /**
     * @param value Short name of the capacity provider.
     */
    @JvmName("cfgjynyfcugkrgko")
    public suspend fun capacityProvider(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.capacityProvider = mapped
    }

    /**
     * @param value The weight value designates the relative percentage of the total number of tasks launched that should use the specified capacity provider. The weight value is taken into consideration after the base value, if defined, is satisfied.
     */
    @JvmName("jhexovqbaugwfgnc")
    public suspend fun weight(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.weight = mapped
    }

    internal fun build(): EventTargetEcsTargetCapacityProviderStrategyArgs =
        EventTargetEcsTargetCapacityProviderStrategyArgs(
            base = base,
            capacityProvider = capacityProvider ?: throw PulumiNullFieldException("capacityProvider"),
            weight = weight,
        )
}
