@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudwatch.kotlin.inputs

import com.pulumi.aws.cloudwatch.inputs.EventTargetEcsTargetNetworkConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property assignPublicIp Assign a public IP address to the ENI (Fargate launch type only). Valid values are `true` or `false`. Defaults to `false`.
 * For more information, see [Task Networking](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-networking.html)
 * @property securityGroups The security groups associated with the task or service. If you do not specify a security group, the default security group for the VPC is used.
 * @property subnets The subnets associated with the task or service.
 */
public data class EventTargetEcsTargetNetworkConfigurationArgs(
    public val assignPublicIp: Output<Boolean>? = null,
    public val securityGroups: Output<List<String>>? = null,
    public val subnets: Output<List<String>>,
) : ConvertibleToJava<com.pulumi.aws.cloudwatch.inputs.EventTargetEcsTargetNetworkConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.cloudwatch.inputs.EventTargetEcsTargetNetworkConfigurationArgs =
        com.pulumi.aws.cloudwatch.inputs.EventTargetEcsTargetNetworkConfigurationArgs.builder()
            .assignPublicIp(assignPublicIp?.applyValue({ args0 -> args0 }))
            .securityGroups(securityGroups?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .subnets(subnets.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [EventTargetEcsTargetNetworkConfigurationArgs].
 */
@PulumiTagMarker
public class EventTargetEcsTargetNetworkConfigurationArgsBuilder internal constructor() {
    private var assignPublicIp: Output<Boolean>? = null

    private var securityGroups: Output<List<String>>? = null

    private var subnets: Output<List<String>>? = null

    /**
     * @param value Assign a public IP address to the ENI (Fargate launch type only). Valid values are `true` or `false`. Defaults to `false`.
     * For more information, see [Task Networking](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-networking.html)
     */
    @JvmName("rcxbdapimouywyve")
    public suspend fun assignPublicIp(`value`: Output<Boolean>) {
        this.assignPublicIp = value
    }

    /**
     * @param value The security groups associated with the task or service. If you do not specify a security group, the default security group for the VPC is used.
     */
    @JvmName("fjcloilstsupoudy")
    public suspend fun securityGroups(`value`: Output<List<String>>) {
        this.securityGroups = value
    }

    @JvmName("cbpalrcoejbxfyjw")
    public suspend fun securityGroups(vararg values: Output<String>) {
        this.securityGroups = Output.all(values.asList())
    }

    /**
     * @param values The security groups associated with the task or service. If you do not specify a security group, the default security group for the VPC is used.
     */
    @JvmName("jkrmswhirxvalnyp")
    public suspend fun securityGroups(values: List<Output<String>>) {
        this.securityGroups = Output.all(values)
    }

    /**
     * @param value The subnets associated with the task or service.
     */
    @JvmName("jixitmgbnhbwgrpe")
    public suspend fun subnets(`value`: Output<List<String>>) {
        this.subnets = value
    }

    @JvmName("swkhsdsenvbjreph")
    public suspend fun subnets(vararg values: Output<String>) {
        this.subnets = Output.all(values.asList())
    }

    /**
     * @param values The subnets associated with the task or service.
     */
    @JvmName("hstjxbgkdpvvobld")
    public suspend fun subnets(values: List<Output<String>>) {
        this.subnets = Output.all(values)
    }

    /**
     * @param value Assign a public IP address to the ENI (Fargate launch type only). Valid values are `true` or `false`. Defaults to `false`.
     * For more information, see [Task Networking](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-networking.html)
     */
    @JvmName("nbwvfhvnpqpprwxh")
    public suspend fun assignPublicIp(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.assignPublicIp = mapped
    }

    /**
     * @param value The security groups associated with the task or service. If you do not specify a security group, the default security group for the VPC is used.
     */
    @JvmName("unkmhahktbhtthsv")
    public suspend fun securityGroups(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityGroups = mapped
    }

    /**
     * @param values The security groups associated with the task or service. If you do not specify a security group, the default security group for the VPC is used.
     */
    @JvmName("tywxbunyfwjhsdpu")
    public suspend fun securityGroups(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityGroups = mapped
    }

    /**
     * @param value The subnets associated with the task or service.
     */
    @JvmName("yyvdigievquksvsi")
    public suspend fun subnets(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subnets = mapped
    }

    /**
     * @param values The subnets associated with the task or service.
     */
    @JvmName("lsbcrntmvdhiksqm")
    public suspend fun subnets(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subnets = mapped
    }

    internal fun build(): EventTargetEcsTargetNetworkConfigurationArgs =
        EventTargetEcsTargetNetworkConfigurationArgs(
            assignPublicIp = assignPublicIp,
            securityGroups = securityGroups,
            subnets = subnets ?: throw PulumiNullFieldException("subnets"),
        )
}
