@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudwatch.kotlin.inputs

import com.pulumi.aws.cloudwatch.inputs.EventTargetEcsTargetPlacementConstraintArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property expression Cluster Query Language expression to apply to the constraint. Does not need to be specified for the `distinctInstance` type. For more information, see [Cluster Query Language in the Amazon EC2 Container Service Developer Guide](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/cluster-query-language.html).
 * @property type Type of constraint. The only valid values at this time are `memberOf` and `distinctInstance`.
 */
public data class EventTargetEcsTargetPlacementConstraintArgs(
    public val expression: Output<String>? = null,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.cloudwatch.inputs.EventTargetEcsTargetPlacementConstraintArgs> {
    override fun toJava(): com.pulumi.aws.cloudwatch.inputs.EventTargetEcsTargetPlacementConstraintArgs =
        com.pulumi.aws.cloudwatch.inputs.EventTargetEcsTargetPlacementConstraintArgs.builder()
            .expression(expression?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EventTargetEcsTargetPlacementConstraintArgs].
 */
@PulumiTagMarker
public class EventTargetEcsTargetPlacementConstraintArgsBuilder internal constructor() {
    private var expression: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value Cluster Query Language expression to apply to the constraint. Does not need to be specified for the `distinctInstance` type. For more information, see [Cluster Query Language in the Amazon EC2 Container Service Developer Guide](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/cluster-query-language.html).
     */
    @JvmName("mmohxmopplrqglpr")
    public suspend fun expression(`value`: Output<String>) {
        this.expression = value
    }

    /**
     * @param value Type of constraint. The only valid values at this time are `memberOf` and `distinctInstance`.
     */
    @JvmName("fijasdrxeaarbsba")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Cluster Query Language expression to apply to the constraint. Does not need to be specified for the `distinctInstance` type. For more information, see [Cluster Query Language in the Amazon EC2 Container Service Developer Guide](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/cluster-query-language.html).
     */
    @JvmName("ktbbvlyljehfqosg")
    public suspend fun expression(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.expression = mapped
    }

    /**
     * @param value Type of constraint. The only valid values at this time are `memberOf` and `distinctInstance`.
     */
    @JvmName("glqyotwowilbhbrm")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): EventTargetEcsTargetPlacementConstraintArgs =
        EventTargetEcsTargetPlacementConstraintArgs(
            expression = expression,
            type = type ?: throw PulumiNullFieldException("type"),
        )
}
