@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudwatch.kotlin.inputs

import com.pulumi.aws.cloudwatch.inputs.EventTargetKinesisTargetArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property partitionKeyPath The JSON path to be extracted from the event and used as the partition key.
 */
public data class EventTargetKinesisTargetArgs(
    public val partitionKeyPath: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.cloudwatch.inputs.EventTargetKinesisTargetArgs> {
    override fun toJava(): com.pulumi.aws.cloudwatch.inputs.EventTargetKinesisTargetArgs =
        com.pulumi.aws.cloudwatch.inputs.EventTargetKinesisTargetArgs.builder()
            .partitionKeyPath(partitionKeyPath?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EventTargetKinesisTargetArgs].
 */
@PulumiTagMarker
public class EventTargetKinesisTargetArgsBuilder internal constructor() {
    private var partitionKeyPath: Output<String>? = null

    /**
     * @param value The JSON path to be extracted from the event and used as the partition key.
     */
    @JvmName("lgnqdbsjiqwgnsml")
    public suspend fun partitionKeyPath(`value`: Output<String>) {
        this.partitionKeyPath = value
    }

    /**
     * @param value The JSON path to be extracted from the event and used as the partition key.
     */
    @JvmName("hidccobojurcyfes")
    public suspend fun partitionKeyPath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.partitionKeyPath = mapped
    }

    internal fun build(): EventTargetKinesisTargetArgs = EventTargetKinesisTargetArgs(
        partitionKeyPath = partitionKeyPath,
    )
}
