@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudwatch.kotlin.inputs

import com.pulumi.aws.cloudwatch.inputs.EventTargetRedshiftTargetArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property database The name of the database.
 * @property dbUser The database user name.
 * @property secretsManagerArn The name or ARN of the secret that enables access to the database.
 * @property sql The SQL statement text to run.
 * @property statementName The name of the SQL statement.
 * @property withEvent Indicates whether to send an event back to EventBridge after the SQL statement runs.
 */
public data class EventTargetRedshiftTargetArgs(
    public val database: Output<String>,
    public val dbUser: Output<String>? = null,
    public val secretsManagerArn: Output<String>? = null,
    public val sql: Output<String>? = null,
    public val statementName: Output<String>? = null,
    public val withEvent: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.aws.cloudwatch.inputs.EventTargetRedshiftTargetArgs> {
    override fun toJava(): com.pulumi.aws.cloudwatch.inputs.EventTargetRedshiftTargetArgs =
        com.pulumi.aws.cloudwatch.inputs.EventTargetRedshiftTargetArgs.builder()
            .database(database.applyValue({ args0 -> args0 }))
            .dbUser(dbUser?.applyValue({ args0 -> args0 }))
            .secretsManagerArn(secretsManagerArn?.applyValue({ args0 -> args0 }))
            .sql(sql?.applyValue({ args0 -> args0 }))
            .statementName(statementName?.applyValue({ args0 -> args0 }))
            .withEvent(withEvent?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EventTargetRedshiftTargetArgs].
 */
@PulumiTagMarker
public class EventTargetRedshiftTargetArgsBuilder internal constructor() {
    private var database: Output<String>? = null

    private var dbUser: Output<String>? = null

    private var secretsManagerArn: Output<String>? = null

    private var sql: Output<String>? = null

    private var statementName: Output<String>? = null

    private var withEvent: Output<Boolean>? = null

    /**
     * @param value The name of the database.
     */
    @JvmName("naepkyubfuatiqsb")
    public suspend fun database(`value`: Output<String>) {
        this.database = value
    }

    /**
     * @param value The database user name.
     */
    @JvmName("uhuubitfkofuqgnk")
    public suspend fun dbUser(`value`: Output<String>) {
        this.dbUser = value
    }

    /**
     * @param value The name or ARN of the secret that enables access to the database.
     */
    @JvmName("ivmouvfcvjdekrjg")
    public suspend fun secretsManagerArn(`value`: Output<String>) {
        this.secretsManagerArn = value
    }

    /**
     * @param value The SQL statement text to run.
     */
    @JvmName("hutrxlxlfvmipdvt")
    public suspend fun sql(`value`: Output<String>) {
        this.sql = value
    }

    /**
     * @param value The name of the SQL statement.
     */
    @JvmName("kkepphpgqysbwayp")
    public suspend fun statementName(`value`: Output<String>) {
        this.statementName = value
    }

    /**
     * @param value Indicates whether to send an event back to EventBridge after the SQL statement runs.
     */
    @JvmName("ovhqwfspitvtkqin")
    public suspend fun withEvent(`value`: Output<Boolean>) {
        this.withEvent = value
    }

    /**
     * @param value The name of the database.
     */
    @JvmName("ycdudjqfgjqvadmw")
    public suspend fun database(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.database = mapped
    }

    /**
     * @param value The database user name.
     */
    @JvmName("xmxralufhbswhwvl")
    public suspend fun dbUser(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dbUser = mapped
    }

    /**
     * @param value The name or ARN of the secret that enables access to the database.
     */
    @JvmName("egojdkbhiwuyphpr")
    public suspend fun secretsManagerArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secretsManagerArn = mapped
    }

    /**
     * @param value The SQL statement text to run.
     */
    @JvmName("yxunsfnmhuduvuvp")
    public suspend fun sql(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sql = mapped
    }

    /**
     * @param value The name of the SQL statement.
     */
    @JvmName("csrnoceqrifydoqt")
    public suspend fun statementName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.statementName = mapped
    }

    /**
     * @param value Indicates whether to send an event back to EventBridge after the SQL statement runs.
     */
    @JvmName("anscfeiipvxgreuv")
    public suspend fun withEvent(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.withEvent = mapped
    }

    internal fun build(): EventTargetRedshiftTargetArgs = EventTargetRedshiftTargetArgs(
        database = database ?: throw PulumiNullFieldException("database"),
        dbUser = dbUser,
        secretsManagerArn = secretsManagerArn,
        sql = sql,
        statementName = statementName,
        withEvent = withEvent,
    )
}
