@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudwatch.kotlin.inputs

import com.pulumi.aws.cloudwatch.inputs.EventTargetRetryPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property maximumEventAgeInSeconds The age in seconds to continue to make retry attempts.
 * @property maximumRetryAttempts maximum number of retry attempts to make before the request fails
 */
public data class EventTargetRetryPolicyArgs(
    public val maximumEventAgeInSeconds: Output<Int>? = null,
    public val maximumRetryAttempts: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.aws.cloudwatch.inputs.EventTargetRetryPolicyArgs> {
    override fun toJava(): com.pulumi.aws.cloudwatch.inputs.EventTargetRetryPolicyArgs =
        com.pulumi.aws.cloudwatch.inputs.EventTargetRetryPolicyArgs.builder()
            .maximumEventAgeInSeconds(maximumEventAgeInSeconds?.applyValue({ args0 -> args0 }))
            .maximumRetryAttempts(maximumRetryAttempts?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EventTargetRetryPolicyArgs].
 */
@PulumiTagMarker
public class EventTargetRetryPolicyArgsBuilder internal constructor() {
    private var maximumEventAgeInSeconds: Output<Int>? = null

    private var maximumRetryAttempts: Output<Int>? = null

    /**
     * @param value The age in seconds to continue to make retry attempts.
     */
    @JvmName("hangbigjxysyjjuf")
    public suspend fun maximumEventAgeInSeconds(`value`: Output<Int>) {
        this.maximumEventAgeInSeconds = value
    }

    /**
     * @param value maximum number of retry attempts to make before the request fails
     */
    @JvmName("gjwwpcicgksiqfnb")
    public suspend fun maximumRetryAttempts(`value`: Output<Int>) {
        this.maximumRetryAttempts = value
    }

    /**
     * @param value The age in seconds to continue to make retry attempts.
     */
    @JvmName("oedtnpegtpgqciti")
    public suspend fun maximumEventAgeInSeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maximumEventAgeInSeconds = mapped
    }

    /**
     * @param value maximum number of retry attempts to make before the request fails
     */
    @JvmName("aejsplfvqrclanob")
    public suspend fun maximumRetryAttempts(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maximumRetryAttempts = mapped
    }

    internal fun build(): EventTargetRetryPolicyArgs = EventTargetRetryPolicyArgs(
        maximumEventAgeInSeconds = maximumEventAgeInSeconds,
        maximumRetryAttempts = maximumRetryAttempts,
    )
}
