@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudwatch.kotlin.inputs

import com.pulumi.aws.cloudwatch.inputs.EventTargetSagemakerPipelineTargetArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property pipelineParameterLists List of Parameter names and values for SageMaker Model Building Pipeline execution.
 */
public data class EventTargetSagemakerPipelineTargetArgs(
    public val pipelineParameterLists: Output<List<EventTargetSagemakerPipelineTargetPipelineParameterListArgs>>? = null,
) : ConvertibleToJava<com.pulumi.aws.cloudwatch.inputs.EventTargetSagemakerPipelineTargetArgs> {
    override fun toJava(): com.pulumi.aws.cloudwatch.inputs.EventTargetSagemakerPipelineTargetArgs =
        com.pulumi.aws.cloudwatch.inputs.EventTargetSagemakerPipelineTargetArgs.builder()
            .pipelineParameterLists(
                pipelineParameterLists?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [EventTargetSagemakerPipelineTargetArgs].
 */
@PulumiTagMarker
public class EventTargetSagemakerPipelineTargetArgsBuilder internal constructor() {
    private var pipelineParameterLists:
        Output<List<EventTargetSagemakerPipelineTargetPipelineParameterListArgs>>? = null

    /**
     * @param value List of Parameter names and values for SageMaker Model Building Pipeline execution.
     */
    @JvmName("uewvporjhmqimsbd")
    public suspend fun pipelineParameterLists(`value`: Output<List<EventTargetSagemakerPipelineTargetPipelineParameterListArgs>>) {
        this.pipelineParameterLists = value
    }

    @JvmName("bucimcdgoesvwsxa")
    public suspend fun pipelineParameterLists(vararg values: Output<EventTargetSagemakerPipelineTargetPipelineParameterListArgs>) {
        this.pipelineParameterLists = Output.all(values.asList())
    }

    /**
     * @param values List of Parameter names and values for SageMaker Model Building Pipeline execution.
     */
    @JvmName("heclaphwhbyilieg")
    public suspend fun pipelineParameterLists(values: List<Output<EventTargetSagemakerPipelineTargetPipelineParameterListArgs>>) {
        this.pipelineParameterLists = Output.all(values)
    }

    /**
     * @param value List of Parameter names and values for SageMaker Model Building Pipeline execution.
     */
    @JvmName("fyfcbxmxehjxliuf")
    public suspend fun pipelineParameterLists(`value`: List<EventTargetSagemakerPipelineTargetPipelineParameterListArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pipelineParameterLists = mapped
    }

    /**
     * @param argument List of Parameter names and values for SageMaker Model Building Pipeline execution.
     */
    @JvmName("qymrmxyqdvbpyvxb")
    public suspend fun pipelineParameterLists(argument: List<suspend EventTargetSagemakerPipelineTargetPipelineParameterListArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            EventTargetSagemakerPipelineTargetPipelineParameterListArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.pipelineParameterLists = mapped
    }

    /**
     * @param argument List of Parameter names and values for SageMaker Model Building Pipeline execution.
     */
    @JvmName("jexyhbcfgvpbtmnb")
    public suspend fun pipelineParameterLists(vararg argument: suspend EventTargetSagemakerPipelineTargetPipelineParameterListArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            EventTargetSagemakerPipelineTargetPipelineParameterListArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.pipelineParameterLists = mapped
    }

    /**
     * @param argument List of Parameter names and values for SageMaker Model Building Pipeline execution.
     */
    @JvmName("dfasypnvmcxfquxq")
    public suspend fun pipelineParameterLists(argument: suspend EventTargetSagemakerPipelineTargetPipelineParameterListArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                EventTargetSagemakerPipelineTargetPipelineParameterListArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.pipelineParameterLists = mapped
    }

    /**
     * @param values List of Parameter names and values for SageMaker Model Building Pipeline execution.
     */
    @JvmName("jcvmnpeaensjnnen")
    public suspend fun pipelineParameterLists(vararg values: EventTargetSagemakerPipelineTargetPipelineParameterListArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.pipelineParameterLists = mapped
    }

    internal fun build(): EventTargetSagemakerPipelineTargetArgs =
        EventTargetSagemakerPipelineTargetArgs(
            pipelineParameterLists = pipelineParameterLists,
        )
}
