@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudwatch.kotlin.inputs

import com.pulumi.aws.cloudwatch.inputs.EventTargetSqsTargetArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property messageGroupId The FIFO message group ID to use as the target.
 */
public data class EventTargetSqsTargetArgs(
    public val messageGroupId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.cloudwatch.inputs.EventTargetSqsTargetArgs> {
    override fun toJava(): com.pulumi.aws.cloudwatch.inputs.EventTargetSqsTargetArgs =
        com.pulumi.aws.cloudwatch.inputs.EventTargetSqsTargetArgs.builder()
            .messageGroupId(messageGroupId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EventTargetSqsTargetArgs].
 */
@PulumiTagMarker
public class EventTargetSqsTargetArgsBuilder internal constructor() {
    private var messageGroupId: Output<String>? = null

    /**
     * @param value The FIFO message group ID to use as the target.
     */
    @JvmName("omiuptntxffseadq")
    public suspend fun messageGroupId(`value`: Output<String>) {
        this.messageGroupId = value
    }

    /**
     * @param value The FIFO message group ID to use as the target.
     */
    @JvmName("cohetxmichtqtuqs")
    public suspend fun messageGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.messageGroupId = mapped
    }

    internal fun build(): EventTargetSqsTargetArgs = EventTargetSqsTargetArgs(
        messageGroupId = messageGroupId,
    )
}
