@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudwatch.kotlin.inputs

import com.pulumi.aws.cloudwatch.inputs.GetEventBusPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getEventBus.
 * @property name Friendly EventBridge event bus name.
 */
public data class GetEventBusPlainArgs(
    public val name: String,
) : ConvertibleToJava<com.pulumi.aws.cloudwatch.inputs.GetEventBusPlainArgs> {
    override fun toJava(): com.pulumi.aws.cloudwatch.inputs.GetEventBusPlainArgs =
        com.pulumi.aws.cloudwatch.inputs.GetEventBusPlainArgs.builder()
            .name(name.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetEventBusPlainArgs].
 */
@PulumiTagMarker
public class GetEventBusPlainArgsBuilder internal constructor() {
    private var name: String? = null

    /**
     * @param value Friendly EventBridge event bus name.
     */
    @JvmName("lubobjmbvcvymywe")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    internal fun build(): GetEventBusPlainArgs = GetEventBusPlainArgs(
        name = name ?: throw PulumiNullFieldException("name"),
    )
}
