@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudwatch.kotlin.inputs

import com.pulumi.aws.cloudwatch.inputs.GetEventConnectionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getEventConnection.
 * @property name Name of the connection.
 */
public data class GetEventConnectionPlainArgs(
    public val name: String,
) : ConvertibleToJava<com.pulumi.aws.cloudwatch.inputs.GetEventConnectionPlainArgs> {
    override fun toJava(): com.pulumi.aws.cloudwatch.inputs.GetEventConnectionPlainArgs =
        com.pulumi.aws.cloudwatch.inputs.GetEventConnectionPlainArgs.builder()
            .name(name.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetEventConnectionPlainArgs].
 */
@PulumiTagMarker
public class GetEventConnectionPlainArgsBuilder internal constructor() {
    private var name: String? = null

    /**
     * @param value Name of the connection.
     */
    @JvmName("vdbvhbirnurootxw")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    internal fun build(): GetEventConnectionPlainArgs = GetEventConnectionPlainArgs(
        name = name ?: throw PulumiNullFieldException("name"),
    )
}
